# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Canonicalize a title.  We upper-case everything, and strip out  all #
# funny  chars.   If  $articles  is  enabled,  we  look  for articles #
# initially and after a comma, and delete them.                       #
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
sub CTitle {
	local($name) = @_;
	local($lcs,$ucs);
	($ucs = $name) =~ s/[^A-Z0-9]+//g;	# Extract upper-case letters and digits
	($lcs = $name) =~ s/[^a-z]+//g;		# Extract lower-case letters 
	print V "canon: name=\"$name\" lcs=\"$lcs\" ucs=\"$ucs\"\n" if  $V>5;
	if ($ucs && $lcs) {					# Both cases used
		$name =~ s/^[^A-Z0-9]+//;		# Strip stuff before first upper-case letter
		print V "canon: Mixed-case \"$name\"\n" if $V>5;
	} elsif (!$ucs && $lcs) {			# All lower case
		print V "canon: Lower-case \"$name\" curious\n" if $V>5;
	} elsif ($ucs && !$lcs) {			# All upper case
		print V "canon: Upper-case \"$name\" suspect.\n" if $V>5;
	} else {							# No letters at all
		print V "canon: Name \"$name\" with no letters rejected.\n" if $V>5;
		return '';
	}
	if ($articles eq '-') {
		$name =~ s/^the\s+//i;
		$name =~ s/^an?\s+//i;
		$name =~ s/^l[ae]?s?\s+//i;
		$name =~ s/,s*the\s+//i;
		$name =~ s/,s*an?\s+//i;
		$name =~ s/,s*l[ae]?s?\s+//i;
	}
	$name = uc($name);	# Upper-case everything
	$name =~ s"&(\w)\w*;"$1"g;	# De-htmlize the name
#	$name =~ s/,.*//;	# Discard everything after a comma
	$name =~ s"\W+""g;	# Delete non-alpha chars
#	$Tname{$name} = 1;	# Note that we've seen the name
	return $name;
}
1;
