
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* This is a limited substitute for the more general MakStr*() functions in the *
* str package.  This routine doesn't do much checking of its args.  It assumes *
* the three pointers are valid, and will bomb if they're not.  But it  runs  a *
* LOT  faster than MakStrMF(), which we had been using.  But we no longer free *
* the contents of any of our strings; we just set the length to zero and  keep *
* the space for reuse, so this isn't a problem.                                *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
Str *setStr(
	Str *sp,	// String to fill
	char*vp,	// Value
	int  ln,	// Length, or -1 if null-terminated
	char*ds)	// Description, for messages
{	int  n;		// Bytes to allocate
	int  i;
	Fenter("setStr");
	if (ln < 0) ln = strlen(vp);
	n = Max(ln+mempad,minstrlen);
	if (chkchunks) chkblock(sp->v,sp->l,ds);
	if (n > sp->m) {
		if (sp->v && sp->m) {
			if (chkchunks) chkblock(sp->v,sp->l,"setStr before resize");
			sp->v = (char*)memBlock(sp->v,sp->m,n+1,ds);
			if (chkchunks) chkblock(sp->v,sp->l,"setStr after resize");
		} else {
			sp->v = (char*)memBlock(0,0,n+1,ds);
			if (chkchunks) chkblock(sp->v,sp->l,"setStr after alloc");
		}
		unless(sp->v) {
			V1 "### Can't get %d bytes for \"%s\" string [Err %d=%s=%s] ###",n,ds,Errinfo);
			Fail;
		}
		if (chkchunks) chkblock(sp->v,sp->l,Fctname);
		sp->m = n;
	}
	if (ln > 0) bcopy(vp,sp->v,ln);
	sp->v[ln] = 0;
	sp->l = ln;
	V6 "Str %s=%s",ds,QSP(sp) V;
	FExit;
	return sp;
fail:
	FExit;
	return 0;
}

