/*
Copyright, 2002, Isect
*/
#include <stdio.h>
#include <errno.h>
#include "isdio.h"

int main(int argc, char **argv)
{
	int bytes;
	SOCKET sock;
	isdHeader header;
	char *msgBuffer;

	isdLogInit(argc, argv);

	if (argc >= ISDARGMAX) {
		if ((sock = isdConnect(argv)) != -1) {
			for (;;) {
				if (msgBuffer = isdRecv(sock, &header)) {
					exit(1);
				}
				else
					break;
			}
			isdLog("Worker %s exiting\n", argv[ISDARGWID], strerror(errno));
			isdLogout(sock);
		}
		else
			isdError("isdConnect(): %s\n", strerror(errno));
	}
	else
		fprintf(stderr, "Incorrect number of arguments\n");
	return 0;
}
