#include "isectd.h"
#include <limits.h>

#define ANYBODY INT_MIN			/* something like -0x80000000 */

void 
isdTaskMaster(void)
{
	static int lastpri = ANYBODY;
	Node *node1, *node2;
	isdClient *client;
	isdWorker *worker;
	isdService *service;

	if (isdData.IdleWorkers.head != QNULL) {
		for (node1 = QNULL; (node1 = QueueSearch(&isdData.PriList, QEQ,
					  offsetof(isdClient, ready), 1, node1)) != QNULL;) {

			client = (isdClient *) node1;
			isdLogEvent("found client 0x%x, priority = %d", client, client->priority);

			if (client->priority <= lastpri || lastpri == ANYBODY) {
				lastpri = client->priority;
/*
   if workerid in the header of the message from the client is not 0
   search for that worker, otherwise look for any worker of that service
 */
				worker = (isdWorker *) client->worker;
				if (worker && worker->ready)
					isdToWorker(worker);

				else {
					for (node2 = QNULL; (node2 = QueueSearch(&isdData.IdleWorkers, QEQ,
															 offsetof(isdWorker, service_id), client->service_id, node2)) != QNULL;) {

						worker = (isdWorker *) node2;
						isdLogEvent("found worker 0x%x (%s) for client 0x%x",
									worker, worker->name, client);

						isdBusyWorker(worker, client);

						if (isdToWorker(worker) >= 0) {
							isdPriList((isdClient *) RemoveNode((Node *) client));
							if (client->blocked == 0)
								if (!FD_ISSET(client->socket, &isdData.allfds))
									FD_SET(client->socket, &isdData.allfds);

							lastpri = ANYBODY;
							break;
						}
						else {
							isdError("isdToWorker() returned <= 0\n");
							isdLogEvent("error isdSend()ing to worker 0x%x for client 0x%x", worker, client);
							/* client still needs it, don't free() it */
							isdLazyWorker(worker);
							if (isdWorkerStartable(worker))
								isdStartWorkers();
						}
					}
					if (node2 == QNULL)
						isdLogEvent("No idle workers found for client 0x%x, client->id %d", client, client->id);
				}
			}
			else {
				isdLogEvent("client 0x%x (%d) skipped: lastpri = %d, client->priority = %d",
						  client, client->id, lastpri, client->priority);
				break;
			}
		}
	}
}
