#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include "isectd.h"

void 
isdClientLogin(fd_set readfds)
{
	fd_set myfds;
	int address_len;
	isdService *service;
	isdClient *client = NULL;
	isdHeader header;
	char *msgBuffer;
	isdBadge badge;
	Node *node;
	struct timeval timeout;
	struct hostent *he;

	if (FD_ISSET(isdData.req_socket, &readfds)) {
		client = (isdClient *) calloc(sizeof *client, 1);
		address_len = sizeof(client->sockaddr);
		if ((client->socket = accept(isdData.req_socket, (struct sockaddr *) &client->sockaddr, &address_len)) >= 0) {
			isdSockOpts(client->socket);
			FD_ZERO(&myfds);
			FD_SET(client->socket, &myfds);
			timeout.tv_sec = 10;
			timeout.tv_usec = 0;
			if (select(client->socket + 1, &myfds, (fd_set *) 0, (fd_set *) 0, &timeout) == 1) {
				if ((msgBuffer = isdRecv(client->socket, &header))) {
					memcpy((char *) &badge, msgBuffer, sizeof badge);
					client->priority = ntohl(badge.priority);
					client->hostpid = ntohl(badge.hostpid);
					client->blockable = (short) ntohl(badge.blockable);
					client->id = ++isdData.NextClientID;
					client->ready = 0;
					client->worker = NULL;
					client->login_time = time(0);

					node = QueueByteCmp((Queue *) & isdData.ServiceList, QEQ, offsetof(isdService, name), badge.service, -1, QNULL);
					if (node != QNULL) {
						service = (isdService *) node;
						client->service = service;
						client->service_id = service->id;
						he = gethostbyaddr((char *) &client->sockaddr.sin_addr, sizeof(struct in_addr), client->sockaddr.sin_family);
						strcpy(client->loghost, he ? he->h_name : "unknown");

						isdLogEvent("client: priority=%d, hostpid=%d, id=%d, loghost=%s", client->priority, client->hostpid, client->id, client->loghost);
						isdPriList(client);
						FD_SET(client->socket, &isdData.allfds);
						isdLog("login client %d\n", client->id);
						if (QueueItems(&isdData.PriList) >= isdMaxUsers())
							isdStopListening();
					}
				}
				else
					isdError("isdRecv()ing client priority\n");
			}
			else
				isdError("select()ing, waiting for client to complete login\n");
		}
		else
			isdError("accept()ing on isectd's socket\n");
	}

	if (client)
		if (!client->service_id)
			if (client->socket) {
				close(client->socket);
				free((char *) client);
			}
}
