#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dtwle.h>
#include "isdio.h"

/*
Thus file implements the interface functions so Net.Data can call
isect IO routines.  It's kinda wierd where the IN and OUT
parameters went, since Net.Data doesn't implement the
concept of functions.


The Net.Data function block statements should look like:
%FUNCTION(ISD_LE) isdLogin(IN host, service) RETURNS (socket) { %}
%FUNCTION(ISD_LE) isdLogout(IN socket) { %}
%FUNCTION(ISD_LE) isdSend(IN socket, message) RETURNS (bytes) { %}
%FUNCTION(ISD_LE) isdRecv(IN socket) RETURNS (message) { %}
*/

int dtwExternal(dtw_lei_t * le_interface, dtw_parm_data_t *parmArray)
{
	static int socket = -1;
	int rc = 0, bytes;
	char *cp;
	isdHeader header;
	char cBytes[32];

	cp = parmArray[0].parm_value;
	if (strcmp(le_interface->function_name, "isdLogin") == 0) {
		socket = isdLogin(
			parmArray[0].parm_value,
			parmArray[1].parm_value,
			2);
		sprintf(cBytes, "%d", socket);
		parmArray[2].parm_value = dtw_strdup(cBytes);
	}

	else if (strcmp(le_interface->function_name, "isdLogout") == 0) {
		socket = atoi(parmArray[0].parm_value);
		isdLogout(socket);
	}

	else if (strcmp(le_interface->function_name, "isdSend") == 0) {
		socket = atoi(parmArray[0].parm_value);

		memset((char *) &header, 0, sizeof header);
		header.reply = 1;

		bytes = isdSend(socket, parmArray[1].parm_value, -1, &header);
		sprintf(cBytes, "%d", bytes);
		if (cp = parmArray[2].parm_value)
			dtw_free(cp);
		parmArray[2].parm_value = dtw_strdup(cBytes);
	}

	else if (strcmp(le_interface->function_name, "isdRecv") == 0) {
		socket = atoi(parmArray[0].parm_value);

		cp = isdRecv(socket, &header);
		if (cp) {
			if (parmArray[1].parm_value)
				dtw_free(parmArray[1].parm_value);
			parmArray[1].parm_value = dtw_strdup(cp);
		}
	}

	return rc;
}
