#ifndef RMT_H
#define RMT_H

#ifdef _Windows
#include <winsock.h>
#include <dir.h>
#include <io.h>
#define MAXPATHLEN 1024
#else
#include <sys/param.h>
#include <sys/wait.h>
#define SOCKET int
#endif
#include <errno.h>
#include <signal.h>
#include "libisect.h"
#include "queues.h"
#include "isdio.h"

#ifndef SCOPE
#define SCOPE extern
#endif

struct ReplyTo {
		  Node node;
        char portname[32];
        int pid;
#ifdef SYSV
		union wait statusp;
#else
		int statusp;
#endif
};

SCOPE Queue ReplyToQueue;
SCOPE int SigChildOccurred;
SCOPE char rmt_pathname[MAXPATHLEN];

#define MAXARGS 11

extern char *rmtrenice(char *);
extern int rmtdo(SOCKET sock, char *command);

#endif
