#!/bin/sh
############################
# Author   $Author: rudi $
# Date     $Date: 1999/08/23 14:06:46 $
# cvsid = "$Header: /u/cvs/isect/demo/spawn-test.sh,v 1.2 1999/08/23 14:06:46 rudi Exp $"
# Revision $Revision: 1.2 $
############################
# Tool to spawn isect test script.
############################
# Log      $Log: spawn-test.sh,v $
# Log      Revision 1.2  1999/08/23 14:06:46  rudi
# Log      New test scripts
# Log                                                   
#
############################

DEF_CLIENTS=10
DEF_TRANS=20
DEF_HOST="127.0.0.1"
prog_name=$0

Usage() {
  echo "This a testing script for the isect system"
  echo "Please run ${prog_name} as follows"
  echo "  ${prog_name}"
  echo "  ${prog_name} num_clients num_transactions"
  echo "  ${prog_name} num_clients num_transactions host_isect"
  echo
  echo "eg. ${prog_name} 10 20"
  echo "    ${prog_name} 10 20 127.0.0.1"
  echo 
  echo "Defaults are:"
  echo "       num_clients=${DEF_CLIENTS}"
  echo "  num_transactions=${DEF_TRANS}"
  echo "        host_isect=${DEF_HOST}"
  echo
  exit
}


case $# in
  0)
    num_clients=${DEF_CLIENTS}
    num_transactions=${DEF_TRANS}
    isect_host=${DEF_HOST}
    ;;
  2)
    num_clients=$1
    num_transactions=$2 
    isect_host=${DEF_HOST}
    ;;
  3)
    num_clients=$1
    num_transactions=$2 
    isect_host=$3
    ;;
  *)
    Usage
    ;;
esac

cnt=0

while test ${cnt} -ne ${num_clients}
do
  test.sh ${num_transactions} ${isect_host} &
  cnt=`expr ${cnt} + 1`
done
