/* Module support include file (interface definition).
 *
 * IRC Services is copyright (c) 1996-2009 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef MODULES_H
#define MODULES_H

/*************************************************************************/

/* Version code for modules.  This will be updated whenever a change to the
 * program (structures, etc.) makes existing binary modules incompatible.
 * All modules MUST export a variable `module_version' which is initialized
 * to this constant! */
#define MODULE_VERSION_CODE	0x050033	/* 5.0.51 */

/*************************************************************************/

/* Module information.  The actual structure is defined in module.c, and is
 * opaque to the caller. */
struct Module_;
typedef struct Module_ Module;

/* Callback function prototype. */
typedef int (*callback_t)();

/* Callback priority limits. */
#define CBPRI_MIN	-10000
#define CBPRI_MAX	10000

/*************************************************************************/
/*************************************************************************/

/* Global variables: */

/* Set this to nonzero to allow use_module() and unuse_module() to be used
 * on a module by itself. */
extern int modules_allow_use_self;

/*************************************************************************/

/* Initialization and cleanup: */

extern int modules_init(int ac, char **av);
extern void modules_cleanup(void);
extern void unload_all_modules(void);

/*************************************************************************/

/* Module-level functions: */

/* Load a new module and return the Module pointer, or NULL on error. */
extern Module *load_module(const char *modulename);

/* Remove a module from memory.  Return nonzero on success, zero on
 * failure. */
extern int unload_module(Module *module);

/* Return the Module pointer for the named module, or NULL if no such
 * module exists. */
extern Module *find_module(const char *modulename);

/* Increment or decrement the use count for the given module.  A module
 * cannot be unloaded while its use count is nonzero.  The `user' parameter
 * is for internal use; callers should use:
 *     use_module(mod);
 *     unuse_module(mod);
 */
extern void use_module(Module *module, const Module *user);
extern void unuse_module(Module *module, const Module *user);
#define use_module(mod) use_module(mod,module)
#define unuse_module(mod) unuse_module(mod,module)

/* Re-read configuration files for all modules.  Return nonzero on success,
 * zero on failure. */
int reconfigure_modules(void);

/*************************************************************************/

/* Module symbol/information retrieval: */

/* Retrieve the value of the named symbol in the given module.  Return NULL
 * if no such symbol exists.  If `module' is NULL, return the value of the
 * symbol from any module in which it is found (any module may be chosen).
 * Note that this function should not be used for symbols whose value might
 * be NULL, because there is no way to distinguish a symbol value of NULL
 * from an error return. */
extern void *get_module_symbol(Module *module, const char *symname);

/* Retrieve the name of the given module. */
extern const char *get_module_name(Module *module);

/* Retrieve the name of the current module, assuming a pointer to the
 * current module is stored in a variable called `module'. */
#define MODULE_NAME (get_module_name(module))

/*************************************************************************/

/* Callback-related functions: (all functions except register_callback()
 * and call_callback() return nonzero on success and zero on error)
 */

/* Register a new callback list.  "module" is the calling module's own
 * Module pointer, or NULL for core Services callbacks.  Return the
 * callback identifier (a nonnegative integer) or -1 on error. */
extern int register_callback(Module *module, const char *name);

/* Call all functions in a callback list.  Return 1 if a callback returned
 * nonzero, 0 if all callbacks returned zero, or -1 on error.  The _N
 * formats allow passing parameters. */
extern int call_callback_5(Module *module, int id, void *arg1,
			   void *arg2, void *arg3, void *arg4, void *arg5);
#define call_callback(module,id) \
    call_callback_1(module, id, NULL)
#define call_callback_1(module,id,arg1) \
    call_callback_2(module, id, arg1, NULL)
#define call_callback_2(module,id,arg1,arg2) \
    call_callback_3(module, id, arg1, arg2, NULL)
#define call_callback_3(module,id,arg1,arg2,arg3) \
    call_callback_4(module, id, arg1, arg2, arg3, NULL)
#define call_callback_4(module,id,arg1,arg2,arg3,arg4) \
    call_callback_5(module, id, arg1, arg2, arg3, arg4, NULL)
#define call_callback_5(module,id,arg1,arg2,arg3,arg4,arg5) \
    call_callback_5(module, id, (void *)(long)(arg1), (void *)(long)(arg2), \
		    (void *)(long)(arg3), (void *)(long)(arg4), \
		    (void *)(long)(arg5))

/* Delete a callback list. */
extern int unregister_callback(Module *module, int id);

/* Add a function to a callback list with the given priority (higher
 * priority value = called sooner).  Callbacks with the same priority are
 * called in the order they were added. */
int add_callback_pri(Module *module, const char *name, callback_t callback,
		     int priority);

/* Add a function to a callback list with priority 0. */
#define add_callback(module,name,callback) \
    add_callback_pri(module,name,callback,0)

/* Remove a function from a callback list. */
extern int remove_callback(Module *module, const char *name,
			   callback_t callback);

/*************************************************************************/
/*************************************************************************/

/* Module functions: */

int init_module(Module *module);
int exit_module(int shutdown);

/*************************************************************************/

/* Macros to declare a symbol to be exported.  Only one may be used per
 * line, and it must be placed at the beginning of the line and be the only
 * thing on the line (no semicolon at the end).  This does not have any
 * actual effect on compilation, but such lines are extracted to create
 * module symbol lists.  Note that it is not necessary to explicitly list
 * the init_module, exit_module, and module_config symbols (and in fact,
 * doing so will cause an error when linking the final executable).
 *
 * Also note that typedefs cannot be used here; use struct tags instead.
 *
 * Examples:
 *     EXPORT_VAR(const char *,s_NickServ)
 *     EXPORT_ARRAY(char,some_string)  // for "char some_string[]"
 *     EXPORT_FUNC(create_akill)
 */

#define EXPORT_VAR(type,symbol)
#define EXPORT_ARRAY(type,symbol)
#define EXPORT_FUNC(symbol)

/*************************************************************************/
/*************************************************************************/

#endif	/* MODULES_H */
