/*-
 * Copyright (c) 2003-2004 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipa_autorules.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_AUTORULES_H
#define IPA_AUTORULES_H

#ifdef WITH_AUTORULES

#define AUTORULE_NSIZE	10
#define AUTORULE_NALLOC	10

#define AUTORULE_FLAG_ACTIVE	0x1	/* Autorule is active. */

#define AUTORULE_IS_ACTIVE(x)	((x)->arule_flags == AUTORULE_FLAG_ACTIVE)
#define AUTORULE_IS_INACTIVE(x)	(!AUTORULE_IS_ACTIVE(x))

#define AUTORULE_SET_ACTIVE(x)	((x)->arule_flags = AUTORULE_FLAG_ACTIVE)
#define AUTORULE_SET_INACTIVE(x) ((x)->arule_flags = 0)

/*
 * autorule{} section.
 */
struct autorule {
	TAILQ_ENTRY(autorule) queue;	/* Active/inactive autorules queue. */
	char		*name;		/* Name of this autorule. */
	unsigned int	no;		/* Autorule ordinal number. */

	unsigned int	arule_flags;	/* ORed AUTORULE_FLAG_xxx */

	unsigned int	check_sec;	/* Time when to check autorule. */
	unsigned int	inactive_sec;	/* Time when inactivate autorule. */

	const struct tevent *update_tevent; /* { update_time } */
	const struct tevent *append_tevent; /* { append_time } */
	const struct worktime *worktime;/* { worktime } */
	const struct worktime *worktime_rule; /* { worktime_rule } */

	const struct ac_list *ac_list;	/* { ac_list } */
	const struct db_list *db_list;	/* { db_list } */

	signed char	debug_exec;	/* { debug_exec } */

#ifdef WITH_LIMITS
	signed char	debug_limit;	/* { debug_limit } */
	signed char	debug_limit_init; /* { debug_limit_init } */
	struct limits_list limits;	/* All { limit {}} */
#endif

#ifdef WITH_THRESHOLDS
	signed char	debug_threshold;/* { debug_threshold } */
	signed char	debug_threshold_init; /* { debug_threshold_init } */
	struct thresholds_list thresholds; /* All { threshold {}} */
#endif

#ifdef CTL_CHECK_CREDS
	const struct ctl_acl_class *ctl_rule_acl; /* { ctl_rule_acl } */
#endif

	STAILQ_ENTRY(autorule) link;	/* For all autorules list building. */

	unsigned int	nrules;		/* Number of generated rules. */

	struct cmds_rule rc[2];		/* { startup } and { shutdown } */
};

/* List of all autorules. */
STAILQ_HEAD(autorules_list, autorule);

extern signed char debug_autorule;

extern unsigned int autorules_active_check_sec;
extern unsigned int autorules_inactive_check_sec;

extern ipa_marray *rules_ptr_marray;
extern ipa_marray *autorules_marray;
extern struct autorule *autorules;
extern struct autorules_list autorules_list;

extern int	init_autorules(void);
extern int	deinit_autorules(void);
extern int	deinit_dyn_rule(struct rule *);

extern int	autorules_newday(void);
extern int	check_active_autorules(void);
extern int	check_inactive_autorules(void);

extern struct autorule *autorule_by_name(const char *);
extern int	autorules_inherit(void);

#endif /* WITH_AUTORULES */

extern unsigned	int nautorules;
extern unsigned int ndynrules;

extern int	create_rule(const char *, unsigned int, const char *,
		    const char *);
extern int	delete_rule(const char *, unsigned int);

#endif /* !IPA_AUTORULES_H */
