<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_proxy_balancer - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_proxy_balancer</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_balancer.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_balancer.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy_balancer.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Extension de <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> pour le support de
la rpartition de charge</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>proxy_balancer_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_proxy_balancer.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Pour pouvoir fonctionner, ce module <em>requiert</em> le
    chargement de <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. Il fournit le support de
    la rpartition de charge pour les protocoles <code>HTTP</code>,
    <code>FTP</code> et <code>AJP13</code>.
    </p>

    <p>L'algorithme de planification de la rpartition de charge est
    fourni par des modules tels que
    <code class="module"><a href="../mod/mod_lbmethod_byrequests.html">mod_lbmethod_byrequests</a></code>,
    <code class="module"><a href="../mod/mod_lbmethod_bytraffic.html">mod_lbmethod_bytraffic</a></code>,
    <code class="module"><a href="../mod/mod_lbmethod_bybusyness.html">mod_lbmethod_bybusyness</a></code> and
    <code class="module"><a href="../mod/mod_lbmethod_heartbeat.html">mod_lbmethod_heartbeat</a></code>.
    </p>

    <p>Ainsi, pour mettre en oeuvre la rpartition de charge,
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> et
    au moins un des modules fournissant l'algorithme de planification de
    la rpartition de charge doivent tre chargs dans le serveur.</p>

    <div class="warning"><h3>Avertissement</h3>
      <p>N'activez pas la fonctionnalit de mandataire avant d'avoir <a href="mod_proxy.html#access">scuris votre serveur</a>. Les
      serveurs mandataires ouverts sont dangereux non seulement pour
      votre rseau, mais aussi pour l'Internet au sens large.</p>
    </div>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#scheduler">L'algorithme de planification de la rpartition de
    charge</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#stickyness">Rpartition de charge avec abonnement utilisateur
    (stickyness)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#example">Exemples de configuration d'un rpartiteur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#environment">Variables d'environnement exportes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#balancer_manager">Activation du support du gestionnaire de rpartiteur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#stickyness_implementation">Dtails  propos de la rpartition de charge par abonnement
    (stickyness)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#stickyness_troubleshooting">Rsolution des problmes lis  la rpartition de charge par
    abonnement</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="scheduler" id="scheduler">L'algorithme de planification de la rpartition de
    charge</a></h2>
    
    <p>A l'heure actuelle, 3 algorithmes de planification de la
    rpartition de charge sont disponibles : ils se basent
    respectivement sur le comptage des requtes, la mesure du trafic et
    le comptage des requtes en attente. Ils sont contrls par la
    valeur de <code>lbmethod</code> dans la dfinition du rpartiteur.
    Voir la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> pour plus de dtails, et en
    particulier la configuration du rpartiteur et de ses membres.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="stickyness" id="stickyness">Rpartition de charge avec abonnement utilisateur
    (stickyness)</a></h2>
    
    <p>Le rpartiteur supporte l'abonnement utilisateur. Lorsqu'une
    requte est mandate vers un serveur d'arrire-plan particulier,
    toutes les requtes suivantes du mme utilisateur seront alors
    mandates vers le mme serveur d'arrire-plan. De nombreux
    rpartiteurs de charge implmentent cette fonctionnalit via une
    table qui associe les adresses IP des clients aux serveurs
    d'arrire-plan. Cette approche est transparente aux clients et aux
    serveurs d'arrire-plan, mais induit certains problmes :
    distribution de charge ingale si les clients se trouvent eux-mmes
    derrire un mandataire, erreurs d'abonnement lorsqu'un client
    possde une adresse IP dynamique qui peut changer au cours d'une
    session et perte d'abonnement en cas de dpassement de la table de
    correspondances.</p>
    <p>Le module <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> implmente
    l'abonnement selon deux alternatives : les cookies et le codage
    d'URL. Le cookie peut tre fourni par le serveur d'arrire-plan ou
    par le serveur web Apache lui-mme, alors que le codage d'URL est en
    gnral effectu par le serveur d'arrire-plan.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Exemples de configuration d'un rpartiteur</a></h2>
    
    <p>Avant de nous plonger dans les dtails techniques, voici un
    exemple d'utilisation de <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> mettant
    en oeuvre la rpartition de charge entre deux serveurs
    d'arrire-plan :
    </p>

    <pre class="prettyprint lang-config">
&lt;Proxy balancer://mycluster/&gt;
    BalancerMember http://192.168.1.50:80/
    BalancerMember http://192.168.1.51:80/
&lt;/Proxy&gt;
ProxyPass /test balancer://mycluster/
ProxyPassReverse /test balancer://mycluster/
    </pre>



    <p>Voici un autre exemple de rpartiteur de charge avec
    abonnement utilisant <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code>,
    fonctionnant mme si le serveur d'arrire-plan ne dfinit pas de
    cookie de session appropri :
    </p>

    <pre class="prettyprint lang-config">
Header add Set-Cookie "ROUTEID=.%{BALANCER_WORKER_ROUTE}e; path=/" env=BALANCER_ROUTE_CHANGED
&lt;Proxy balancer://mycluster/&gt;
    BalancerMember http://192.168.1.50:80/ route=1
    BalancerMember http://192.168.1.51:80/ route=2
    ProxySet stickysession=ROUTEID
&lt;/Proxy&gt;
ProxyPass /test balancer://mycluster/
ProxyPassReverse /test balancer://mycluster/
    </pre>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="environment" id="environment">Variables d'environnement exportes</a></h2>
    
    <p>A l'heure actuelle, 6 variables d'environnement sont exportes :</p>

    <dl>
    
    <dt><var><a name="balancer_session_sticky" id="balancer_session_sticky">BALANCER_SESSION_STICKY</a></var></dt>
    <dd>
    <p>Cette variable se voir assigne la valeur de
    <var>stickysession</var> pour la requte courante. Il s'agit du
    nom du cookie ou du paramtre de requte utilis pour les sessions
    avec abonnement.</p>
    </dd>

    
    <dt><var><a name="balancer_session_route" id="balancer_session_route">BALANCER_SESSION_ROUTE</a></var></dt>
    <dd>
    <p>Cette variable se voit assigne la <var>route</var> interprte
    pour la requte courante.</p>
    </dd>

    
    <dt><var><a name="balancer_name" id="balancer_name">BALANCER_NAME</a></var></dt>
    <dd>
    <p>Cette variable se voit assign le nom du rpartiteur pour la
    requte courante. Il s'agit d'une valeur du style
    <code>balancer://foo</code>.</p>
    </dd>

    
    <dt><var><a name="balancer_worker_name" id="balancer_worker_name">BALANCER_WORKER_NAME</a></var></dt>
    <dd>
    <p>Cette variable se voit assign le nom du membre du groupe de
    rpartition de charge utilis pour la requte courante. Il s'agit
    d'une valeur du style <code>http://hostA:1234</code>.</p>
    </dd>

    
    <dt><var><a name="balancer_worker_route" id="balancer_worker_route">BALANCER_WORKER_ROUTE</a></var></dt>
    <dd>
    <p>Cette variable se voit assigne la <var>route</var> du membre du
    groupe de rpartition de charge qui sera utilis pour la requte
    courante.</p>
    </dd>

    
    <dt><var><a name="balancer_route_changed" id="balancer_route_changed">BALANCER_ROUTE_CHANGED</a></var></dt>
    <dd>
    <p>Cette variable est dfinie  1 si la route de la session ne
    correspond pas  celle du membre du groupe de rpartition de charge
    (BALANCER_SESSION_ROUTE != BALANCER_WORKER_ROUTE), ou si la session
    ne possde pas encore de route tablie. Elle peut servir 
    dterminer quand il est ventuellement ncessaire d'envoyer au
    client une route mise  jour lorsque les sessions persistantes sont
    utilises.</p>
    </dd>
    </dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="balancer_manager" id="balancer_manager">Activation du support du gestionnaire de rpartiteur</a></h2>
    
    <p>Cette fonctionnalit <em>ncessite</em> le chargement du module
    <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>. Le gestionnaire de rpartiteur permet
    la mise  jour dynamique des membres du groupe de rpartition de
    charge. Vous pouvez utiliser le gestionnaire de rpartiteur pour
    modifier le facteur de charge d'un membre particulier, ou passer ce
    dernier en mode hors ligne.
    </p>

    <p>Ainsi, pour mettre en oeuvre la gestion du rpartiteur de charge,
    <code class="module"><a href="../mod/mod_status.html">mod_status</a></code> et <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code>
    doivent tre chargs dans le serveur.</p>

    <p>Pour permettre la gestion du rpartiteur de charge aux
    navigateurs appartenant au domaine example.com, ajoutez ces lignes 
    votre fichier de configuration <code>httpd.conf</code> :</p>
<pre class="prettyprint lang-config">
&lt;Location /balancer-manager&gt;
    SetHandler balancer-manager
    Require host example.com
&lt;/Location&gt;
</pre>


    <p>Vous pourrez alors accder au gestionnaire du rpartiteur de
    charge en utilisant un navigateur web pour afficher la page
    <code>http://nom.de.votre.serveur/balancer-manager</code>. Notez que
    pour pouvoir contrler dynamiquement un membre de groupe de
    rpartition, ce dernier ne doit pas tre dfini au sein d'une
    section <code>&lt;Location ...&gt;</code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="stickyness_implementation" id="stickyness_implementation">Dtails  propos de la rpartition de charge par abonnement
    (stickyness)</a></h2>
    
    <p>Si l'abonnement s'appuie sur un cookie, vous devez dfinir le nom
    de ce cookie dont le contenu prcise le serveur d'arrire-plan 
    utiliser. Pour ce faire, on utilise l'attribut
    <var>stickysession</var> avec la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxyset">ProxySet</a></code>. Le nom du cookie est
    sensible  la casse. Le rpartiteur extrait le contenu du cookie et
    recherche un serveur membre dont la <var>route</var> correspond 
    cette valeur. La route doit aussi tre dfinie dans la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxyset">ProxySet</a></code>. Le cookie peut tre dfini
    soit par le serveur d'arrire-plan, soit, comme indiqu dans l'<a href="#example">exemple</a> ci-dessus par le serveur web Apache
    lui-mme.</p>
    <p>Certains serveurs d'arrire-plan, tels qu'Apache Tomcat,
    utilisent une forme sensiblement diffrente de cookie d'abonnement.
    Tomcat ajoute le nom de l'instance Tomcat  la fin de son
    identifiant de session, prcd par un point. Ainsi, si le serveur
    web Apache trouve un point dans la valeur du cookie d'abonnement, il
    n'utilisera que la partie situe aprs ce point pour
    rechercher sa route. Pour que Tomcat puisse connatre son nom
    d'instance, vous devez dfinir l'attribut <code>jvmRoute</code> dans
    son fichier de configuration <code>conf/server.xml</code>  la
    valeur de la <var>route</var> du serveur qui se connecte au Tomcat
    considr. Le nom du cookie de session utilis par Tomcat (et plus
    gnralement par les applications web Java  base de servlets) est
    <code>JSESSIONID</code> (en majuscules), mais peut tre modifi.</p>

    <p>La seconde mthode pour implmenter l'abonnement est le codage
    d'URL. Ici, le serveur web recherche un paramtre dans l'URL de la
    requte. Le nom du paramtre est spcifi par l'attribut
    <var>stickysession</var>. Pour trouver un serveur membre, on
    recherche un serveur dont la <var>route</var> est gale  la valeur
    du paramtre. Comme il n'est pas ais d'extraire et de manipuler
    tous les liens URL contenus dans les rponses, le travail consistant
     ajouter les paramtres  chaque lien est gnralement effectu par
    le serveur d'arrire-plan qui gnre le contenu. Bien qu'il soit
    possible dans certains cas d'effectuer ces ajouts au niveau du
    serveur web via les modules <code class="module"><a href="../mod/mod_substitute.html">mod_substitute</a></code> ou
    <code class="module"><a href="../mod/mod_sed.html">mod_sed</a></code>, cette mthode peut dgrader les
    performances.</p>

    <p>Les standards Java implmentent le codage d'URL de manire
    sensiblement diffrente. Ils ajoutent une information de chemin 
    l'URL en utilisant un point-virgule (<code>;</code>) comme
    sparateur, puis ajoutent enfin l'identifiant de session. Comme dans
    le cas des cookies, Apache Tomcat peut insrer la valeur de
    l'attribut <code>jvmRoute</code> dans cette information de chemin.
    Pour qu'Apache puisse trouver ce genre d'information de chemin, vous
    devez dfinir <code>scolonpathdelim</code>  <code>On</code> dans la
    directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> ou
    <code class="directive"><a href="../mod/mod_proxy.html#proxyset">ProxySet</a></code>.</p>

    <p>Enfin, vous pouvez utiliser simultanment les cookies et le codage
    d'URL en dfinissant le nom du cookie et le nom du paramtre d'URL
    spars par une barre verticale (<code>|</code>) comme dans
    l'exemple suivant :</p>
    <pre class="prettyprint lang-config">
ProxyPass /test balancer://mycluster/ stickysession=JSESSIONID|jsessionid scolonpathdelim=On
&lt;Proxy balancer://mycluster&gt;
    BalancerMember http://192.168.1.50:80/ route=node1
    BalancerMember http://192.168.1.51:80/ route=node2
&lt;/Proxy&gt;
    </pre>

    <p>Si le cookie et le paramtre de requte fournissent tous deux une
    information de route correcte pour la mme requte, c'est
    l'information en provenance du paramtre de requte qui sera
    retenue.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="stickyness_troubleshooting" id="stickyness_troubleshooting">Rsolution des problmes lis  la rpartition de charge par
    abonnement</a></h2>
    
    <p>Si vous tes confront  des erreurs d'abonnement, comme la
    ncessit pour les utilisateurs de se reconnecter suite  une perte
    de session d'application, vous devez tout d'abord vrifier si ceci
    n'est pas du  une indisponibilit sporadique des serveurs
    d'arrire-plan ou  une erreur de configuration. La prsence de
    messages d'erreur de type proxy dans le journal des erreurs d'Apache
    pourra rvler des problmes de stabilit au niveau des serveurs
    d'arrire-plan.</p>
    <p>Pour contrler votre configuration, regardez tout d'abord si
    l'abonnement est  base de cookie ou de codage d'URL. L'tape
    suivante consiste  enregistrer certaines donnes dans le journal
    des accs en utilisant un <code class="directive"><a href="../mod/mod_log_config.html#format&#10;    de journalisation">format
    de journalisation</a></code> personnalis. Les champs intressants
    sont les suivants :</p>
    <dl>
    <dt><code>%{MONCOOKIE}C</code></dt>
    <dd>La valeur que contient le cookie de nom <code>MONCOOKIE</code>.
    Le nom doit correspondre au nom dfini par l'attribut
    <var>stickysession</var>.</dd>
    <dt><code>%{Set-Cookie}o</code></dt>
    <dd>Ce champ contient tout cookie dfini par le serveur
    d'arrire-plan. Vous pouvez ainsi vrifier si le serveur
    d'arrire-plan dfinit bien le cookie de session auquel vous vous
    attendez, et  quelle valeur il est dfini.</dd>
    <dt><code>%{BALANCER_SESSION_STICKY}e</code></dt>
    <dd>Le nom du cookie ou du paramtre de requte utilis pour la
    recherche de l'information de routage.</dd>
    <dt><code>%{BALANCER_SESSION_ROUTE}e</code></dt>
    <dd>L'information de routage extraite de la requte.</dd>
    <dt><code>%{BALANCER_WORKER_ROUTE}e</code></dt>
    <dd>La route du serveur choisi.</dd>
    <dt><code>%{BALANCER_ROUTE_CHANGED}e</code></dt>
    <dd>Contient la valeur <code>1</code> si la route extraite de la
    requte est diffrente de la route du serveur ; autrement dit, le
    traitement de la requte n'a pas pu tre effectu dans le cadre
    d'une rpartition de charge par abonnement.</dd>
    </dl>
    <p>Les pertes de session sont souvent dues  des expirations de
    session dont la valeur peut en gnral tre configure au niveau du
    serveur d'arrire-plan.</p>
    <p>Si le niveau de journalisation est dfini  <code>debug</code> ou
    plus, le rpartiteur journalise aussi des informations dtailles 
    propos de l'abonnement dans le journal des erreurs, ce qui facilite
    la rsolution des problmes d'abonnement. Notez cependant que le
    volume de journalisation pourra alors s'avrer trop important pour
    un serveur en production sous forte charge.</p>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy_balancer.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy_balancer.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy_balancer.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_proxy_balancer.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>