<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Apache et les variables d'environnement - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Apache et les variables d'environnement</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/env.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/env.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

     <p>Deux types de variables d'environnement affectent le serveur
     HTTP Apache.</p>

    <p>Le premier type correspond aux variables d'environnement
    contrles par le systme d'exploitation sous-jacent et dfinies
    avant le dmarrage du serveur. Leurs valeurs peuvent tre utilises
    directement dans les fichiers de configuration, et peuvent
    ventuellement tre transmises aux scripts CGI et SSI via la
    directive PassEnv.</p>

    <p>Le second type correspond aux variables nommes appeles aussi
    <em>variables d'environnement</em> dans lesquelles le serveur HTTP
    Apache stocke des informations via un mcanisme spcial. Ces
    informations peuvent servir  contrler diverses oprations comme
    l'enregistrement des traces ou le contrle d'accs. On utilise aussi ces
    variables dans le mcanisme de communication avec les programmes externes
    comme les scripts CGI. Ce document prsente diffrentes mthodes pour
    manipuler et utiliser ces variables.</p>

    <p>Bien que ces variables soient rfrences comme <em>variables
    d'environnement</em>, il ne faut pas les confondre avec les variables
    d'environnement contrles par le systme d'exploitation sous-jacent.
    En fait, ces variables sont stockes et manipules dans une structure
    interne  Apache. Elles ne deviennent de vritables variables
    d'environnement du systme d'exploitation que lorsqu'elles sont mises  la
    disposition de scripts CGI et de scripts inclus ct serveur (SSI). Si vous
    souhaitez manipuler l'environnement du systme d'exploitation sous lequel
    le serveur s'excute, vous devez utiliser les mcanismes standards de
    manipulation de l'environnement fournis par l'interprteur de commandes
    (shell) de votre systme d'exploitation.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#setting">Dfinition des variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#using">Utilisation des variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#special">Variables d'environnement  usage spcial</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="setting" id="setting">Dfinition des variables d'environnement</a></h2>
    
    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code></li><li><code class="module"><a href="./mod/mod_env.html">mod_env</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li><li><code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code></li><li><code class="module"><a href="./mod/mod_unique_id.html">mod_unique_id</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatchnocase">BrowserMatchNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvifnocase">SetEnvIfNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#unsetenv">UnsetEnv</a></code></li></ul></td></tr></table>

    <h3><a name="basic-manipulation" id="basic-manipulation">Manipulations de base de l'environnement</a></h3>
        

        <p>La mthode la plus lmentaire pour dfinir une variable
	d'environnement au niveau d'Apache consiste  utiliser la directive
	inconditionnelle <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code>. Les variables peuvent aussi tre transmises depuis
	l'environnement du shell  partir duquel le serveur a t dmarr en
	utilisant la directive
        <code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code>.</p>

    
    <h3><a name="conditional" id="conditional">Dfinitions conditionnelles en fonction des requtes</a></h3>
        

        <p>Pour plus de souplesse, les directives fournies par le module
        <code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code> permettent de dfinir les
	variables d'environnement en tenant compte des caractristiques
	de chaque requte. Par exemple, une
	variable pourrait n'tre dfinie que lorsqu'un navigateur spcifique
	(User-Agent) a gnr la requte, ou seulement quand un en-tte
	Referer particulier est prsent. La directive
	<code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> du module
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> qui utilise l'option
	<code>[E=...]</code> pour dfinir
	les variables d'environnement apporte encore plus de souplesse.</p>

    
    <h3><a name="unique-identifiers" id="unique-identifiers">Identifiants uniques</a></h3>
        

        <p>Finalement, le module <code class="module"><a href="./mod/mod_unique_id.html">mod_unique_id</a></code> dfinit la variable
	d'environnement <code>UNIQUE_ID</code> pour chaque requte  une valeur
	qui est garantie unique parmi "toutes" les requtes sous des
	conditions trs spcifiques.</p>

    
    <h3><a name="standard-cgi" id="standard-cgi">Variables CGI standards</a></h3>
        

        <p>En plus de l'ensemble des variables d'environnement internes  la
	configuration d'Apache et de celles transmises depuis le shell,
	les scripts CGI	et les pages SSI
	se voient affects un ensemble de variables
	d'environnement contenant des mta-informations  propos de la requte
	comme prconis dans la
	<a href="http://www.ietf.org/rfc/rfc3875">spcification
	sur les CGIs</a>.</p>

    
    <h3><a name="caveats" id="caveats">Quelques mises en garde</a></h3>
        

        <ul>
          <li>Les directives de manipulation de l'environnement ne permettent
	  pas de supplanter ou modifier les variables CGI standards.</li>

          <li>Lorsqu'on utilise <code class="program"><a href="./programs/suexec.html">suexec</a></code> pour excuter des
	  scripts CGI, l'environnement est nettoy et rduit  un ensemble de
	  variables <em>sres</em> avant l'excution du script. La liste des
	  variables <em>sres</em> est dfinie  la compilation dans
          <code>suexec.c</code>.</li>

          <li>Pour des raisons de portabilit, les noms des variables
	  d'environnement ne peuvent contenir que des lettres, des chiffres, et
	  le caractre "souslign". En outre, le premier caractre ne doit pas
	  tre un chiffre. Les caractres qui ne satisfont pas  ces conditions
	  seront remplacs par un caractre "souslign" quand ils seront
	  transmis aux scripts CGI et aux pages SSI.</li>

	  <li>Les contenus d'en-ttes HTTP transmis aux scripts de type
	  CGI ou autre via des variables d'environnement constituent un
	  cas particulier (voir plus loin). Leur nom est converti en
	  majuscules et seuls les tirets sont remplacs par des
	  caractres '_' ("soulign") ; si le format du nom de l'en-tte
	  n'est pas valide, celui-ci est ignor. Voir <a href="#fixheader">plus loin</a> pour une solution de
	  contournement du problme.</li>

          <li>La directive <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code> s'excute assez tard au
	  cours du traitement de la requte, ce qui signifie que des
	  directives telles que <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code> et <code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> ne verront pas
	  les variables qu'elle aura dfinies.</li>
        </ul>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="using" id="using">Utilisation des variables d'environnement</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_authz_host.html">mod_authz_host</a></code></li><li><code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code></li><li><code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code></li><li><code class="module"><a href="./mod/mod_include.html">mod_include</a></code></li><li><code class="module"><a href="./mod/mod_log_config.html">mod_log_config</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_access_compat.html#allow">Allow</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code></li><li><code class="directive"><a href="./mod/mod_access_compat.html#deny">Deny</a></code></li><li><code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code></li><li><code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li></ul></td></tr></table>

    <h3><a name="cgi-scripts" id="cgi-scripts">Scripts CGI</a></h3>
        

        <p>La communication d'informations aux scripts CGI constitue une des
	principales utilisations des variables d'environnement. Comme indiqu
	plus haut, l'environnement transmis aux scripts CGI comprend des
	mta-informations standards  propos de la requte, en plus des
	variables dfinies dans la configuration d'Apache. Pour plus de
	dtails, se rfrer au
        <a href="howto/cgi.html">tutoriel CGI</a>.</p>

    
    <h3><a name="ssi-pages" id="ssi-pages">Pages SSI</a></h3>
        

        <p>Les documents inclus ct serveur (SSI) traits par le filtre
        <code>INCLUDES</code> du module <code class="module"><a href="./mod/mod_include.html">mod_include</a></code>,
	peuvent afficher les
	variables d'environnement  l'aide de l'lment <code>echo</code>,
	et peuvent utiliser des variables d'environnement dans les lments
	de contrle de flux pour rendre certaines parties d'une page
        conditionnelles en fonction des caractristiques de la requte.
	Apache fournit aussi les variables d'environnement CGI standards
	aux pages SSI
	comme indiqu plus haut. Pour plus de dtails, se rfrer au
	<a href="howto/ssi.html">tutoriel SSI</a>.</p>

    
    <h3><a name="access-control" id="access-control">Contrle d'accs</a></h3>
        

        <p>L'accs au serveur peut tre contrl en fonction de la valeur de
	variables d'environnement  l'aide des directives
	<code>allow from env=</code> et <code>deny from env=</code>.
	En association avec la directive
        <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, ceci confre une
	grande souplesse au contrle d'accs au serveur en fonction des
	caractristiques du client. Par exemple, vous pouvez utiliser ces
        directives pour interdire l'accs depuis un navigateur particulier
	(User-Agent).
        </p>

    
    <h3><a name="logging" id="logging">Enregistrement conditionnel des traces</a></h3>
        

        <p>Les variables d'environnement peuvent tre enregistres dans le
	fichier de log des accs  l'aide de l'option <code>%e</code> de la
	directive <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code>.
	En outre, la dcision de tracer ou non les requtes peut tre prise
	en fonction de l'tat de variables d'environnement en utilisant la
	forme conditionnelle de la directive
        <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>. En
	association avec la directive <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, ceci confre une grande souplesse au contrle
	du traage des requtes. Par exemple, vous pouvez choisir de ne pas
	tracer les requtes pour des noms de fichiers se terminant par
	<code>gif</code>, ou encore de ne tracer que les requtes des clients
	n'appartenant pas  votre sous-rseau.</p>

    
    <h3><a name="response-headers" id="response-headers">En-ttes de rponse conditionnels</a></h3>
        

        <p>La directive <code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code>
        peut se baser sur la prsence ou l'absence d'une variable
	d'environnement pour dcider si un certain en-tte HTTP sera plac
	dans la rponse au client. Ceci permet, par exemple, de n'envoyer un
	certain en-tte de rponse que si un en-tte correspondant est prsent
	dans la requte du client.</p>

    

    <h3><a name="external-filter" id="external-filter">Activation de filtres externes</a></h3>
        

        <p>Les filtres externes configurs par le module
	<code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code>  l'aide de la directive <code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code> peuvent tre
	activs de manire conditionnelle en fonction d'une variable
	d'environnement  l'aide des options
        <code>disableenv=</code> et <code>enableenv=</code>.</p>
    

    <h3><a name="url-rewriting" id="url-rewriting">Rcriture d'URL</a></h3>
        

        <p>La forme <code>%{ENV:<em>variable</em>}</code> de
	<em>TestString</em> dans la
	directive <code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>
        permet au moteur de rcriture du module
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> de prendre des
	dcisions conditionnes par des variables d'environnement.
        Notez que les variables accessibles dans
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> sans le prfixe
        <code>ENV:</code> ne sont pas de vritables variables
	d'environnement. Ce sont plutt des variables spcifiques 
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code>
        qui ne sont pas accessibles pour les autres modules.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="special" id="special">Variables d'environnement  usage spcial</a></h2>
    

        <p>Des problmes d'interoprabilit ont conduit  l'introduction de
	mcanismes permettant de modifier le comportement d'Apache lorsqu'il
	dialogue avec certains clients. Afin de rendre ces mcanismes aussi
	souples que possible, ils sont invoqus en dfinissant des variables
	d'environnement, en gnral  l'aide de la directive
	<code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code>, bien que les
	directives <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code> et
	<code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code> puissent aussi tre
	utilises, par exemple.</p>

    <h3><a name="downgrade" id="downgrade">downgrade-1.0</a></h3>
        

        <p>Ceci force le traitement d'une requte comme une requte HTTP/1.0
        mme si elle a t rdige dans un langage plus rcent.</p>

    
    <h3><a name="force-gzip" id="force-gzip">force-gzip</a></h3>
        
          <p>Si le filtre <code>DEFLATE</code> est activ, cette variable
	  d'environnement ignorera les rglages accept-encoding de votre
	  navigateur et enverra une sortie compresse inconditionnellement.</p>
    
    <h3><a name="force-no-vary" id="force-no-vary">force-no-vary</a></h3>
        

        <p>Cette variable entrane la suppression de tout champ
	<code>Vary</code> des en-ttes de la rponse avant que cette dernire
	soit renvoye au client. Certains clients n'interprtent pas ce champ
	correctement, et la dfinition de cette variable permet de contourner
	ce problme, mais implique aussi la dfinition de
	<strong>force-response-1.0</strong>.</p>

    
    <h3><a name="force-response" id="force-response">force-response-1.0</a></h3>
        

      <p>Cette variable force une rponse en langage HTTP/1.0 aux clients
      qui envoient des requtes dans le mme langage. Elle fut implmente 
      l'origine suite  des problmes avec les mandataires d'AOL. Certains
      clients en langage HTTP/1.0 ne ragissent pas correctement face  une
      rponse en langage HTTP/1.1, et cette variable peut tre utilise pour
      assurer l'interoprabilit avec eux.</p>

    

    <h3><a name="gzip-only-text-html" id="gzip-only-text-html">gzip-only-text/html</a></h3>
        

        <p>Positionne  "1", cette variable dsactive le filtre en sortie
	<code>DEFLATE</code> fourni par le module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> pour les
	types de contenu autres que <code>text/html</code>. Si vous prfrez
	utiliser des fichiers compresss statiquement,
	<code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> value aussi la variable (non
	seulement pour gzip, mais aussi pour tous les encodages autres que
	"identity").</p>
    

    <h3><a name="no-gzip" id="no-gzip">no-gzip</a></h3>

        <p>Quand cette variable est dfinie, le filtre <code>DEFLATE</code> du
	module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> est dsactiv, et
        <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> refusera de dlivrer des ressources
	encodes.</p>

    

    <h3><a name="no-cache" id="no-cache">no-cache</a></h3>
    	<p><em>Disponible dans les versions 2.2.12 et ultrieures d'Apache</em></p>

        <p>Lorsque cette variable est dfinie,
	<code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne sauvegardera pas de rponse
	susceptible d'tre mise en cache. Cette variable d'environnement
	n'a aucune incidence sur le fait qu'une rponse dj enregistre
	dans la cache soit utilise ou non pour la requte courante.</p>

    

    <h3><a name="nokeepalive" id="nokeepalive">nokeepalive</a></h3>
        

        <p>Quand cette variable est dfinie, la directive
	<code class="directive"><a href="./mod/core.html#keepalive">KeepAlive</a></code> est dsactive.</p>

    

    <h3><a name="prefer-language" id="prefer-language">prefer-language</a></h3>

        <p>Cette variable modifie le comportement du module
	<code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code>. Si elle contient un symbole de
	langage (tel que <code>en</code>, <code>ja</code>
        ou <code>x-klingon</code>), <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> essaie de
	dlivrer une variante dans ce langage. S'il n'existe pas de telle
	variante, le processus normal de
	<a href="content-negotiation.html">ngociation</a> s'applique.</p>

    

    <h3><a name="redirect-carefully" id="redirect-carefully">redirect-carefully</a></h3>
        

        <p>Cette variable force le serveur  tre plus prudent lors de l'envoi
	d'une redirection au client. Elle est en gnral utilise quand un
	client prsente un problme connu avec les redirections. Elle fut
	implmente  l'origine suite a un problme rencontr avec le logiciel
	WebFolders de Microsoft qui ne gre pas correctement les redirections
	vers des ressources de type rpertoire via des mthodes DAV.</p>

    

   <h3><a name="suppress-error-charset" id="suppress-error-charset">suppress-error-charset</a></h3>
       

    <p><em>Disponible dans les versions postrieures  2.0.54</em></p>

    <p>Quand Apache gnre une redirection en rponse  une requte client,
    la rponse inclut un texte destin  tre affich au cas o le client ne
    suivrait pas, ou ne pourrait pas suivre automatiquement la redirection.
    Habituellement, Apache marque ce texte en accord avec le jeu de caractres
    qu'il utilise,  savoir ISO-8859-1.</p>
    <p> Cependant, si la redirection fait rfrence  une page qui utilise un
    jeu de caractres diffrent, certaines versions de navigateurs obsoltes
    essaieront d'utiliser le jeu de caractres du texte de la redirection
    plutt que celui de la page relle.
    Ceci peut entraner, par exemple, un rendu incorrect du Grec.</p>
    <p>Si cette variable d'environnement est dfinie, Apache omettra le jeu de
    caractres pour le texte de la redirection, et les navigateurs obsoltes
    prcits utiliseront correctement celui de la page de destination.</p>

    <div class="warning">
      <h3>Note concernant la scurit</h3>

      <p>L'envoi de pages d'erreur sans spcifier un jeu de caractres peut
      conduire  des attaques de type "cross-site-scripting" pour les
      navigateurs qui ne respectent pas la spcification HTTP/1.1 (MSIE) et
      tentent de dduire le jeu de caractres  partir du contenu. De tels
      navigateurs peuvent tre facilement tromps et utiliser le jeu de
      caractres UTF-7 ; les contenus des donnes en entre de type UTF-7
      (comme les URI de requte) ne seront alors plus protgs par les
      mcanismes d'chappement usuels conus pour prvenir les attaques
      de type "cross-site-scripting".</p>
    </div>

   

   <h3><a name="proxy" id="proxy">force-proxy-request-1.0, proxy-nokeepalive, proxy-sendchunked,
   proxy-sendcl, proxy-chain-auth, proxy-interim-response, proxy-initial-not-pooled</a></h3>

   <p>Ces directives modifient le comportement protocolaire du module
   <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code>.  Voir la documentation sur
   <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code> et <code class="module"><a href="./mod/mod_proxy_http.html">mod_proxy_http</a></code> pour plus de dtails.</p>
   

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>
    

    <h3><a name="fixheader" id="fixheader">Transmission du contenu d'en-ttes non valides aux scripts
      CGI</a></h3>
      

      <p>Avec la version 2.4, Apache est plus strict avec la conversion
      des en-ttes HTTP en variables d'environnement dans
      <code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code> et d'autres modules : dans les versions
      prcdentes, tout caractre invalide dans les noms d'en-ttes
      tait tout simplement remplac par un caractre '_', ce qui
      pouvait exposer  des attaques de type cross-site-scripting via
      injection d'en-ttes (voir <a href="http://events.ccc.de/congress/2007/Fahrplan/events/2212.en.html">Bogues
      du Web inhabituelles</a>, planche 19/20).</p>

      <p>Si vous devez supporter un client qui envoie des en-ttes non
      conformes et si ceux-ci ne peuvent pas tre corrigs, il existe
      une solution de contournement simple mettant en jeu les modules
      <code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code> et <code class="module"><a href="./mod/mod_header.html">mod_header</a></code>,
      et permettant de prendre en compte ces en-ttes :</p>

<pre class="prettyprint lang-config">
# L'exemple suivant montre comment prendre en compte un en-tte<br />
# Accept_Encoding non conforme envoy par un client.
#
SetEnvIfNoCase ^Accept.Encoding$ ^(.*)$ fix_accept_encoding=$1
RequestHeader set Accept-Encoding %{fix_accept_encoding}e env=fix_accept_encoding
</pre>


    

    <h3><a name="misbehaving" id="misbehaving">Modification du comportement protocolaire face  des clients
	ragissant de manire non conforme</a></h3>
        

        <p>Les versions antrieures recommandaient l'ajout de ces lignes dans
        httpd.conf pour tenir compte de problmes connus avec certains clients.
	Comme les clients concerns sont maintenant trs peu utiliss, cet
	ajout n'est pratiquement plus ncessaire.</p>
<pre class="prettyprint lang-config">
#
# The following directives modify normal HTTP response behavior.
# The first directive disables keepalive for Netscape 2.x and browsers that
# spoof it. There are known problems with these browser implementations.
# The second directive is for Microsoft Internet Explorer 4.0b2
# which has a broken HTTP/1.1 implementation and does not properly
# support keepalive when it is used on 301 or 302 (redirect) responses.
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0

#
# The following directive disables HTTP/1.1 responses to browsers which
# are in violation of the HTTP/1.0 spec by not being able to grok a
# basic 1.1 response.
#
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0
</pre>


    
    <h3><a name="no-img-log" id="no-img-log">Ne pas tracer les requtes pour des images dans le fichier de
	trace des accs</a></h3>
        

        <p>Dans cet exemple, les requtes pour des images n'apparaissent pas
	dans le fichier de trace des accs. Il peut tre facilement adapt pour
	empcher le traage de rpertoires particuliers, ou de requtes
        en provenance de certains htes.</p>
         <pre class="prettyprint lang-config">
SetEnvIf Request_URI \.gif image-request
SetEnvIf Request_URI \.jpg image-request
SetEnvIf Request_URI \.png image-request
CustomLog logs/access_log common env=!image-request
        </pre>


    
    <h3><a name="image-theft" id="image-theft">Prvention du "Vol d'image"</a></h3>
        

        <p>Cet exemple montre comment empcher les utilisateurs ne faisant pas
	partie de votre serveur d'utiliser des images de votre serveur comme
	images en ligne dans leurs pages. Cette configuration n'est pas
	recommande, mais elle peut fonctionner dans des circonstances bien
	dfinies. Nous supposons que toutes vos images sont enregistres dans
	un rpertoire nomm <code>/web/images</code>.</p>
    	<pre class="prettyprint lang-config">
SetEnvIf Referer "^http://www\.example\.com/" local_referal
# Autorise les navigateurs qui n'envoient aucune information de Referer
SetEnvIf Referer "^$" local_referal
&lt;Directory /web/images&gt;
    Order Deny,Allow
    Deny from all
    Allow from env=local_referal
&lt;/Directory&gt;
        </pre>


        <p>Pour plus d'informations sur cette technique, voir le tutoriel sur
	ServerWatch
	"<a href="http://www.serverwatch.com/tutorials/article.php/1132731">Keeping Your Images from Adorning Other Sites</a>".</p>
    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/env.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/env.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/env.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>