#include"sasm.h"
#include"opcode.h"

#ifdef dll
#include "dllfile.h"
#endif

/******************************************************************
*
*{"MNEM",operand,flags,length,"code","Alt1","Alt2",fs_nib,offset,size,
*       bias,class,subclass,field1,field2,carry}
*
* op_flags bits: A_SPEC B_SPEC TEST GOYES PSEUDO_OP MACRO LEVELBITS (2)
*                (8 reserved)
*
* for PSEUDO_OP, class is a PS_<type> value
* for PSEUDO_OP, PS_IF[STR]COND, subclass is a relational type
*******************************************************************/

/* ABS, BSS, EQU, IF, and REL fake"OPD_NONE"; PSEUDO_OP gets the value */
OPTABLE opcodes[] = {
  {"#ELSE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ELSE,0,0,0,OP_NOCHGCARRY},
  {"#ENDIF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ENDIF,0,0,0,OP_NOCHGCARRY},
  {"#IF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_NE,0,0,OP_NOCHGCARRY},
  {"#IFNOT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_EQ,0,0,OP_NOCHGCARRY},
  {"="		,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_EQUALS,0,0,0,OP_NOCHGCARRY},
  {"?A#0"	,OPD_FS,TEST | A_SPEC,3,"90C","8AC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A#B"	,OPD_FS,TEST | A_SPEC,3,"904","8A4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A#C"	,OPD_FS,TEST | A_SPEC,3,"906","8A6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A<=B"	,OPD_FS,TEST | A_SPEC,3,"98C","8BC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A<=C"	,OPD_FS,TEST | A_SPEC,3,"98A","8BA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A<B"	,OPD_FS,TEST | A_SPEC,3,"984","8B4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A<C"	,OPD_FS,TEST | A_SPEC,3,"982","8B2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A=0"	,OPD_FS,TEST | A_SPEC,3,"908","8A8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A=B"	,OPD_FS,TEST | A_SPEC,3,"900","8A0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A=C"	,OPD_FS,TEST | A_SPEC,3,"902","8A2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A>=B"	,OPD_FS,TEST | A_SPEC,3,"988","8B8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A>=C"	,OPD_FS,TEST | A_SPEC,3,"98E","8BE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A>B"	,OPD_FS,TEST | A_SPEC,3,"980","8B0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?A>C"	,OPD_FS,TEST | A_SPEC,3,"986","8B6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?ABIT#0"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"80870","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ABIT#1"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"80860","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ABIT=0"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"80860","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ABIT=1"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"80870","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?B#0"	,OPD_FS,TEST | A_SPEC,3,"90D","8AD","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B#A"	,OPD_FS,TEST | A_SPEC,3,"904","8A4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B#C"	,OPD_FS,TEST | A_SPEC,3,"905","8A5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B<=A"	,OPD_FS,TEST | A_SPEC,3,"988","8B8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B<=C"	,OPD_FS,TEST | A_SPEC,3,"98D","8BD","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B<A"	,OPD_FS,TEST | A_SPEC,3,"980","8B0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B<C"	,OPD_FS,TEST | A_SPEC,3,"985","8B5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B=0"	,OPD_FS,TEST | A_SPEC,3,"909","8A9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B=A"	,OPD_FS,TEST | A_SPEC,3,"900","8A0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B=C"	,OPD_FS,TEST | A_SPEC,3,"901","8A1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B>=A"	,OPD_FS,TEST | A_SPEC,3,"98C","8BC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B>=C"	,OPD_FS,TEST | A_SPEC,3,"989","8B9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B>A"	,OPD_FS,TEST | A_SPEC,3,"984","8B4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?B>C"	,OPD_FS,TEST | A_SPEC,3,"981","8B1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C#0"	,OPD_FS,TEST | A_SPEC,3,"90E","8AE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C#A"	,OPD_FS,TEST | A_SPEC,3,"906","8A6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C#B"	,OPD_FS,TEST | A_SPEC,3,"905","8A5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C#D"	,OPD_FS,TEST | A_SPEC,3,"907","8A7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<=A"	,OPD_FS,TEST | A_SPEC,3,"98E","8BE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<=B"	,OPD_FS,TEST | A_SPEC,3,"989","8B9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<=D"	,OPD_FS,TEST | A_SPEC,3,"98B","8BB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<A"	,OPD_FS,TEST | A_SPEC,3,"986","8B6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<B"	,OPD_FS,TEST | A_SPEC,3,"981","8B1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C<D"	,OPD_FS,TEST | A_SPEC,3,"983","8B3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C=0"	,OPD_FS,TEST | A_SPEC,3,"90A","8AA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C=A"	,OPD_FS,TEST | A_SPEC,3,"902","8A2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C=B"	,OPD_FS,TEST | A_SPEC,3,"901","8A1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C=D"	,OPD_FS,TEST | A_SPEC,3,"903","8A3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>=A"	,OPD_FS,TEST | A_SPEC,3,"98A","8BA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>=B"	,OPD_FS,TEST | A_SPEC,3,"98D","8BD","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>=D"	,OPD_FS,TEST | A_SPEC,3,"98F","8BF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>A"	,OPD_FS,TEST | A_SPEC,3,"982","8B2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>B"	,OPD_FS,TEST | A_SPEC,3,"985","8B5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?C>D"	,OPD_FS,TEST | A_SPEC,3,"987","8B7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?CBIT#0"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"808B0","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?CBIT#1"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"808A0","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?CBIT=0"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"808A0","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?CBIT=1"	,OPD_DIGIT_EXPR,LEVEL2 | TEST,5,"808B0","","",0,4,1,0,0,0,0,0,OP_CHGCARRY},
  {"?D#0"	,OPD_FS,TEST | A_SPEC,3,"90F","8AF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D#C"	,OPD_FS,TEST | A_SPEC,3,"907","8A7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D<=C"	,OPD_FS,TEST | A_SPEC,3,"98F","8BF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D<C"	,OPD_FS,TEST | A_SPEC,3,"987","8B7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D=0"	,OPD_FS,TEST | A_SPEC,3,"90B","8AB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D=C"	,OPD_FS,TEST | A_SPEC,3,"903","8A3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D>=C"	,OPD_FS,TEST | A_SPEC,3,"98B","8BB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?D>C"	,OPD_FS,TEST | A_SPEC,3,"983","8B3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"?HS=0"	,OPD_DIGIT_EXPR,TEST,3,"830","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?HST=0"	,OPD_DIGIT_EXPR,TEST|MASD,3,"830","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?MP=0"	,OPD_NONE,TEST,3,"838","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"?P#"	,OPD_DIGIT_EXPR,TEST,3,"880","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?P="	,OPD_DIGIT_EXPR,TEST,3,"890","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?SB=0"	,OPD_NONE,TEST,3,"832","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"?SR=0"	,OPD_NONE,TEST,3,"834","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"?ST#0"	,OPD_DIGIT_EXPR,TEST,3,"870","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ST#1"	,OPD_DIGIT_EXPR,TEST,3,"860","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ST=0"	,OPD_DIGIT_EXPR,TEST,3,"860","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?ST=1"	,OPD_DIGIT_EXPR,TEST,3,"870","","",0,2,1,0,0,0,0,0,OP_CHGCARRY},
  {"?XM=0"	,OPD_NONE,TEST,3,"831","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A!B"	,OPD_FS,0 | MASD,4,"0E08","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A!C"	,OPD_FS,0 | MASD,4,"0E0E","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A&B"	,OPD_FS,0 | MASD,4,"0E00","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A&C"	,OPD_FS,0 | MASD,4,"0E06","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A+"		,OPD_FS2, MASD,-1,"818000","B04","E4",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A+1"	,OPD_FS,A_SPEC | MASD,-1,"B04","E4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A+A"	,OPD_FS,A_SPEC | MASD,-1,"A04","C4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A+B"	,OPD_FS,A_SPEC | MASD,-1,"A00","C0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A+C"	,OPD_FS,A_SPEC | MASD,-1,"A0A","CA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A+CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"818000","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A+D0"	,OPD_NONE,COMBOS | MASD,8,"136CA136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A+D1"	,OPD_NONE,COMBOS | MASD,8,"137CA137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A-"		,OPD_FS2, MASD,-1,"818000","B04","E4",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"A-1"	,OPD_FS,A_SPEC | MASD,-1,"A0C","CC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A-B"	,OPD_FS,A_SPEC | MASD,-1,"B00","E0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A-C"	,OPD_FS,A_SPEC | MASD,-1,"B0A","EA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A-CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"818080","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A-D0"	,OPD_NONE,COMBOS | MASD,8,"136EA136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A-D1"	,OPD_NONE,COMBOS | MASD,8,"137EA137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A=-A"	,OPD_FS,A_SPEC,-1,"B88","F8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=-A-1"	,OPD_FS,A_SPEC,-1,"B8C","FC","",1,0,0,0,0,0,FS_A,0,OP_CLRCARRY},
  {"A=0"	,OPD_FS,A_SPEC,-1,"A80","D0","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"A=A!B"	,OPD_FS,0,4,"0E08","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=A!C"	,OPD_FS,0,4,"0E0E","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=A&B"	,OPD_FS,0,4,"0E00","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=A&C"	,OPD_FS,0,4,"0E06","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=A+"	,OPD_FS2, MASD,-1,"818000","B04","E4",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A=A+1"	,OPD_FS,A_SPEC,-1,"B04","E4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A+A"	,OPD_FS,A_SPEC,-1,"A04","C4","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A+B"	,OPD_FS,A_SPEC,-1,"A00","C0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A+C"	,OPD_FS,A_SPEC,-1,"A0A","CA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A+CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818000","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A=A+D0"	,OPD_NONE,COMBOS,8,"136CA136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A=A+D1"	,OPD_NONE,COMBOS,8,"137CA137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A=A-"	,OPD_FS2, MASD,-1,"818000","B04","E4",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"A=A-1"	,OPD_FS,A_SPEC,-1,"A0C","CC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A-B"	,OPD_FS,A_SPEC,-1,"B00","E0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A-C"	,OPD_FS,A_SPEC,-1,"B0A","EA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=A-CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818080","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"A=A-D0"	,OPD_NONE,COMBOS,8,"136EA136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A=A-D1"	,OPD_NONE,COMBOS,8,"137EA137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"A=B"	,OPD_FS,A_SPEC,-1,"A84","D4","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"A=B!A"	,OPD_FS,0,4,"0E08","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=B&A"	,OPD_FS,0,4,"0E00","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=B+A"	,OPD_FS,A_SPEC,-1,"A00","C0","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=B-A"	,OPD_FS,A_SPEC,-1,"B0C","EC","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=C"	,OPD_FS,A_SPEC,-1,"A8A","DA","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"A=C!A"	,OPD_FS,0,4,"0E0E","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=C&A"	,OPD_FS,0,4,"0E06","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=C+A"	,OPD_FS,A_SPEC,-1,"A0A","CA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"A=D0"	,OPD_NONE,COMBOS,6,"132130","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=D1"	,OPD_NONE,COMBOS,6,"133131","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=DAT0"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1520","142","14A",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"A=DAT1"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1530","143","14B",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"A=IN"	,OPD_NONE,0,3,"802","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=PC"	,OPD_NONE,LEVEL2,4,"81B4","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R0"	,OPD_NONE,0,3,"110","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R0.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A010","110","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"A=R1"	,OPD_NONE,0,3,"111","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R1.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A011","111","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"A=R2"	,OPD_NONE,0,3,"112","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R2.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A012","112","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"A=R3"	,OPD_NONE,0,3,"113","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R3.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A013","113","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"A=R4"	,OPD_NONE,0,3,"114","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"A=R4.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A014","114","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"ABASE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ABASE,0,0,0,OP_NOCHGCARRY},
  {"ABEX"	,OPD_FS,A_SPEC,-1,"A8C","DC","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"ABIT=0"	,OPD_DIGIT_EXPR,LEVEL2,5,"80840","","",0,4,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"ABIT=1"	,OPD_DIGIT_EXPR,LEVEL2,5,"80850","","",0,4,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"ABS"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ABS,0,0,0,OP_NOCHGCARRY},
  {"ACEX"	,OPD_FS,A_SPEC,-1,"A8E","DE","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"AD0EX"	,OPD_NONE,0,3,"132","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AD0XS"	,OPD_NONE,0,3,"13A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AD1EX"	,OPD_NONE,0,3,"133","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AD1XS"	,OPD_NONE,0,3,"13B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"ALLOC"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ALLOC,0,0,0,OP_NOCHGCARRY},
  {"APCEX"	,OPD_NONE,LEVEL2,4,"81B6","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"AR0EX"	,OPD_NONE,0,3,"120","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AR0EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A020","120","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"AR1EX"	,OPD_NONE,0,3,"121","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AR1EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A021","121","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"AR2EX"	,OPD_NONE,0,3,"122","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AR2EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A022","122","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"AR3EX"	,OPD_NONE,0,3,"123","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AR3EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A023","123","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"AR4EX"	,OPD_NONE,0,3,"124","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"AR4EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A024","124","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"ASC(1)"	,OPD_LENASC,0,-1,"","","",0,1,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"ASC(2)"	,OPD_LENASC,0,-1,"","","",0,2,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"ASC(3)"	,OPD_LENASC,0,-1,"","","",0,3,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"ASC(4)"	,OPD_LENASC,0,-1,"","","",0,4,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"ASC(5)"	,OPD_LENASC,0,-1,"","","",0,5,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"ASCM(1)"	,OPD_LENASC,0,-1,"","","",0,1,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"ASCM(2)"	,OPD_LENASC,0,-1,"","","",0,2,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"ASCM(3)"	,OPD_LENASC,0,-1,"","","",0,3,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"ASCM(4)"	,OPD_LENASC,0,-1,"","","",0,4,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"ASCM(5)"	,OPD_LENASC,0,-1,"","","",0,5,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"ASL"	,OPD_FS,A_SPEC,-1,"B80","F0","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"ASLC"	,OPD_NONE,0,3,"810","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"ASR"	,OPD_FS,A_SPEC,-1,"B84","F4","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"ASRB"	,OPD_NONE,0,3,"81C","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"ASRB.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81900","81C","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"ASRC"	,OPD_NONE,0,3,"814","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B!A"	,OPD_FS,0 | MASD,4,"0E0C","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B!C"	,OPD_FS,0 | MASD,4,"0E09","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B&A"	,OPD_FS,0 | MASD,4,"0E04","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B&C"	,OPD_FS,0 | MASD,4,"0E01","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B+"		,OPD_FS2, MASD,-1,"818010","B05","E5",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B+1"	,OPD_FS,A_SPEC | MASD,-1,"B05","E5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B+A"	,OPD_FS,A_SPEC | MASD,-1,"A08","C8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B+B"	,OPD_FS,A_SPEC | MASD,-1,"A05","C5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B+C"	,OPD_FS,A_SPEC | MASD,-1,"A01","C1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B+CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"818010","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B+D0"	,OPD_NONE,COMBOS | MASD,8,"136C1136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B+D1"	,OPD_NONE,COMBOS | MASD,8,"137C1137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B-"		,OPD_FS2, MASD,-1,"818010","B05","E5",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"B-1"	,OPD_FS,A_SPEC | MASD,-1,"A0D","CD","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B-A"	,OPD_FS,A_SPEC | MASD,-1,"B08","E8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B-C"	,OPD_FS,A_SPEC | MASD,-1,"B01","E1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B-CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"818090","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B-D0"	,OPD_NONE,COMBOS | MASD,8,"136E1136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B-D1"	,OPD_NONE,COMBOS | MASD,8,"137E1137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B=-B"	,OPD_FS,A_SPEC,-1,"B89","F9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=-B-1"	,OPD_FS,A_SPEC,-1,"B8D","FD","",1,0,0,0,0,0,FS_A,0,OP_CLRCARRY},
  {"B=0"	,OPD_FS,A_SPEC,-1,"A81","D1","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"B=A"	,OPD_FS,A_SPEC,-1,"A88","D8","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"B=A!B"	,OPD_FS,0,4,"0E0C","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=A&B"	,OPD_FS,0,4,"0E04","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=A+B"	,OPD_FS,A_SPEC,-1,"A08","C8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B!A"	,OPD_FS,0,4,"0E0C","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=B!C"	,OPD_FS,0,4,"0E09","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=B&A"	,OPD_FS,0,4,"0E04","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=B&C"	,OPD_FS,0,4,"0E01","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=B+"	,OPD_FS2, MASD,-1,"818010","B05","E5",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B=B+1"	,OPD_FS,A_SPEC,-1,"B05","E5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B+A"	,OPD_FS,A_SPEC,-1,"A08","C8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B+B"	,OPD_FS,A_SPEC,-1,"A05","C5","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B+C"	,OPD_FS,A_SPEC,-1,"A01","C1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B+CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818010","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B=B+D0"	,OPD_NONE,COMBOS,8,"136C1136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B=B+D1"	,OPD_NONE,COMBOS,8,"137C1137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B=B-"	,OPD_FS2, MASD,-1,"818010","B05","E5",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"B=B-1"	,OPD_FS,A_SPEC,-1,"A0D","CD","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B-A"	,OPD_FS,A_SPEC,-1,"B08","E8","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B-C"	,OPD_FS,A_SPEC,-1,"B01","E1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=B-CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818090","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"B=B-D0"	,OPD_NONE,COMBOS,8,"136E1136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B=B-D1"	,OPD_NONE,COMBOS,8,"137E1137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"B=C"	,OPD_FS,A_SPEC,-1,"A85","D5","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"B=C!B"	,OPD_FS,0,4,"0E09","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=C&B"	,OPD_FS,0,4,"0E01","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=C+B"	,OPD_FS,A_SPEC,-1,"A01","C1","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=C-B"	,OPD_FS,A_SPEC,-1,"B0D","ED","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"B=D0"	,OPD_NONE,COMBOS,8,"136D5136","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"B=D1"	,OPD_NONE,COMBOS,8,"137D5137","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BAEX"	,OPD_FS,A_SPEC,-1,"A8C","DC","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"BCEX"	,OPD_FS,A_SPEC,-1,"A8D","DD","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"BD0EX"	,OPD_NONE,COMBOS,7,"DD136DD","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BD1EX"	,OPD_NONE,COMBOS,7,"DD137DD","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BSL"	,OPD_FS,A_SPEC,-1,"B81","F1","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"BSLC"	,OPD_NONE,0,3,"811","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BSR"	,OPD_FS,A_SPEC,-1,"B85","F5","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"BSRB"	,OPD_NONE,0,3,"81D","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BSRB.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81901","81D","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"BSRC"	,OPD_NONE,0,3,"815","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BSS"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_BSS,0,0,0,OP_CHGCARRY},
  {"BUSCB"	,OPD_NONE,LEVEL2,4,"8083","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BUSCC"	,OPD_NONE,0,3,"80B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"BUSCD"	,OPD_NONE,LEVEL2,4,"808D","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C!A"	,OPD_FS,0 | MASD,4,"0E0A","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C!B"	,OPD_FS,0 | MASD,4,"0E0D","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C!D"	,OPD_FS,0 | MASD,4,"0E0F","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C&A"	,OPD_FS,0 | MASD,4,"0E02","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C&B"	,OPD_FS,0 | MASD,4,"0E05","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C&D"	,OPD_FS,0 | MASD,4,"0E07","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C+"		,OPD_FS2, MASD,-1,"818020","B06","E6",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C+1"	,OPD_FS,A_SPEC | MASD,-1,"B06","E6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C+A"	,OPD_FS,A_SPEC | MASD,-1,"A02","C2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C+B"	,OPD_FS,A_SPEC | MASD,-1,"A09","C9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C+C"	,OPD_FS,A_SPEC | MASD,-1,"A06","C6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C+CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818020","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C+D"	,OPD_FS,A_SPEC | MASD,-1,"A0B","CB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C+D0"	,OPD_NONE,COMBOS | MASD,8,"132C2132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C+D1"	,OPD_NONE,COMBOS | MASD,8,"133C2133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C+P+1"	,OPD_NONE,0,3,"809","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C-"		,OPD_FS2, MASD,-1,"818020","B06","E6",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"C-1"	,OPD_FS,A_SPEC | MASD,-1,"A0E","CE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C-A"	,OPD_FS,A_SPEC | MASD,-1,"B02","E2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C-B"	,OPD_FS,A_SPEC | MASD,-1,"B09","E9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C-CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"8180A0","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C-D"	,OPD_FS,A_SPEC | MASD,-1,"B0B","EB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C-D0"	,OPD_NONE,COMBOS | MASD,8,"132E2132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C-D1"	,OPD_NONE,COMBOS | MASD,8,"133E2133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=-C"	,OPD_FS,A_SPEC,-1,"B8A","FA","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=-C-1"	,OPD_FS,A_SPEC,-1,"B8E","FE","",1,0,0,0,0,0,FS_A,0,OP_CLRCARRY},
  {"C=0"	,OPD_FS,A_SPEC,-1,"A82","D2","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"C=A"	,OPD_FS,A_SPEC,-1,"A86","D6","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"C=A!C"	,OPD_FS,0,4,"0E0A","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=A&C"	,OPD_FS,0,4,"0E02","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=A+C"	,OPD_FS,A_SPEC,-1,"A02","C2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=A-C"	,OPD_FS,A_SPEC,-1,"B0E","EE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=B"	,OPD_FS,A_SPEC,-1,"A89","D9","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"C=B!C"	,OPD_FS,0,4,"0E0D","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=B&C"	,OPD_FS,0,4,"0E05","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=B+C"	,OPD_FS,A_SPEC,-1,"A09","C9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C!A"	,OPD_FS,0,4,"0E0A","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C!B"	,OPD_FS,0,4,"0E0D","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C!D"	,OPD_FS,0,4,"0E0F","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C&A"	,OPD_FS,0,4,"0E02","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C&B"	,OPD_FS,0,4,"0E05","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C&D"	,OPD_FS,0,4,"0E07","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=C+"	,OPD_FS2, MASD,-1,"818020","B06","E6",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C=C+1"	,OPD_FS,A_SPEC,-1,"B06","E6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C+A"	,OPD_FS,A_SPEC,-1,"A02","C2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C+B"	,OPD_FS,A_SPEC,-1,"A09","C9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C+C"	,OPD_FS,A_SPEC,-1,"A06","C6","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C+CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818020","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C=C+D"	,OPD_FS,A_SPEC,-1,"A0B","CB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C+D0"	,OPD_NONE,COMBOS,8,"132C2132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=C+D1"	,OPD_NONE,COMBOS,8,"133C2133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=C+P+1"	,OPD_NONE,0,3,"809","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=C-"	,OPD_FS2, MASD,-1,"818020","B06","E6",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"C=C-1"	,OPD_FS,A_SPEC,-1,"A0E","CE","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C-A"	,OPD_FS,A_SPEC,-1,"B02","E2","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C-B"	,OPD_FS,A_SPEC,-1,"B09","E9","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C-CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"8180A0","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"C=C-D"	,OPD_FS,A_SPEC,-1,"B0B","EB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=C-D0"	,OPD_NONE,COMBOS,8,"132E2132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=C-D1"	,OPD_NONE,COMBOS,8,"133E2133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"C=D"	,OPD_FS,A_SPEC,-1,"A8B","DB","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"C=D!C"	,OPD_FS,0,4,"0E0F","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=D&C"	,OPD_FS,0,4,"0E07","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=D+C"	,OPD_FS,A_SPEC,-1,"A0B","CB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"C=D0"	,OPD_NONE,COMBOS,6,"136134","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=D1"	,OPD_NONE,COMBOS,6,"137135","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=DAT0"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1560","146","14E",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"C=DAT1"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1570","147","14F",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"C=ID"	,OPD_NONE,0,3,"806","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=IN"	,OPD_NONE,0,3,"803","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=P"	,OPD_DIGIT_EXPR,0,4,"80C0","","",0,3,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=PC"	,OPD_NONE,LEVEL2,4,"81B5","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R0"	,OPD_NONE,0,3,"118","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R0.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A018","118","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"C=R1"	,OPD_NONE,0,3,"119","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R1.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A019","119","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"C=R2"	,OPD_NONE,0,3,"11A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R2.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A01A","11A","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"C=R3"	,OPD_NONE,0,3,"11B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R3.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A01B","11B","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"C=R4"	,OPD_NONE,0,3,"11C","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=R4.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A01C","11C","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"C=RSTK"	,OPD_NONE,0,2,"07","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"C=ST"	,OPD_NONE,0,2,"09","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CAEX"	,OPD_FS,A_SPEC,-1,"A8E","DE","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"CBEX"	,OPD_FS,A_SPEC,-1,"A8D","DD","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"CBIT=0"	,OPD_DIGIT_EXPR,LEVEL2,5,"80880","","",0,4,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"CBIT=1"	,OPD_DIGIT_EXPR,LEVEL2,5,"80890","","",0,4,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"CD0EX"	,OPD_NONE,0,3,"136","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CD0XS"	,OPD_NONE,0,3,"13E","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CD1EX"	,OPD_NONE,0,3,"137","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CD1XS"	,OPD_NONE,0,3,"13F","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CDEX"	,OPD_FS,A_SPEC,-1,"A8F","DF","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"CHARMAP"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_CHARMAP,0,0,0,OP_NOCHGCARRY},
  {"CLRCARRY"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_CLRCARRY,0,0,0,OP_NOCHGCARRY},
  {"CLRFLAG"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_CLRFLAG,0,0,0,OP_NOCHGCARRY},
  {"CLRHST"	,OPD_NONE,0,3,"82F","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CLRLIST"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_CLRLIST,0,0,0,OP_NOCHGCARRY},
  {"CLRST"	,OPD_NONE,0,2,"08","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CON(1)"	,OPD_EXPRESSION,0,1,"","","",0,0,1,0,0,0,0,0,OP_CHGCARRY},
  {"CON(2)"	,OPD_EXPRESSION,0,2,"","","",0,0,2,0,0,0,0,0,OP_CHGCARRY},
  {"CON(3)"	,OPD_EXPRESSION,0,3,"","","",0,0,3,0,0,0,0,0,OP_CHGCARRY},
  {"CON(4)"	,OPD_EXPRESSION,0,4,"","","",0,0,4,0,0,0,0,0,OP_CHGCARRY},
  {"CON(5)"	,OPD_EXPRESSION,0,5,"","","",0,0,5,0,0,0,0,0,OP_CHGCARRY},
  {"CON(6)"	,OPD_EXPRESSION,0,6,"","","",0,0,6,0,0,0,0,0,OP_CHGCARRY},
  {"CON(7)"	,OPD_EXPRESSION,0,7,"","","",0,0,7,0,0,0,0,0,OP_CHGCARRY},
  {"CON(8)"	,OPD_EXPRESSION,0,8,"","","",0,0,8,0,0,0,0,0,OP_CHGCARRY},
  {"CONFIG"	,OPD_NONE,0,3,"805","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CP="	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ABASE,0,0,0,OP_NOCHGCARRY},
  {"CPCEX"	,OPD_NONE,LEVEL2,4,"81B7","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"CPEX"	,OPD_DIGIT_EXPR,0,4,"80F0","","",0,3,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR0EX"	,OPD_NONE,0,3,"128","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR0EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A028","128","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CR1EX"	,OPD_NONE,0,3,"129","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR1EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A029","129","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CR2EX"	,OPD_NONE,0,3,"12A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR2EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A02A","12A","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CR3EX"	,OPD_NONE,0,3,"12B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR3EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A02B","12B","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CR4EX"	,OPD_NONE,0,3,"12C","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CR4EX.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A02C","12C","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CSL"	,OPD_FS,A_SPEC,-1,"B82","F2","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"CSLC"	,OPD_NONE,0,3,"812","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CSR"	,OPD_FS,A_SPEC,-1,"B86","F6","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"CSRB"	,OPD_NONE,0,3,"81E","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CSRB.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81902","81E","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"CSRC"	,OPD_NONE,0,3,"816","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CSTEX"	,OPD_NONE,0,2,"0B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"CSTRING"	,OPD_STRING,0,-1,"","","",0,0,0,-1,0,0,0,0,OP_CHGCARRY},
  {"D!C"	,OPD_FS,0 | MASD,4,"0E0B","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D&C"	,OPD_FS,0 | MASD,4,"0E03","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D+"		,OPD_FS2, MASD,-1,"818030","B07","E7",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D+1"	,OPD_FS,A_SPEC | MASD,-1,"B07","E7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D+C"	,OPD_FS,A_SPEC | MASD,-1,"A03","C3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D+CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"818030","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D+D"	,OPD_FS,A_SPEC | MASD,-1,"A07","C7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D+D0"	,OPD_NONE,COMBOS | MASD,8,"136C3136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D+D1"	,OPD_NONE,COMBOS | MASD,8,"137C3137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D-"		,OPD_FS2, MASD,-1,"818030","B07","E7",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"D-1"	,OPD_FS,A_SPEC | MASD,-1,"A0F","CF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D-C"	,OPD_FS,A_SPEC | MASD,-1,"B03","E3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D-CON"	,OPD_PF_AND_DIGIT,LEVEL2 | MASD,6,"8180B0","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D-D0"	,OPD_NONE,COMBOS | MASD,8,"136E3136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D-D1"	,OPD_NONE,COMBOS | MASD,8,"137E3137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0+"	,OPD_DIGIT_EXPR2,0 | MASD,-1,"160","180","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D0+A"	,OPD_NONE,COMBOS | MASD,8,"136C2136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0+B"	,OPD_NONE,COMBOS | MASD,8,"136C9136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0+C"	,OPD_NONE,COMBOS | MASD,8,"132CA132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0+D"	,OPD_NONE,COMBOS | MASD,8,"136CB136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0-"	,OPD_DIGIT_EXPR2,0 | MASD,-1,"180","160","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D0=(2)"	,OPD_EXPRESSION,0,4,"19","","",0,2,2,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=(4)"	,OPD_EXPRESSION,0,6,"1A","","",0,2,4,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=(5)"	,OPD_EXPRESSION,0,7,"1B","","",0,2,5,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=A"	,OPD_NONE,0,3,"130","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=AS"	,OPD_NONE,0,3,"138","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=B"	,OPD_NONE,COMBOS,7,"DD134DD","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=C"	,OPD_NONE,0,3,"134","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=CS"	,OPD_NONE,0,3,"13C","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=D"	,OPD_NONE,COMBOS,7,"DF134DF","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=D0+"	,OPD_DIGIT_EXPR,0,3,"160","","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D0=D0+A"	,OPD_NONE,COMBOS,8,"136C2136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0=D0+B"	,OPD_NONE,COMBOS,8,"136C9136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0=D0+C"	,OPD_NONE,COMBOS,8,"132CA132","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0=D0+D"	,OPD_NONE,COMBOS,8,"136CB136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D0=D0-"	,OPD_DIGIT_EXPR,0,3,"180","","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D0=D1"	,OPD_NONE,COMBOS,9,"137134137","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0=HEX"	,OPD_245_HEX,0,-1,"19","","",0,2,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"D0D1EX"	,OPD_NONE,COMBOS,9,"136137136","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1+"	,OPD_DIGIT_EXPR2,0 | MASD,-1,"170","1C0","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D1+A"	,OPD_NONE,COMBOS | MASD,8,"137C2137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1+B"	,OPD_NONE,COMBOS | MASD,8,"137C9137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1+C"	,OPD_NONE,COMBOS | MASD,8,"133CA133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1+D"	,OPD_NONE,COMBOS | MASD,8,"137CB137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1-"	,OPD_DIGIT_EXPR2,0 | MASD,-1,"1C0","170","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D1=(2)"	,OPD_EXPRESSION,0,4,"1D","","",0,2,2,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=(4)"	,OPD_EXPRESSION,0,6,"1E","","",0,2,4,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=(5)"	,OPD_EXPRESSION,0,7,"1F","","",0,2,5,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=A"	,OPD_NONE,0,3,"131","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=AS"	,OPD_NONE,0,3,"139","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=B"	,OPD_NONE,COMBOS,7,"DD135DD","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=C"	,OPD_NONE,0,3,"135","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=CS"	,OPD_NONE,0,3,"13D","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=D"	,OPD_NONE,COMBOS,7,"DF135DF","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=D0"	,OPD_NONE,COMBOS,9,"136135136","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1=D1+"	,OPD_DIGIT_EXPR,0,3,"170","","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D1=D1+A"	,OPD_NONE,COMBOS,8,"137C2137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1=D1+B"	,OPD_NONE,COMBOS,8,"137C9137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1=D1+C"	,OPD_NONE,COMBOS,8,"133CA133","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1=D1+D"	,OPD_NONE,COMBOS,8,"137CB137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D1=D1-"	,OPD_DIGIT_EXPR,0,3,"1C0","","",0,2,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D1=HEX"	,OPD_245_HEX,0,-1,"1D","","",0,2,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"D1D0EX"	,OPD_NONE,COMBOS,9,"137136137","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=-D"	,OPD_FS,A_SPEC,-1,"B8B","FB","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=-D-1"	,OPD_FS,A_SPEC,-1,"B8F","FF","",1,0,0,0,0,0,FS_A,0,OP_CLRCARRY},
  {"D=0"	,OPD_FS,A_SPEC,-1,"A83","D3","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"D=C"	,OPD_FS,A_SPEC,-1,"A87","D7","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"D=C!D"	,OPD_FS,0,4,"0E0B","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=C&D"	,OPD_FS,0,4,"0E03","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=C+D"	,OPD_FS,A_SPEC,-1,"A03","C3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=C-D"	,OPD_FS,A_SPEC,-1,"B0F","EF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D!C"	,OPD_FS,0,4,"0E0B","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=D&C"	,OPD_FS,0,4,"0E03","","",2,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=D+"	,OPD_FS2, MASD,-1,"818030","B07","E7",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D=D+1"	,OPD_FS,A_SPEC,-1,"B07","E7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D+C"	,OPD_FS,A_SPEC,-1,"A03","C3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D+CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"818030","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D=D+D"	,OPD_FS,A_SPEC,-1,"A07","C7","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D+D0"	,OPD_NONE,COMBOS,8,"136C3136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D=D+D1"	,OPD_NONE,COMBOS,8,"137C3137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D=D-"	,OPD_FS2, MASD,-1,"818030","B07","E7",3,5,1,-1,-1,0,0,0,OP_CHGCARRY},
  {"D=D-1"	,OPD_FS,A_SPEC,-1,"A0F","CF","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D-C"	,OPD_FS,A_SPEC,-1,"B03","E3","",1,0,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"D=D-CON"	,OPD_PF_AND_DIGIT,LEVEL2,6,"8180B0","","",3,5,1,-1,0,0,0,0,OP_CHGCARRY},
  {"D=D-D0"	,OPD_NONE,COMBOS,8,"136E3136","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D=D-D1"	,OPD_NONE,COMBOS,8,"137E3137","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"D=D0"	,OPD_NONE,COMBOS,8,"136D7136","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"D=D1"	,OPD_NONE,COMBOS,8,"137D7137","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"DAT0=A"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1500","140","148",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"DAT0=C"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1540","144","14C",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"DAT1=A"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1510","141","149",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"DAT1=C"	,OPD_D_OR_FS,A_SPEC|B_SPEC,-1,"1550","145","14D",3,3,1,-1,0,0,FS_A,FS_B,OP_NOCHGCARRY},
  {"DCCP"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ALLOC,0,0,0,OP_NOCHGCARRY},
  {"DCEX"	,OPD_FS,A_SPEC,-1,"A8F","DF","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"DD0EX"	,OPD_NONE,COMBOS,7,"DF136DF","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"DD1EX"	,OPD_NONE,COMBOS,7,"DF137DF","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"DSL"	,OPD_FS,A_SPEC,-1,"B83","F3","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"DSLC"	,OPD_NONE,0,3,"813","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"DSR"	,OPD_FS,A_SPEC,-1,"B87","F7","",1,0,0,0,0,0,FS_A,0,OP_NOCHGCARRY},
  {"DSRB"	,OPD_NONE,0,3,"81F","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"DSRB.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81903","81F","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"DSRC"	,OPD_NONE,0,3,"817","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"EJECT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_EJECT,0,0,0,OP_NOCHGCARRY},
  {"ELSE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ELSE,0,0,0,OP_NOCHGCARRY},
  {"END"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_END,0,0,0,OP_NOCHGCARRY},
  {"ENDIF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ENDIF,0,0,0,OP_NOCHGCARRY},
  {"ENDM"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_ENDM,0,0,0,OP_NOCHGCARRY},
  {"EQU"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_EQU,0,0,0,OP_NOCHGCARRY},
  {"EXIT"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,1,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT1"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,1,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT2"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,2,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT3"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,3,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT4"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,4,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT5"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,5,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT6"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,6,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT7"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,7,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXIT8"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,8,0,1,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,1,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC1"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,1,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC2"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,2,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC3"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,3,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC4"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,4,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC5"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,5,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC6"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,6,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC7"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,7,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITC8"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,8,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_EXITF,0,0,0,OP_NOCHGCARRY},
  {"EXITM"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_EXITM,0,0,0,OP_NOCHGCARRY},
  {"EXITNC"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,1,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC1"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,1,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC2"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,2,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC3"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,3,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC4"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,4,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC5"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,5,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC6"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,6,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC7"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,7,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"EXITNC8"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,8,0,0,PS_EXIT,0,0,0,OP_NOTREACHED},
  {"FOR"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_FOR,0,0,0,OP_NOCHGCARRY},
  {"GOC"	,OPD_RELATIVE_JUMP,0,3,"4","","",0,1,2,0,1,0,0,0,OP_NOSETCARRY},
  {"GOLONG"	,OPD_RELATIVE_JUMP,0,6,"8C","","",0,2,4,0,1,0,0,0,OP_NOTREACHED},
  {"GONC"	,OPD_RELATIVE_JUMP,0,3,"5","","",0,1,2,0,1,0,0,0,OP_NOCLRCARRY},
  {"GOSBVL"	,OPD_ABSOLUTE_JUMP,0,7,"8F","","",0,2,5,0,0,1,0,0,OP_CHGCARRY},
  {"GOSHORT"	,OPD_RELATIVE_JUMP,PSEUDO_OP,0,"GOTO","GONC","GOC",0,0,0,0,PS_JUMP,0,0,0,OP_NOTREACHED},
  {"GOSUB"	,OPD_RELATIVE_JUMP,0,4,"7","","",0,1,3,0,1,1,0,0,OP_CHGCARRY},
  {"GOSUBL"	,OPD_RELATIVE_JUMP,0,6,"8E","","",0,2,4,0,1,1,0,0,OP_CHGCARRY},
  {"GOTO"	,OPD_RELATIVE_JUMP,0,4,"6","","",0,1,3,0,1,0,0,0,OP_NOTREACHED},
  {"GOTOL"	,OPD_RELATIVE_JUMP,0 | MASD,6,"8C","","",0,2,4,0,1,0,0,0,OP_NOTREACHED},
  {"GOVLNG"	,OPD_ABSOLUTE_JUMP,0,7,"8D","","",0,2,5,0,0,1,0,0,OP_NOTREACHED},
  {"GOYES"	,OPD_RELATIVE_JUMP,GOYES,2,"","","",0,0,2,0,1,0,0,0,OP_CLRCARRY},
  {"HEX(1)"	,OPD_LENHEX,0,-1,"","","",0,1,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"HEX(2)"	,OPD_LENHEX,0,-1,"","","",0,2,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"HEX(3)"	,OPD_LENHEX,0,-1,"","","",0,3,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"HEX(4)"	,OPD_LENHEX,0,-1,"","","",0,4,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"HEX(5)"	,OPD_LENHEX,0,-1,"","","",0,5,0,0,0,0,FS_A,0,OP_CHGCARRY},
  {"HEXM(1)"	,OPD_LENHEX,0,-1,"","","",0,1,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"HEXM(2)"	,OPD_LENHEX,0,-1,"","","",0,2,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"HEXM(3)"	,OPD_LENHEX,0,-1,"","","",0,3,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"HEXM(4)"	,OPD_LENHEX,0,-1,"","","",0,4,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"HEXM(5)"	,OPD_LENHEX,0,-1,"","","",0,5,0,-1,0,0,FS_A,0,OP_CHGCARRY},
  {"HS=0"	,OPD_DIGIT_EXPR,0,3,"820","","",0,2,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"IF"		,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IF,0,0,0,OP_NOCHGCARRY},
  {"IFANYCARRY"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFANYCARRY,0,0,0,OP_NOCHGCARRY},
  {"IFCARRYCLR"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCARRYCLR,0,0,0,OP_NOCHGCARRY},
  {"IFCARRYSET"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCARRYSET,0,0,0,OP_NOCHGCARRY},
  {"IFDEF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFDEF,0,0,0,OP_NOCHGCARRY},
  {"IFEQ"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_EQ,0,0,OP_NOCHGCARRY},
  {"IFGE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_GE,0,0,OP_NOCHGCARRY},
  {"IFGT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_GT,0,0,OP_NOCHGCARRY},
  {"IFLE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_LE,0,0,OP_NOCHGCARRY},
  {"IFLT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_LT,0,0,OP_NOCHGCARRY},
  {"IFNDEF"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFNDEF,0,0,0,OP_NOCHGCARRY},
  {"IFNE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_NE,0,0,OP_NOCHGCARRY},
  {"IFNEG"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_LT,0,0,OP_NOCHGCARRY},
  {"IFNOPC"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFNOPC,0,0,0,OP_NOCHGCARRY},
  {"IFNZ"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_NE,0,0,OP_NOCHGCARRY},
  {"IFOPC"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFOPC,0,0,0,OP_NOCHGCARRY},
  {"IFPASS1"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFPASS1,0,0,0,OP_NOCHGCARRY},
  {"IFPASS2"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFPASS2,0,0,0,OP_NOCHGCARRY},
  {"IFPOS"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_GT,0,0,OP_NOCHGCARRY},
  {"IFREACHED"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFREACHED,0,0,0,OP_NOCHGCARRY},
  {"IFSTREQ"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_EQ,0,0,OP_NOCHGCARRY},
  {"IFSTRGE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_GE,0,0,OP_NOCHGCARRY},
  {"IFSTRGT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_GT,0,0,OP_NOCHGCARRY},
  {"IFSTRLE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_LE,0,0,OP_NOCHGCARRY},
  {"IFSTRLT"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_LT,0,0,OP_NOCHGCARRY},
  {"IFSTRNE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFSTRCOND,C_NE,0,0,OP_NOCHGCARRY},
  {"IFZER"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_IFCOND,C_EQ,0,0,OP_NOCHGCARRY},
  {"INC(1)"	,OPD_SYMBOL,0,1,"","","",0,0,1,0,3,0,0,0,OP_CHGCARRY},
  {"INC(2)"	,OPD_SYMBOL,0,2,"","","",0,0,2,0,3,0,0,0,OP_CHGCARRY},
  {"INC(3)"	,OPD_SYMBOL,0,3,"","","",0,0,3,0,3,0,0,0,OP_CHGCARRY},
  {"INC(4)"	,OPD_SYMBOL,0,4,"","","",0,0,4,0,3,0,0,0,OP_CHGCARRY},
  {"INC(5)"	,OPD_SYMBOL,0,5,"","","",0,0,5,0,3,0,0,0,OP_CHGCARRY},
  {"INC(6)"	,OPD_SYMBOL,0,6,"","","",0,0,6,0,3,0,0,0,OP_CHGCARRY},
  {"INC(7)"	,OPD_SYMBOL,0,7,"","","",0,0,7,0,3,0,0,0,OP_CHGCARRY},
  {"INC(8)"	,OPD_SYMBOL,0,8,"","","",0,0,8,0,3,0,0,0,OP_CHGCARRY},
  {"INCLOB"	,OPD_NONE,PSEUDO_OP,-1,"","","",0,0,0,0,PS_INCLOB,0,0,0,OP_NOCHGCARRY},
  {"INCLUDE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_INCLUDE,0,0,0,OP_NOCHGCARRY},
  {"INTOFF"	,OPD_NONE,0,4,"808F","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"INTON"	,OPD_NONE,0,4,"8080","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"JUMP"	,OPD_RELATIVE_JUMP,PSEUDO_OP,0,"GOTO","GONC","GOC",0,0,0,0,PS_JUMP,0,0,0,OP_NOTREACHED},
  {"LA(1)"	,OPD_EXPRESSION,LEVEL2,6,"80820","","",0,5,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(2)"	,OPD_EXPRESSION,LEVEL2,7,"80821","","",0,5,2,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(3)"	,OPD_EXPRESSION,LEVEL2,8,"80822","","",0,5,3,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(4)"	,OPD_EXPRESSION,LEVEL2,9,"80823","","",0,5,4,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(5)"	,OPD_EXPRESSION,LEVEL2,10,"80824","","",0,5,5,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(6)"	,OPD_EXPRESSION,LEVEL2,11,"80825","","",0,5,6,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(7)"	,OPD_EXPRESSION,LEVEL2,12,"80826","","",0,5,7,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(8)"	,OPD_EXPRESSION,LEVEL2,13,"80827","","",0,5,8,0,0,0,0,0,OP_NOCHGCARRY},
  {"LA(N)"	,OPD_DIGIT_EXPR,LEVEL2,5,"80820","","",0,4,1,-1,0,0,0,0,OP_NOCHGCARRY},
  {"LAASC"	,OPD_ASC,LEVEL2,-1,"80820","","",0,5,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LAHEX"	,OPD_LCHEX,LEVEL2,-1,"80820","","",0,5,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LASTR"	,OPD_STR,LEVEL2,-1,"80820","","",0,5,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(1)"	,OPD_EXPRESSION,0,3,"30","","",0,2,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(2)"	,OPD_EXPRESSION,0,4,"31","","",0,2,2,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(3)"	,OPD_EXPRESSION,0,5,"32","","",0,2,3,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(4)"	,OPD_EXPRESSION,0,6,"33","","",0,2,4,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(5)"	,OPD_EXPRESSION,0,7,"34","","",0,2,5,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(6)"	,OPD_EXPRESSION,0,8,"35","","",0,2,6,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(7)"	,OPD_EXPRESSION,0,9,"36","","",0,2,7,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(8)"	,OPD_EXPRESSION,0,10,"37","","",0,2,8,0,0,0,0,0,OP_NOCHGCARRY},
  {"LC(N)"	,OPD_DIGIT_EXPR,0,2,"30","","",0,1,1,-1,0,0,0,0,OP_NOCHGCARRY},
  {"LCASC"	,OPD_ASC,0,-1,"30","","",0,2,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LCHEX"	,OPD_LCHEX,0,-1,"30","","",0,2,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LCSTR"	,OPD_STR,0,-1,"30","","",0,2,-1,0,0,0,0,0,OP_NOCHGCARRY},
  {"LINK"	,OPD_SYMBOL,0,5,"","","",0,0,5,0,2,1,0,0,OP_CHGCARRY},
  {"LIST"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_LIST,0,0,0,OP_NOCHGCARRY},
  {"LISTALL"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_LISTALL,0,0,0,OP_NOCHGCARRY},
  {"LISTM"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_LISTM,0,0,0,OP_NOCHGCARRY},
  {"MACRO"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_MACRO,0,0,0,OP_NOCHGCARRY},
  {"MESSAGE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_MESSAGE,0,0,0,OP_NOCHGCARRY},
  {"MP=0"	,OPD_NONE,0,3,"828","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"NIBASC"	,OPD_STRING,0,-1,"","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"NIBBIN"	,OPD_BIN,0,-1,"","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"NIBFS"	,OPD_FS,0,1,"0","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"NIBGRB"	,OPD_BIN,0,-1,"","","",0,0,0,-1,0,0,0,0,OP_CHGCARRY},
  {"NIBHEX"	,OPD_NIBHEX,0,-1,"","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"NOP3"	,OPD_NONE,0,3,"820","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"NOP4"	,OPD_NONE,0,4,"6300","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"NOP5"	,OPD_NONE,0,5,"64000","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"NOTREACHED"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_NOTREACHED,0,0,0,OP_NOCHGCARRY},
  {"OUT=C"	,OPD_NONE,0,3,"801","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"OUT=CS"	,OPD_NONE,0,3,"800","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"P+1"	,OPD_NONE,0,2,"0C","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"P-1"	,OPD_NONE,0,2,"0D","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"P="		,OPD_DIGIT_EXPR,0,2,"20","","",0,1,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"P=C"	,OPD_DIGIT_EXPR,0,4,"80D0","","",0,3,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"P=P+1"	,OPD_NONE,0,2,"0C","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"P=P-1"	,OPD_NONE,0,2,"0D","","",0,0,0,0,0,0,0,0,OP_CHGCARRY},
  {"PC=(A)"	,OPD_NONE,LEVEL1,4,"808C","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"PC=(C)"	,OPD_NONE,LEVEL2,4,"808E","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"PC=A"	,OPD_NONE,LEVEL2,4,"81B2","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"PC=C"	,OPD_NONE,LEVEL2,4,"81B3","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"R0=A"	,OPD_NONE,0,3,"100","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R0=A.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A000","100","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R0=C"	,OPD_NONE,0,3,"108","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R0=C.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A008","108","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R1=A"	,OPD_NONE,0,3,"101","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R1=A.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A001","101","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R1=C"	,OPD_NONE,0,3,"109","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R1=C.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A009","109","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R2=A"	,OPD_NONE,0,3,"102","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R2=A.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A002","102","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R2=C"	,OPD_NONE,0,3,"10A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R2=C.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A00A","10A","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R3=A"	,OPD_NONE,0,3,"103","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R3=A.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A003","103","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R3=C"	,OPD_NONE,0,3,"10B","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R3=C.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A00B","10B","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R4=A"	,OPD_NONE,0,3,"104","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R4=A.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A004","104","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"R4=C"	,OPD_NONE,0,3,"10C","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"R4=C.F"	,OPD_FS,LEVEL2 | A_SPEC,-1,"81A00C","10C","",3,0,0,0,0,0,FS_W,0,OP_NOCHGCARRY},
  {"RDSYMB"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_RDSYMB,0,0,0,OP_NOCHGCARRY},
  {"REL"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_REL,0,0,0,OP_NOCHGCARRY},
  {"REL(1)"	,OPD_RELATIVE_JUMP,0,1,"","","",0,0,1,0,1,2,0,0,OP_CHGCARRY},
  {"REL(2)"	,OPD_RELATIVE_JUMP,0,2,"","","",0,0,2,0,1,2,0,0,OP_CHGCARRY},
  {"REL(3)"	,OPD_RELATIVE_JUMP,0,3,"","","",0,0,3,0,1,2,0,0,OP_CHGCARRY},
  {"REL(4)"	,OPD_RELATIVE_JUMP,0,4,"","","",0,0,4,0,1,2,0,0,OP_CHGCARRY},
  {"REL(5)"	,OPD_RELATIVE_JUMP,0,5,"","","",0,0,5,0,1,2,0,0,OP_CHGCARRY},
  {"REL(6)"	,OPD_RELATIVE_JUMP,0,6,"","","",0,0,6,0,1,2,0,0,OP_CHGCARRY},
  {"REL(7)"	,OPD_RELATIVE_JUMP,0,7,"","","",0,0,7,0,1,2,0,0,OP_CHGCARRY},
  {"REL(8)"	,OPD_RELATIVE_JUMP,0,8,"","","",0,0,8,0,1,2,0,0,OP_CHGCARRY},
  {"RESET"	,OPD_NONE,0,3,"80A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"RSI"	,OPD_NONE,LEVEL1,5,"80810","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"RSTK=C"	,OPD_NONE,0,2,"06","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"RTI"	,OPD_NONE,0,2,"0F","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"RTN"	,OPD_NONE,0,2,"01","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"RTNC"	,OPD_NONE,0,3,"400","","",0,0,0,0,0,0,0,0,OP_NOSETCARRY},
  {"RTNCC"	,OPD_NONE,0,2,"03","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"RTNNC"	,OPD_NONE,0,3,"500","","",0,0,0,0,0,0,0,0,OP_NOCLRCARRY},
  {"RTNSC"	,OPD_NONE,0,2,"02","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"RTNSXM"	,OPD_NONE,0,2,"00","","",0,0,0,0,0,0,0,0,OP_NOTREACHED},
  {"RTNYES"	,OPD_NONE,GOYES,2,"00","","",0,0,0,0,0,0,0,0,OP_CLRCARRY},
  {"RTY"	,OPD_NONE,GOYES | MASD,2,"00","","",0,0,0,0,0,0,0,0,OP_CLRCARRY},
  {"SB=0"	,OPD_NONE,0,3,"822","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"SETCARRY"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_SETCARRY,0,0,0,OP_NOCHGCARRY},
  {"SETDEC"	,OPD_NONE,0,2,"05","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"SETFLAG"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_SETFLAG,0,0,0,OP_NOCHGCARRY},
  {"SETHEX"	,OPD_NONE,0,2,"04","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"SETLIST"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_SETLIST,0,0,0,OP_NOCHGCARRY},
  {"SHUTDN"	,OPD_NONE,0,3,"807","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"SKC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIP5{"	,OPD_NONE,PSEUDO_OP | MASD,5,"","REL(5)","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIPC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIPL{"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTOL","GOYES",0,1,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIPNC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIPYES{"	,OPD_NONE,PSEUDO_OP | MASD,2,"","GOYES","",0,2,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKIP{"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,1,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKNC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKUBL{"	,OPD_NONE,PSEUDO_OP | MASD,6,"","GOSUBL","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SKUB{"	,OPD_NONE,PSEUDO_OP | MASD,4,"","GOSUB","",0,0,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"SLINK"	,OPD_SYMBOL,0,5,"","","",0,0,5,0,2,0,0,0,OP_CHGCARRY},
  {"SR=0"	,OPD_NONE,0,3,"824","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"SREQ?"	,OPD_NONE,0,3,"80E","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"ST=0"	,OPD_DIGIT_EXPR,0,3,"840","","",0,2,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"ST=1"	,OPD_DIGIT_EXPR,0,3,"850","","",0,2,1,0,0,0,0,0,OP_NOCHGCARRY},
  {"ST=C"	,OPD_NONE,0,2,"0A","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"STITLE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_STITLE,0,0,0,OP_NOCHGCARRY},
  {"STRING"	,OPD_STRING,0,-1,"","","",0,0,0,1,0,0,0,0,OP_CHGCARRY},
  {"TITLE"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_TITLE,0,0,0,OP_NOCHGCARRY},
  {"UNCNFG"	,OPD_NONE,0,3,"804","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"UNLIST"	,OPD_NONE,PSEUDO_OP,0,"","","",0,0,0,0,PS_UNLIST,0,0,0,OP_NOCHGCARRY},
  {"UP"		,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,1,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP1"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,1,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP2"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,2,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP3"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,3,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP4"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,4,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP5"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,5,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP6"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,6,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP7"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,7,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UP8"	,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOTO","GOYES",0,8,0,1,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,1,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC1"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,1,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC2"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,2,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC3"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,3,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC4"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,4,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC5"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,5,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC6"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,6,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC7"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,7,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPC8"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,8,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,1,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC1"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,1,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC2"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,2,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC3"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,3,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC4"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,4,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC5"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,5,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC6"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,6,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC7"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,7,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"UPNC8"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,8,0,0,PS_UP,0,0,0,OP_NOTREACHED},
  {"XM=0"	,OPD_NONE,0,3,"821","","",0,0,0,0,0,0,0,0,OP_NOCHGCARRY},
  {"{"		,OPD_NONE,PSEUDO_OP | MASD,-1,"","GOYES","",0,3,0,0,PS_SKIP,0,0,0,OP_NOTREACHED},
  {"}"		,OPD_NONE,PSEUDO_OP | MASD,0,"","","",0,0,0,0,PS_SKIPCLOSE,0,0,0,OP_NOTREACHED},
  {"}SKEC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GOC","",0,1,0,0,PS_SKELSE,0,0,0,OP_NOTREACHED},
  {"}SKELSE{"	,OPD_NONE,PSEUDO_OP | MASD,4,"","GOTO","",0,1,0,0,PS_SKELSE,0,0,0,OP_NOTREACHED},
  {"}SKENC{"	,OPD_NONE,PSEUDO_OP | MASD,3,"","GONC","",0,1,0,0,PS_SKELSE,0,0,0,OP_NOTREACHED},
  {"}SKLSE{"	,OPD_NONE,PSEUDO_OP | MASD,0,"","","",0,0,0,0,PS_SKELSE,0,0,0,OP_NOTREACHED},
  {""		,0,0,0,"","","",0,0,0,0,0,0,0,0,0 }
};

#define NUM_OPCODES	(sizeof(opcodes) / sizeof(struct optable))
int num_opcodes = NUM_OPCODES;

void buildoptable(int left, int root, int right)
{
  if (left != root) {
    opcodes[root].op_left = &(opcodes[((root-1) + left) / 2]);
    buildoptable(left, ((root-1) + left) / 2, root - 1);
  }
  if (right != root) {
    opcodes[root].op_right = &(opcodes[((root+1) + right) / 2]);
    buildoptable(root + 1, ((root+1) + right) / 2, right);
  }
}

int mymax(int a, int b)
{
  return (a > b ? a : b);
}

int depth(OPTABLEPTR root)
{
  if (NULL==root)
    return 0;
  return mymax(depth(root->op_left), depth(root->op_right))+1;
}

void printtable(OPTABLEPTR table, int depth)
{
  if (table != NULL) {
    if (table->op_left)
      printtable(table->op_left, depth+1);
    printf("[%d]\t%s\n",depth,table->op_mnem);
    if (table->op_right)
      printtable(table->op_right, depth+1);
  }
}

void readoptable(void)
{
  int mnem_count = 0, mnem_root;
  OPTABLEPTR mnemp = opcodes;
  /*  int trouve = 0, compare; */

  while(strlen(mnemp->op_mnem) != 0) {
    mnemp->op_left = NULL;
    mnemp->op_right = NULL;
    if((mnemp->op_flags & LEVELBITS) <= code_level)
      opcodes[mnem_count++] = *mnemp++;
    else
      opcodes[mnem_count] = *mnemp++;
  }

  mnem_root = mnem_count / 2;
  optable_root = &opcodes[mnem_root];

  buildoptable(0, mnem_root, mnem_count - 1);

  /*  printtable(optable_root,0);
      
      mnemp = optable_root;
      while (mnemp != (OPTABLEPTR) NULL) {
      if ((compare=strcmp("C=A", mnemp->op_mnem)) == 0) {
      trouve = 1;
      break;
      }
      mnemp = (compare < 0) ? mnemp->op_left : mnemp->op_right;
      }
      if (trouve) printf("TROUVE !!");
  */
}
