
/* This program attempts to send the following string to a Garmin GPS35PC
 * OEM GPS unit to switch its primary serial port (actually the only port
 * on the GPS35PC model) from NMEA output to Garmin's binary protocol. 

 */

#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <signal.h>

#include "siolib.h"
#include "libgps.h"
#include "garmin.h"

#define MODE_BINARY 1
#define MODE_NMEA 2

void usage (void);

void sig_term_handler (int);

int fd;

int main (int argc, char **argv)
{
    char *port_device=NULL;
    int i,mode;

    signal (SIGTERM, sig_term_handler);
    signal (SIGINT, sig_term_handler);
    
    mode = 0;

    if (argc<2) 
    {
	usage ();
	exit(0);
    }
    
    for (i=1; i<argc; i++) 
    {
	if (*argv[i] == '-') 
	{
	    switch (*(argv[i]+1)) 
	    {
	     case 'h':
		usage();
		exit(0);

	     case 'p':
		i++;
		if (i == argc)
		{
		    break;
		}
		port_device = argv[i];
		break;
		
	     case 'm':
		switch (*(argv[i]+2))
		{
		 case 'b':
		    mode = MODE_BINARY;
		    break;
		 case 'n':
		    mode = MODE_NMEA;
		    break;
		}
	    }
	}
    }

    /* no action */
    if (mode == 0) 
    {
	exit(0);
    }

    if (port_device==NULL || strcmp(port_device,"-")==0)
    {
	fprintf (stderr,"opening stdin\n");
	fd=STDIN_FILENO;
    }
    else 
    {
	fprintf (stderr,"opening %s\n",port_device);
	fd = sio_open (port_device);
	if (fd < 0) 
	{
	    perror ("error opening sio device");
	    exit(1);
	}
    }

    sio_rawmode (fd);
    
    switch (mode) 
    {
     case MODE_BINARY:
	fprintf (stderr,"switching mode to binary\n");
	fflush (stderr);
	write (fd, GPS35_SW2BIN_CMD, strlen(GPS35_SW2BIN_CMD));
	break;
	
     case MODE_NMEA:
	fprintf (stderr,"switching mode to NMEA\n");
	fflush(stderr);
	write (fd, GPS35_SW2NMEA_CMD, strlen (GPS35_SW2NMEA_CMD));
	break;
    }
    
    /* Close sio device and restore previous settings */
    sio_close (fd);

    return 0;
}

void sig_term_handler (int i)
{
    sio_close (fd);
    exit(0);
}

void usage ()
{
    fprintf (stderr,"switchmode -p <port> -m<mode>\n\n\
<port> device file associated with device eg /dev/ttyS0. \"-\" means stdout \n\
<mode> b for binary, n for NMEA \n\
eg switchmode -p /dev/ttyS0 -mb \n\
");
}

    
