/* Serial IO library for Linux (/POSIX)
 * Needs some working on. Only one device should be opened at 
 * the moment (see static struct termios orig_termios)
 * 
 * Last mod 21 Nov 1999, 23:00
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <termios.h>

#include "siolib.h"

/* #define DPRINTF(s) fprintf(stderr,s) */
#define DPRINTF(s)

static struct termios orig_termios;


/* open tty device 'dev'
 * Return 0 if fail, fd otherwise 
 */
int sio_open (char *dev)
{
    int fd,status;
    /* open device file */
    fd = open(dev,O_RDWR);
    if (fd == 0) 
    {
	DPRINTF ("sio_open: error opening device\n");
	return 0;
    }
    
    /* check if its a tty device */
    if (!isatty(fd)) 
    {
	DPRINTF ("sio_open: not a tty device\n");
	close(fd);
	return 0;
    }
    
    /* save original terminal settings */
    status=tcgetattr(fd,&orig_termios);
    if (status < 0) 
    {
	DPRINTF ("sio_open: tcgetattr error\n");
	return -1;
    }
    
    return fd;
}

int sio_close (int fd)
{
    int status;
    /* reset to original terminal settings */
    status=tcsetattr(fd,TCSADRAIN,&orig_termios);
    if (status<0) 
    {
	DPRINTF ("sio_close: tcsetattr error\n");
	return -1;
    }
    close(fd);
    return 0;
}

/* Set input and output speed to 'bps'. bps are one
 * of the values defined in termios.h 
 * Return -1 if failed, 0 otherwise 
 */

int sio_setspeed (int fd, int bps)
{
    int status;
    struct termios tios;
    /* read termios structure */
    status=tcgetattr(fd,&tios);
    if (status < 0) 
    {
	DPRINTF ("sio_setspeed: tcgetattr error\n");
	return status;
    }
    
    status = cfsetispeed(&tios,bps);         /* input speed */
    if (status < 0) 
    {
	DPRINTF ("sio_setspeed: cfsetispeed error\n");
	return status;
    }
    
    status = cfsetospeed(&tios,bps);         /* output speed */
    if (status < 0) 
    {
	DPRINTF ("sio_setspeed: cfsetospeed error\n");
	return status;
    }

    status = tcsetattr (fd, TCSADRAIN, &tios);
    if (status < 0) 
    {
	DPRINTF ("sio_setspeed: tcsetattr error\n");
	return status;
    }
    
    return 0;
}

/* Set input timeout in 0.1 secs */
int sio_timeout (int fd, int timeout)
{
    int status;
    struct termios tios;
    /* read termios structure */
    status=tcgetattr(fd,&tios);
    if (status < 0) {
	DPRINTF ("sio_timeout: tcgetattr error\n");
	return status;
    }
    
    tios.c_cc[VTIME]=timeout;
    
    status=tcsetattr(fd,TCSADRAIN,&tios);
    if (status<0) {
	DPRINTF ("sio_raw_mode: tcsetattr error\n");
	return status;
    }
    
    return 0;
}

void sio_drain (int fd) 
{
    tcdrain(fd);
}

/* Set tty into raw mode 
 * Return -1 if failed, 0 otherwise 
 */

int sio_rawmode (int fd) 
{
    int status;
    struct termios tios;
    
    /* read termios structure */
    status=tcgetattr(fd,&tios);
    if (status < 0) {
	DPRINTF ("sio_raw_mode: error calling tcgetattr\n");
	return -1;
    }
    

    /* echo off, canonical mode off, extended input processing off,
     * signal characters off 
     */
    tios.c_lflag &= ~(ECHO | ICANON | IEXTEN | ISIG);
    
    /* no SIGINT on break, CR-to-NL off, input parity check off
     * don't strip 8th bit on input, output flow control off 
     */
    tios.c_iflag &= ~(BRKINT | ICRNL | INPCK | ISTRIP | IXON | IXOFF | IUCLC);
    
    /* reset char size field, no parity*/
    tios.c_cflag &= ~(CSIZE | PARENB);

    /* set char size to 8 bits */
    tios.c_cflag |= CS8;
    
    /* no control lines */
    tios.c_cflag &= ~CRTSCTS; 
    tios.c_cflag |= CLOCAL;
    
    /* output processing off */
    tios.c_oflag &= ~(OPOST);
    
    /* read one character at a time */
    tios.c_cc[VMIN]=1;
    
    /* no timer by default */
    tios.c_cc[VTIME]=0;
    
    status=tcsetattr(fd,TCSADRAIN,&tios);
    if (status<0) 
    {
	DPRINTF ("sio_raw_mode: tcsetattr error\n");
	return status;
    }
    return 0;
}

/* 
 * send string 
 */
int sio_send_string (int fd, char *buf)
{
    int buflen;
    buflen=strlen(buf);
    return write(fd,buf,buflen);
}

int sio_send_char (int fd, int c)
{
    return write(fd,&c,1);
}

int sio_recv_char (int fd, int *c)
{
    int status;
    char buf[4];
    
    status=read(fd,buf,1);
    *c = (int)buf[0];
    return status;
}

  
int sio_recv_buf (int fd, int n, void *buf)
{
    return read(fd,buf,n);
}

int sio_recv_buf2 (int fd, int n, char *buf)
{
    int status,i,c;
    
    for (i=0; i<n; i++) 
    {
	status=sio_recv_char (fd, &c);
	if (status!=1) 
	{
	    fprintf (stderr,"oh shit!! (%d)\n",status);
	    return 0;   /* check this -- dunno if this is right */
	}
	else 
	{
	    buf[i]=c;
	}
    }
    return n;
}

/* ??? this is driving me batty */
int sio_flush (int fd)
{

  tcflush(fd,TCIOFLUSH);

  return 1;
}
