/* Basic math constants */
#define DEG_TO_RAD pi/180.0
#define RAD_TO_DEG 180.0/pi

/*WGS 84 Constants */
#define We              7.292115e-5      /* WGS-84 earth rotation rate*/
#define const_c         299792458.0      /* WGS-84 speed of light*/
#define pi              3.1415926535898  /* WGS-84 PI */
#define Wedot           7.2921151467e-5  /* WGS-84 earth's rotation rate*/
#define mu              3.986005e+14     /* WGS-84 earth's univ. grav. par.*/
#define F               (-4.442807633e-10) /*relativistic correction term constant*/

#if 0
#define OS_DX	( 0.0)
#define OS_DY	( 0.0)
#define OS_DZ	( 0.0)
#define a               6378137.0   /*WGS-84 earth's semi major axis*/
#define b               6356752.31   /*WGS-84 earth's semi minor axis*/
#else
#define OS_DX	( 375.0)
#define OS_DY	(-111.0)
#define OS_DZ	( 431.0)
#define a 		6377563.3960
#define invf 		299.324964600
#define b  	( a * ( ( invf - 1 ) / invf ) )
#endif


#define e1sqr           ((a * a - b * b) / (a * a))
    /*first  numerical eccentricity*/
#define e2sqr           ((a * a - b * b) / (b * b))
    /*second numerical eccentricity*/


#ifndef true
# define true    1
# define false   0
#endif
typedef unsigned char boolean;

typedef double mat96[32][3];
typedef boolean vecb32[32];
typedef long veci32[32];
typedef double vec32[32];
typedef double vec16[16];
typedef double vec8[8];
typedef double vec3[3];
typedef double mat16[4][4];

typedef struct
{
    char prn;
    short wn;
    float toc;
    float toe;
    float af0;
    float af1;
    float af2;
    float ura;
    double e;
    double sqrta;
    double dn;
    double m0;
    double w;
    double omg0;
    double i0;
    double odot;
    double idot;
    double cus;
    double cuc;
    double cis;
    double cic;
    double crs;
    double crc;
    unsigned char iod;
    double gd;  /* Clk Group Delay */
} eph_type;

void gps_satpos (eph_type, double, double *Trel, double *X);
void gps_lla2xyz (vec3, vec3);
void gps_xyz2lla (vec3, vec3);
void gps_calcAzEl(double *Xs, double *Xu, double *Az, double *El, boolean *stat);
void ionocorr (double *ion, double Latu, double Lonu, double Az, double El, double Ttr, double *dTiono);
void vec3sub (vec3 vecresult, vec3 veca, vec3 vecb);
double vec3mag (vec3 v);

/* void satpos (double *, double, double *Trel, double *X); */

boolean gps_sps_calc (
		   vec3 Xlla, 
		   double Trc, 
		   boolean sv_valid[32],
		   eph_type eph[32], 
		   vec8 ion, 
		   double Praw[32],
		   double *clock_error);
