/**
 * Garmin specific code.
 * 
 * Released under GPL2 license. See COPYING for more information
 * 
 * TODO:
 * Fix checksum code.
 * 
 */

#include <stdlib.h>
#include <stdio.h>

#include "libgps.h"
#include "garmin.h"


/* FIXME
 * Don't like these globals -- thread saftey out the door!!!
 */

/* Byte stream state */
int state = DAT;

/**
 * Copy the content of a Garmin binary ephemeris packet into a
 * ephemeris structure.
 *
 */
void garmin_eph_record (unsigned char *buf, eph_type *eph)
{
    
    eph->prn = buf[0];
    eph->wn = (short) *(buf + 1);
    eph->toc = * ( (float *) (buf + 3) );
    eph->toe = * ( (float *) (buf + 7) );
    eph->af0 = * ( (float *) (buf +11) );
    eph->af1 = * ( (float *) (buf +15) );
    eph->af2 = * ( (float *) (buf +19) );
    eph->ura = * ( (float *) (buf +23) );

    eph->e   = * ( (double *) (buf +27) );
    eph->sqrta= * ( (double *) (buf +35) );
    eph->dn   = * ( (double *) (buf +43) );
    eph->m0   = * ( (double *) (buf +51) );
    eph->w    = * ( (double *) (buf +59) );
    eph->omg0 = * ( (double *) (buf +67) );
    eph->i0   = * ( (double *) (buf +75) );
    
    eph->odot = * ( (float *) (buf +83) );
    eph->idot = * ( (float *) (buf +87) );
    eph->cus = * ( (float *) (buf +91) );
    eph->cuc = * ( (float *) (buf +95) );
    eph->cis = * ( (float *) (buf +99) );
    eph->cic = * ( (float *) (buf +103) );
    eph->crs = * ( (float *) (buf +107) );
    eph->crc = * ( (float *) (buf +111) );

    eph->iod = buf[115];

}

/**
 * Read receiver record from a memory buffer to an
 * instance of the garmin_rcv_type structure.
 */
void garmin_rcv_record (unsigned char *buf, garmin_rcv_type *rcv)
{
    int i,offset,nvalid;
    
    rcv->tow = (double) * ( (double *) buf );
    rcv->wn = (short)  * ( (short *) (buf+8) );

    nvalid=0;

    /* Loop for each of the 12 channels */
    for (i=0; i<12; i++) 
    {
	offset = 10+i*18;
	rcv->sv[i].cycles = *((int *)&buf[offset]);
	rcv->sv[i].pr = *((double *)&buf[offset + 4]);
	rcv->sv[i].phase = *((short *)&buf[offset + 12]);
	rcv->sv[i].slip = buf[offset+14];
	rcv->sv[i].snr  = buf[offset+15];
	rcv->sv[i].prn = buf[offset+16];
	rcv->sv[i].valid = (boolean)buf[offset+17];
	/*
	fprintf (stderr,"setting channel %d record to %s\n",
		 i,
		 buf[offset+17]==0 ? "invalid":"valid");
	 */
    }
    
}

/**
 * Read PVT (Position Velocity Time) record into an instance of the
 * garmin_pvt_type structure
 * 
 * @param buf Packet buffer
 * @param pvt_rec Structure to load the PVT record information into
 * 
 */
void garmin_pvt_record (unsigned char *buf, garmin_pvt_type *pvt)
{

   pvt->alt = *((float *)&buf[0]);
   pvt->epe = *((float *)&buf[4]);
   pvt->eph = *((float *)&buf[8]);
   pvt->epv = *((float *)&buf[12]);
   pvt->fix = *((short *)&buf[16]);
   pvt->tow = *((double *)&buf[18]);
   pvt->lat = *((double *)&buf[26]);
   pvt->lon = *((double *)&buf[34]);
   pvt->lon_vel = *((float *)&buf[42]);
   pvt->lat_vel = *((float *)&buf[46]);
   pvt->alt_vel = *((float *)&buf[50]);

    if (DEBUG)
    {
	fprintf (stderr, "garmin_pvt_record: TOW=%f\n",pvt->tow);
    }
    
}


/*
 * Read next byte from the data stream taking care of the DLE and ETX
 * escaping (byte stuffing)
 * 
 * Uses two global integers: chksum for checksum calculcations and
 * 'state' to preserve data stream state. Don't particularly like using
 * globals but 'till do for the moment.
 * 
 * This code is taken almost verbatim from the Garmin GPS 25LP manual.
 * (available in PDF format via the Garmin web site at http://www.garmin.com/)
 */
int garmin_get_data_byte (FILE *fp)
{
    static int byte_count;
    int c, chksum;
    
    if (DEBUG) 
    {
	byte_count++;
    }
    
    while (!feof(fp)) 
    {
	c = getc(fp);
	chksum +=c ;
	if (state == DAT) 
	{
	    if (c == DLE) 
	    {
		state=DLE;
	    } 
	    else 
	    {
		return c;
	    }
	} 
	else 
	{
	    if (state == DLE) 
	    {
		if (c == ETX) 
		{
		    state=ETX;
		} 
		else 
		{
		    state=DAT;
		    return c;
		}
	    } 
	    else 
	    {
		if (state == ETX) 
		{
		    if (c == DLE) 
		    {
			state=DLE;
		    }
		}
	    }
	}
    } /* end of while loop */
    
    return 0; /* FIXME? */
}

void garmin_skip_to_next_record (FILE *fp)
{
    /* Skip to first valid record */
    while (1) 
    {

	if (feof(fp)) return;
	
	while ( getc(fp) != DLE)
	{
	    if (feof(fp)) return;
	}
	
	if ( getc(fp) == ETX) 
	{
	    if (getc(fp) == DLE) 
	    {
		state = DAT;
		return;
	    }
	}
    }
}
