/*types.h -- interface to types.c
  Copyright (C) 1997-2002 Free Software Foundation, Inc.

  Authors: Jukka Virtanen <jtv@hut.fi>
           Peter Gerwinski <peter@gerwinski.de>
           Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2, or
  (at your option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */

#ifndef _GPC_TYPES_H_
#define _GPC_TYPES_H_

/* Include files needed by this one. */


/* Structure definitions. */


/* Global objects accessed by users of this module. */

extern void cstring_inform PARAMS ((void));
extern void ptrarith_inform PARAMS ((void));
extern tree convert PARAMS ((tree, tree));

/* Declare functions with prototypes. */

/* Sets */
extern tree construct_set_member PARAMS ((tree, tree));
extern tree build_set_constructor PARAMS ((tree));
extern tree construct_set PARAMS ((tree, tree, int));
extern tree check_set_bounds PARAMS ((tree, tree));
extern tree build_set_type PARAMS ((tree, int));
extern tree assign_set PARAMS ((tree, tree));

/* Strings */
extern tree assign_string PARAMS ((tree, const tree));
extern tree convert_to_cstring PARAMS ((tree));
extern tree string_may_be_char PARAMS ((tree));
extern tree build_pascal_string_schema PARAMS ((tree));
extern int is_string_compatible_type PARAMS ((tree, int));
extern int is_string_type PARAMS ((tree, int));
extern int is_of_string_type PARAMS ((tree, int));
extern int declared_string_capacity PARAMS ((tree));
extern int no_declared_string_capacity PARAMS ((tree));
extern int is_variable_string_type PARAMS ((tree));

/* Schemata */
extern tree maybe_schema_discriminant PARAMS ((tree));
extern tree build_schema_type PARAMS ((tree, tree));
extern int number_of_schema_discriminants PARAMS ((tree));
extern int is_schema_discriminant_access PARAMS ((tree, tree));
extern void prediscriminate_schema PARAMS ((tree));

/* Other Pascal types */
extern tree base_type PARAMS ((tree));
extern tree build_file_type PARAMS ((tree, tree, int));
extern tree build_record_variant_part PARAMS ((char *, int, tree, tree));
extern tree grok_packed PARAMS ((tree));
extern int is_packed_field PARAMS ((tree));
extern tree expand_packed_field PARAMS ((tree, tree));
extern tree count_bits PARAMS ((tree));
extern tree p_grokfields PARAMS ((tree, tree));
extern tree pascal_array_type_nelts PARAMS ((tree));
extern tree object_size PARAMS ((tree));
extern int int_cst_lt_always PARAMS ((tree, tree));
extern tree select_signed_integer_type PARAMS ((tree));
extern tree select_integer_type PARAMS ((tree, tree, enum tree_code));
extern tree build_pascal_range_type PARAMS ((tree, tree));
extern tree build_pascal_subrange_type PARAMS ((tree, tree, int));
extern tree build_pascal_pointer_type PARAMS ((tree, int));
extern tree build_pascal_array_type PARAMS ((tree, tree));
extern tree build_pascal_array_ref PARAMS ((tree, tree));
extern tree make_signed_range PARAMS ((tree, tree));
extern tree convert_type_to_range PARAMS ((tree));
extern int requested_set_size;

#endif /* _GPC_TYPES_H_ */
