/*Language-specific hook definitions for Pascal front end.
  Copyright (C) 1991-2002 Free Software Foundation, Inc.

  Authors: Jukka Virtanen <jtv@hut.fi>
           Jan-Jaap van der Heijden <j.j.vanderheijden@student.utwente.nl>
           Peter Gerwinski <peter@gerwinski.de>
           Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2, or (at your
  option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */

#include "gbe.h"

#include "gpc-defs.h"
#include "util.h"

/* Each of the functions defined here
   is an alternative to a function in objc-actions.c.  */

void GNU_xref_begin PARAMS ((void));
void GNU_xref_end PARAMS ((void));

#ifdef EGCS

int
lang_decode_option (argc, argv)
     int argc;
     char **argv;
{
  return pascal_decode_option (argc, argv);
}

#else /* not EGCS */

/* Prototypes that are missing in GCC headers */
void lang_init_options PARAMS ((void));
void print_lang_statistics PARAMS ((void));

int
lang_decode_option (p)
     char *p;
{
  return pascal_decode_option (p);
}

#endif /* not EGCS */

void
lang_init_options ()
{
  pascal_init_options ();
}

extern int debug_no_type_hash;

void
lang_init ()
{
#ifndef EGCS97
  /* What type_hash_canon() does is not compatible with, e.g., the
     end_temporary_allocation() call in convert_type_to_range(), so
     disable the former here. Should be a non-issue with GCC-3.0
     without obstacks. */
  debug_no_type_hash = 1;
#endif

  if (option_big_endian == 0 && BYTES_BIG_ENDIAN)
    {
      input_filename = NULL;
      lineno = 0;
      error ("`--little-endian' given, but target system is big endian");
      exit (FATAL_EXIT_CODE);
    }
  if (option_big_endian > 0 && !BYTES_BIG_ENDIAN)
    {
      input_filename = NULL;
      lineno = 0;
      error ("`--big-endian' given, but target system is little endian");
      exit (FATAL_EXIT_CODE);
    }

  /* The following is no joke! The difference between what the
     preprocessor and the compiler think of BYTES_BIG_ENDIAN is
     exactly the problem we're dealing with here. */
  if (flag_print_needed_options)
    {
      #if BYTES_BIG_ENDIAN
      if (!BYTES_BIG_ENDIAN)
        fputs ("--little-endian\n", stderr);
      #else
      if (BYTES_BIG_ENDIAN)
        fputs ("--big-endian\n", stderr);
      #endif
      while (fgetc (finput) != EOF) ;
      exit (1);
    }
  #if BYTES_BIG_ENDIAN
  if (!BYTES_BIG_ENDIAN && option_big_endian < 0)
    {
      input_filename = NULL;
      lineno = 0;
      error ("you must give the option `--little-endian'");
      exit (FATAL_EXIT_CODE);
    }
  #else
  if (BYTES_BIG_ENDIAN && option_big_endian < 0)
    {
      input_filename = NULL;
      lineno = 0;
      error ("you must give the option `--big-endian'");
      exit (FATAL_EXIT_CODE);
    }
  #endif

  pascal_init ();
#if !USE_CPPLIB
  /* The beginning of the file is a new line; check for `#'.
     With luck, we discover the real source file's name from that
     and put it in input_filename. */
  ungetc (check_newline (), finput);
#endif
}

void
lang_finish ()
{
}

#ifdef EGCS97
const char *
#else
char *
#endif
lang_identify ()
{
  return "pascal";
}

void
print_lang_statistics ()
{
}

void
GNU_xref_begin ()
{
  fatal ("GPC does not yet support XREF");
}

void
GNU_xref_end ()
{
  fatal ("GPC does not yet support XREF");
}

/* Called at end of parsing, but before end-of-file processing.  */

void
finish_file ()
{

  /* @@ Is this (and related code in other files) still needed since
        we call the unit constructors and destructors explicitly?
        -- Frank */

#ifndef ASM_OUTPUT_CONSTRUCTOR
  extern tree static_ctors ATTRIBUTE_UNUSED;
#endif
#ifndef ASM_OUTPUT_DESTRUCTOR
  extern tree static_dtors ATTRIBUTE_UNUSED;
#endif
  extern tree build_function_call                 PARAMS ((tree, tree));
#if !defined(ASM_OUTPUT_CONSTRUCTOR) || !defined(ASM_OUTPUT_DESTRUCTOR)
  tree void_list_node = build_tree_list (NULL_TREE, void_type_node);
#endif
#ifndef ASM_OUTPUT_CONSTRUCTOR
  if (static_ctors)
    {
      tree fnname = get_file_function_name ('I');
      start_function (void_list_node,
                      build_parse_node (CALL_EXPR, fnname, void_list_node,
                                        NULL_TREE),
                      NULL_TREE, NULL_TREE, 0);
      fnname = DECL_ASSEMBLER_NAME (current_function_decl);
      store_parm_decls ();

      for (; static_ctors; static_ctors = TREE_CHAIN (static_ctors))
        expand_expr_stmt (build_function_call (TREE_VALUE (static_ctors),
                                               NULL_TREE));

      finish_function (0);

      assemble_constructor (IDENTIFIER_POINTER (fnname));
    }
#endif
#ifndef ASM_OUTPUT_DESTRUCTOR
  if (static_dtors)
    {
      tree fnname = get_file_function_name ('D');
      start_function (void_list_node,
                      build_parse_node (CALL_EXPR, fnname, void_list_node,
                                        NULL_TREE),
                      NULL_TREE, NULL_TREE, 0);
      fnname = DECL_ASSEMBLER_NAME (current_function_decl);
      store_parm_decls ();

      for (; static_dtors; static_dtors = TREE_CHAIN (static_dtors))
        expand_expr_stmt (build_function_call (TREE_VALUE (static_dtors),
                                               NULL_TREE));

      finish_function (0);

      assemble_destructor (IDENTIFIER_POINTER (fnname));
    }
#endif
}

#ifdef EGCS97
/* Return the typed-based alias set for T, which may be an expression
 * or a type.  Return -1 if we don't do anything special.
 */
HOST_WIDE_INT
lang_get_alias_set (t)
     tree t;
{
  return -1;
}
#endif
