#! /usr/local/bin/generate
# $Id: driver.pck 1350 2011-09-16 16:46:58Z darcy $
# driver.pck
# Written by D'Arcy J.M. Cain

# This is a sample script for generate.  It will create a skeleton of
# a System V R4 device driver.  To use this fill in the following defines,
# create a directory, cd to it and run:
#       generate <path>/driver.pck
# where <path> is the directory where this file resides.

# Note that I don't work on System V any more so I haven't tested
# this lately.  Consider it a sample generate script more than
# anything else

# Replace the "xxx" with the tag used by your driver
@DEFINE		TAG		xxx

# The full name of the driver goes here
@DEFINE		NAME	Test driver from generate distribution

# Replace with your name - note escape on apostophe in my name
# Without that you will see the comment because it is within
# a string.  It is not an error to run off the end of a line
# while in a quoted string.  The EOL is effectively an end quote.
@DEFINE		AUTHOR	D\'Arcy J.M. Cain

# Define your email address
@DEFINE		EMAIL	darcy@druid.net

# If you use gcc define this otherwise SVR4 cc is assumed
# To undefine this simply change the '@' to a '#'
@DEFINE		GCC

# If you want an inittab entry enter the command here and uncomment
# by changing the '#' to a '@'
#DEFINE		INIT		\$(BIN)/command

# End of generate custom area - Ignore instructions in the rest of the
# file.  They apply in the files that are built by generate
#-------------------------------------------------------------------

@FILE	Makefile
\# Makefile for $(NAME) driver
\# Written by $(AUTHOR)
!
\# Note that anything that runs su displays the command line so that
\# the builder knows what he/she is getting into.
!
@IFDEF	GCC
CFLAGS =	-O -pipe -ansi -Wall -Wshadow -Wpointer-arith -Wcast-qual \\
!			-Wwrite-strings -Dscanf=DONT_USE_SCANF -Dgets=DONT_USE_GETS
CC =		gcc
@ELSE
CFLAGS =	-O -Xa -v -Dscanf=DONT_USE_SCANF -Dgets=DONT_USE_GETS
@ENDIF
!
@IFDEF	INIT
\# If you don't want to run $(INIT) automatically change
\# "respawn" in the following definition to "off"
RESPAWN =	respawn
@ENDIF
!
\# If you want to build and install all the files but not activate
\# the driver then change the 'Y' here to 'N'.
ACTIVE =	Y
!
\# modify these if things are kept somewhere else on your system
BIN =		/usr/local/bin
MAN =		/usr/share/man/man
CONFBIN =	/etc/conf/bin
INCLUDE =	/usr/include/sys
!
\# You shouldn't have to change anything after this (with the possible
\# exception of Node, see comments below.)  If you do find changes
\# necessary I would appreciate a message at $(EMAIL).  In
\# fact please tell me when you have to make any changes to the package
\# other than above.
!
SU_INSTALL =	"if \$(CONFBIN)/idcheck -p $(TAG);\\
!				then \$(CONFBIN)/idinstall -k -a $(TAG);\\
!				else \$(CONFBIN)/idinstall -k -u $(TAG);\\
!				fi"
SU_UNINSTALL =	"\$(CONFBIN)/idinstall -k -d $(TAG); \$(CONFBIN)/idbuild"
SU_BUILD =		"\$(CONFBIN)/idbuild"
!

@IFDEF		INIT
@DEFINE		INIT_FILE	Init
@ELSE
@DEFINE		INIT_FILE
@ENDIF
SYSFILES =	$(INIT_FILE) Master Name Node System
.SILENT:
!
all:	Driver.o
!

@IFDEF	INIT
Init:	Makefile
!	echo "Creating Init"
!	echo \"$(TAG)0:23:\$(RESPAWN):$(INIT)\" > Init
!
@ENDIF

Master:		Makefile
!	echo "Creating Master"
!	echo \"$(TAG)	ocrwiI	icoH	$(TAG)	0	0	1	4	-1\" > Master
!
Name:		Makefile
!	echo "Creating Name"
!	echo \"$(NAME)\" > Name
!
Node:		Makefile
!	echo "Creating Node"
!	echo "$(TAG)	$(TAG)	c	0" > Node
!
System:		Makefile
!	echo "Creating System"
!	echo "$(TAG)	\$(ACTIVE)	1	0	0	0	0	0	0	0" > System
!
clean:
!	rm -f *.o core \$(SYSFILES) install build $(TAG).shar
!
Driver.o: $(TAG).c
!	echo "Creating Driver.o from $(TAG).c"
!	\$(CC) -c \$(CFLAGS) $(TAG).c
!	mv $(TAG).o Driver.o
!
install:	Driver.o \$(SYSFILES)
!	echo "Installing package files"
!	cp $(TAG).7 \$(MAN)7
!	chmod 644 \$(MAN)7/$(TAG).7
!	echo "I need the root password to run the following command"
!	echo \$(SU_INSTALL)
!	su root -c \$(SU_INSTALL)
!	touch install
!
uninstall:
!	echo \"Removing $(NAME)\"
!	echo "I need the root password to run the following command"
!	echo \$(SU_UNINSTALL)
!	su root -c \$(SU_UNINSTALL)
!	rm -f \$(MAN)7/$(TAG).7
!	rm -f install
!
build:	install
!	echo "Rebuilding kernel"
!	echo "I need the root password to run the following command"
!	echo \$(SU_BUILD)
!	su root -c \$(CONFBIN)/idbuild
!	touch build
!
shar:	$(TAG).shar
!
$(TAG).shar:	Readme Makefile $(TAG).7 $(TAG).c
!	shar -vxf \$^ > $(TAG).shar
!
what:
!	clear
!	echo "The following options are available in this makefile\\n"
!	echo "all:       This is the default.  It makes the driver, the config"
!	echo "           files and the user programs.  Root password is not"
!	echo "           required for this option\\n"
!	echo "shar:      Builds the shar distribution file\\n"
!	echo "install:   Installs the driver - root password required\\n"
!	echo "build:     Installs and builds the driver - root password required\\n"
!	echo "uninstall: Removes the driver - root password required\\n"
!	echo "clean:     Removes files built from distribution"
!

@FILE	Readme
Fill this in with your own information
!
$(AUTHOR)
$(EMAIL)

@FILE	$(TAG).7
.TH XXX 7
.de I
\\fI\$0\\fR
..
.SH NAME
$(TAG) - $(NAME)
.SH DESCRIPTION
Blah blah blah
.SH FILES
/dev/$(TAG)
.SH SEE ALSO
generate(3) (For no good reason)
.SH AUTHOR
$(AUTHOR) ($(EMAIL))
.SH COPYRIGHT
In the spirit of free interchange of (hopefully) high
quality software, this driver is released to the public
domain and can be used for any purposes at all, including
personal, commercial, military, blackmail, etc.

@FILE	$(TAG).c
/*
! * $(TAG).c
! *
! * Written by:	$(AUTHOR)
! *
! *	========================================================
! *	In the spirit of free interchange of { hopefully } high-
! *	quality software, this driver is released to the public
! *	domain and can be used for any purposes at all, including
! *	personal, commercial, military, blackmail, etc.
! *
! *	Have fun, folks.
! *	========================================================
! */
!
\#define		_KERNEL		1
\#include	<limits.h>
\#include	<sys/types.h>
\#include	<sys/param.h>
\#include	<sys/user.h>
\#include	<sys/systm.h>
\#include	<sys/sysmacros.h>
\#include	<sys/inline.h>
\#include	<sys/errno.h>
\#include	<sys/signal.h>
\#include	<sys/dir.h>
\#include	<sys/clock.h>
\#include	<sys/cmn_err.h>
!
\#define		DEBUGx
!
static char	buf[128];

static void	end_timeout(void)
{
\#ifdef	DEBUG
!	printf(\"\\n$(TAG): Rise and shine\");
\#endif
!
!	wakeup((caddr_t)(buf));
}
!

void $(TAG)init(void)
{
!	printf(\"$(NAME)\\n\");
}
!

@FOR	func	read write open close
	void $(TAG)$(func)(dev_t dev)
	{
	\#ifdef	DEBUG
	!	printf(\"$(TAG)$(func): dev_t = %x\\n\", dev);
	\#endif
	}
	!
@END

void $(TAG)ioctl(dev_t dev, int cmd, char *cmdarg)
{
\#ifdef	DEBUG
!	printf(\"$(TAG)ioctl: dev_t = %x - cmd %d [%s]\\n\", dev, cmd, cmdarg);
\#endif
}
