#include <stdio.h>
#include "fluctuate.h"
#if 0
#undef calloc
#undef realloc
#undef strtok

extern FILE *simlog;

#ifdef DMALLOC_FUNC_CHECK
#include "/usr/local/include/dmalloc.h"
#endif


/* Note that 'nelem' argument is long instead of size_t (even though it
   should be size_t) to avoid having to make lots of changes to other code).
*/

void *E_calloc(long nelem, size_t size, char *CallerFile, int CallerLine)
{
	void *vp;

	if ((vp = calloc ((size_t)nelem, size)) != NULL)
		return vp;
	fprintf(ERRFILE, "calloc(%ld, %ld) failed, called from line %d in %s\n",
		nelem, (long)size, CallerLine, CallerFile);
	exit(1);
}

/* Note that 'nelem' argument is long instead of size_t (even though it
   should be size_t) to avoid having to make lots of changes to other code).
*/

void *E_realloc(void *vp, long size, char *CallerFile, int CallerLine)
{
	if ((vp = realloc (vp, (size_t)size)) != NULL)
		return vp;
	fprintf(ERRFILE, 
          "realloc(..., %ld) failed, called from line %d in %s\n",
		(long)size, CallerLine, CallerFile);
	exit(1);
}


FILE *Err_fopen(char *filename, char *mode, char *CallerFile, int CallerLine)
{
	FILE *fp;

	if ((fp = fopen(filename, mode)) != NULL)
		return fp;

	fprintf(ERRFILE, "fopen(%s, %s) failed, called from line %d in %s\n",
		filename, mode, CallerLine, CallerFile);
	exit(1);
}

char *E_strtok(char *newstring, const char *delimiters, char
  *CallerFile, int CallerLine)
{
        char *results;

        if ((results = strtok(newstring,delimiters)) != NULL)
           return(results);

        fprintf(ERRFILE, "strtok failed, called from line %d in %s\n",
           CallerLine, CallerFile);
        fprintf(ERRFILE, 
          "This probably indicates a bad entry in the parmfile.\n");
        exit(1);
}
#endif
