#define VERSION "1.50b"
/* version 1.50b (c) Copyright 1993 by Joseph Felsenstein.
   Written by Joseph Felsenstein, Akiko Fuseki, Sean Lamont, 
   Andrew Keeffe.
   Permission is granted to copy and use this program provided no fee is
   charged for it and provided that this copyright notice is not removed.
*/

/* Modified by Peter Beerli and Jon Yamato for Lamarc package  */

/* machine-specific stuff:
   based on a number of factors in the library stdlib.h, we will try
   to determine what kind of machine/compiler this program is being
   built on.  However, it doesn't always succeed.  However, if you have
   ANSI conforming C, it will probably work.

 we will try to figure out machine type
 based on defines in stdio, and compiler-defined things as well.: */

#ifndef FLUC_INCLUDE
#define FLUC_INCLUDE
#endif

#ifdef  GNUDOS
#define DJGPP
#define DOS
#endif

#ifdef THINK_C
#define MAC
#endif

/*      for Metrowerks compiler
        GENERATINGPOWERPC       - Compiler is generating PowerPC 
                                  instructions
        GENERATING68K           - Compiler is generating 68k
                                  family instructions
        GENERATING68881         - Compiler is generating mc68881
                                  floating point instructions

        SystemSevenFiveOrLater  - Compiled code will only be run on a
                                  System 7.5 or later Macintosh
        SystemSevenOrLater      - Compiled code will only be run
                                  on a System 7.0 or later Macintosh
        SystemSixOrLater        - Compiled code will only be run
                                  on a System 6.0 or later Macintosh */
#ifdef GENERATINGPOWERPC
#define MAC
#endif

#ifdef GENERATING68K
#define MAC
#endif

#ifdef GENERATING68881
#define MAC
#endif

#ifdef SystemSevenFiveOrLater
#define MAC
#endif

#ifdef SystemSevenOrLater
#define MAC
#endif

#ifdef SystemSixOrLater
#define MAC
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef __CMS_OPEN
#define CMS
#define EBCDIC true
#define INFILE "infile data"
#define OUTFILE "outfile data"
#define TREEFILE "treefile data"
#define FONTFILE "fontfile data"
#define PLOTFILE "plotfile data"
#define INTREE "intree data"
#define OUTTREE "outtree data"
#else
#define EBCDIC false
#define INFILE "infile"
#define OUTFILE "outfile"
#define TREEFILE "treefile"
#define FONTFILE "fontfile" /* on unix this might be /usr/local/lib/fontfile */
#define PLOTFILE "plotfile"
#define INTREE "intree"
#define OUTTREE "outtree"
#endif

#ifdef L_ctermid            /* try and detect for sysV or V7. */
#define SYSTEM_FIVE
#endif

#ifdef sequent
#define SYSTEM_FIVE
#endif

#ifndef SYSTEM_FIVE
# include<stdlib.h>
# if defined(_STDLIB_H_) || defined(_H_STDLIB) || defined(H_SCCSID) || defined(unix)
# define UNIX
# define MACHINE_TYPE "BSD Unix C"
# endif
#endif


#ifdef __STDIO_LOADED
# ifdef __DECC /* DEC C version provided by David Mathog */
# define MACHINE_TYPE "OpenVMS DECC"
# else
# define VMS /* probably obsolete VAX C version */
# define MACHINE_TYPE "VAX/VMS C"
# define printf vax_printf_is_broken
# define fprintf vax_fprintf_is_broken
void vax_printf_is_broken(const char *fmt,...);
void vax_fprintf_is_broken(FILE *fp,const char *fmt,...);
void vax_tweak_fmt(char *);
# endif
#endif

#ifdef __WATCOMC__
#define QUICKC
#define WATCOM
#define DOS
#include "graph.h"
#endif
/* watcom-c has graphics library calls that are almost identical to    *
 * quick-c, so the "QUICKC" symbol name stays.                         */


#ifdef _QC
#define MACHINE_TYPE "MS-DOS / Quick C"
#define QUICKC
#include "graph.h"
#define DOS
#endif

#ifdef _DOS_MODE
#define MACHINE_TYPE "MS-DOS /Microsoft C "
#define DOS           /* DOS is  always defined if  on a dos machine */
#define MSC           /* MSC is defined for microsoft C              */
#endif

#ifdef __MSDOS__      /* TURBO c compiler, ONLY (no other DOS C compilers) */
#define DOS
#define TURBOC
#include<stdlib.h>
#include<graphics.h>
#endif

#ifdef DJGPP          /* DJ's gnu  C/C++ port */
#include<graphics.h>
#endif

#ifndef MACHINE_TYPE
#define MACHINE_TYPE "ANSI C"
#endif

#ifdef DOS
#define MALLOCRETURN void 
#else
#define MALLOCRETURN void
#endif
#ifdef VMS
#define signed /* signed doesn't exist in VMS */
#endif

/* default screen types */
#ifdef DOS
#define IBMCRT true
#define ANSICRT false
#else
#ifdef MAC
#define IBMCRT false 
#define ANSICRT false
#else
#define IBMCRT false 
#define ANSICRT true 
#endif
#endif

#ifdef DJGPP
#undef MALLOCRETURN
#define MALLOCRETURN void
#endif


/* includes: */
#ifdef UNIX
#include<strings.h>
#else
#include<string.h>
#endif

#include <math.h>
#include <ctype.h>

#ifdef MAC
#include "mac_interface.h"
#endif

#define FClose(file) if (file) fclose(file) ; file=NULL
#define Malloc(x) mymalloc((long)x)

typedef void *Anyptr;
#define Signed     signed
#define Const     const
#define Volatile  volatile
#define Char        char      /* Characters (not bytes) */
#define Static     static     /* Private global funcs and vars */
#define Local      static     /* Nested functions */

typedef unsigned char boolean;

#define true    1
#define false   0
#define SETBITS 32

#ifdef MAC
MALLOCRETURN    *mymalloc(long);
#else
MALLOCRETURN    *mymalloc();
#endif

#include "nu_constants.h"
#include <float.h>

typedef double          sitelike[4];
typedef sitelike        *ratelike;
typedef ratelike        *phenotype;
typedef char            **sequence;
typedef double          *contribarr;
typedef char            naym[NMLNGTH];
typedef long            longer[5];

typedef struct _node {
  struct _node *next, *back;
  boolean tip;
  long number;
  phenotype x;
  naym nayme;
  boolean top;
  double v, tyme, length;
  long xcoord, ycoord, ymin, ymax;
} node;

  /* this is a list describing the tree as a series of horizontal
     slices of the tree.  Each slice starts at a node, and extends
     down until the next cut is encountered. */
typedef struct tlist {
  struct tlist *prev, *succ;
  node *eventnode;   /* points to a random tip for the tips */
  double age;        /* tyme from tree top                  */
  long numbranch;
  node **branchlist;
} tlist;

typedef struct tree {
  node   **nodep;
  double likelihood;
  node *root;
  tlist *tymelist;
} tree;

typedef struct rlrec {
  double *val;
} rlrec;

typedef struct valrec {
  double rat_xi, rat_xv, zz, z1, y1, ww1, zz1, ww2, zz2, z1zz, z1yy,
     xiz1, xiy1_xv, ww1zz1, vv1zz1, ww2zz2, vv2zz2;
} valrec;

typedef struct dnadata {
  long numseq;          /* number of individuals */
  long sites;           /* number of base pairs */
  sequence seqs;        /* DNA sequences (**char) */
  double freqa, freqc, freqg, freqt, freqr, freqy, freqar, freqcy,
    freqgr, freqty;    /* base frequencies */
  double xi;           /* transition pool prob */
  double xv;           /* transversion pool prob */
  double fracchange;   /* probability of change */
  double ttratio;      /* transition/transversion ratio */
} dnadata;

typedef struct option_struct {
  boolean ctgry, watt, printdata, usertree, progress,
    treeprint, interleaved, ibmpc, ansi, growthused, autocorr, same_ne,
    same_mu, freqsfrom, interact;
  long steps[NUM_TYPE_CHAINS], numchains[NUM_TYPE_CHAINS],
    increm[NUM_TYPE_CHAINS], numout[NUM_TYPE_CHAINS];
} option_struct;

#define FILEP(A,B) (menu ? (A) : (B))
#define ERRFILE FILEP(stderr,simlog)
#define REF_CHAIN(A) (((A) < op->numchains[0]) ? 0 : (A)+1-op->numchains[0])
#define TYPE_CHAIN(A) (((A) < op->numchains[0]) ? 0 : 1)
#define MAX(A,B) (((A) > (B)) ? (A) : (B))
#define EXP(A) (((A) > EXPMAX) ? printf("\n\nTOO BIG\n") : exp(A))

void openfile(FILE **fp, char *filename, char *mode, char *application,
   char *perm);
double randum(void);
boolean readseedfile(long *inseedptr);
void printtymelist(void);
double to_real(double tyme);
double to_magic(double tyme);
double lengthof(node *p);
double howlong(tlist *t);
node *findtop(node *p);

void VarMalloc(node *p, boolean allokate);
void newnode(node **p);
void freenode(node *p);
void newtymenode(tlist **t);
void freetymenode(tlist *t);
void freetymelist(tlist *t);

void hookup(node *p, node *q);
void atr(node *p);

double zerocollis(long numl, long numother, double length);
double onecollis(long numl, long numother, double length);
double twocollis(long numother, double length);

tlist *gettymenode(long target);
tlist *gettyme(node *p, node *daughter1, node *daughter2,
   node *ans);
void inserttymelist(node *prime);
void subtymelist(node *ndonor, node *nrecip);
void ltov(node *p);

void getnums(void);
long boolcheck(char ch);
boolean booleancheck(char *var, char *value);
boolean numbercheck(char *var, char *value);
void readparmfile(void);
void getoptions(void);

void firstinit(void);
void locusinit(void);
void inputoptions(void);
void setuptree(void);
void freetree(void);

boolean sitecompare(long site1, long site2);
void makesiteptr(void);
void getinput(void);

double watterson(void);

void orient(node *p);
void finishsetup(node *p);
void initbranchlist(void);
void inittable(void);
void initweightrat(void);

void treeout(node *p, long s, FILE **usefile);

void evaluate(tree *tr, boolean first);
void nuview(node *p);
void update(node *p);
void smooth(node *p);
void localsmooth(node *p);

boolean testratio(void);

void seekch(char c);
void getch(char *c);
void processlength(node *p);
void addelement(node *p, long *nextnode);
void treeread(void);

void treevaluate(void);
void localevaluate(node *p, node *pansdaught);

void copynode(node *source, node *target);

void joinnode(double length, node *p, node *q);
void constructtree(long numtips, double branchlength);

void updateslide(node *p, boolean wanted);
void rebuildbranch(void);

boolean setlength(long numl, long numother, double tstart, double tlength,
   node *p);
boolean setlength2(long numother, double tstart, double tlength, node *p,
   node *q);
void updatebranch(node *oldans, node *oldp, node *prime);

long counttymelist(tlist *first, tlist *last);

boolean accept_tree(node *prime, node *primans, node *ans,
   node *pansdaught, node *newbr[], tlist *tplus);

boolean slide(void);
void maketree(void);
void finalfree(void);

void memerror(void);

int main(int argc, char *argv[]);
int eof(FILE *f);
int eoln(FILE *f);

/* functions donated by getdata.c */
extern void setupdata(dnadata **dna, long sites, long numseq);
extern void getdata(tree *curtree, dnadata *dna, option_struct *op,
  FILE *infile, FILE *outfile);
extern void freedata(dnadata *dna);
extern void makevalues(dnadata *dna, long categs, tree *curtree);
extern void empiricalfreqs(tree *curtree, dnadata *dna, long *weight);
extern void getbasefreqs(dnadata *dna, option_struct *op, double
  locus_ttratio, FILE *outfile);

/* functions donated by wrap.c */
/* Rich Miller, 4/13/97 */
/*lint -esym(652,calloc,realloc) */
#if 0
#define calloc(nelem,size)  E_calloc((long)(nelem), size, __FILE__, __LINE__)
#define realloc(ptr,size)   E_realloc(ptr, (long)(size), __FILE__, __LINE__)
#define E_fopen(fn,mode)    Err_fopen(fn, mode, __FILE__, __LINE__)
#define strtok(str,delim)   E_strtok(str,delim,__FILE__, __LINE__)

void *E_calloc(long, size_t, char *, int);
void *E_realloc(void *, long, char *, int);
FILE *Err_fopen(char *, char *, char *, int);
char *E_strtok(char *newstring, const char *delimiters, char
  *CallerFile, int CallerLine);
#endif

/* function donated by fluc_modellike.c */
extern void fluc_estimate(long chain, boolean locusend);

/* function donated by coal_modellike.c */
extern double coal_singlechain(long chain, boolean chend, boolean rend);
extern void coal_curveplot(void);
