/*****************************************************************
 * fbthin.c: FBM Release 1.2 19-Apr-93 Michael Mauldin
 *
 * Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbthin.c: Sharpen an image by using a Laplacian edge enhancement
 *
 * USAGE
 *	% fbthin [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:04:40 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbthin.c
 *
 * HISTORY
 * 19-Apr-93  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created from fbsharp.c
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "fbthin [ -<type> ] < 1bit > 1bit"

#ifndef lint
static char *fbmid =
"$FBM fbthin.c <1.2> 19-Apr-93 (C) 1989-1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM input, output;
  int outtype = DEF_8BIT;
  register int i, j;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { 
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointers so alloc_fbm wont be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image first */
  if (read_bitmap (&input, (char *) NULL) &&
      thin_fbm (&input, &output) &&
      write_bitmap (&output, stdout, outtype))
  { exit (0); }
  else
  { exit (1); }
}
