/*****************************************************************
 * fbsharp.c: FBM Release 1.2 07-Apr-93 Michael Mauldin
 *
 * Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbsharp.c: Sharpen an image by using a Laplacian edge enhancement
 *
 * USAGE
 *	% fbsharp [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:04:40 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbsharp.c
 *
 * HISTORY
 * 07-Apr-93  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Added -J switch
 *
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 10-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "fbsharp [ -SF ] beta < 8bit > 8bit"

#ifndef lint
static char *fbmid =
"$FBM fbsharp.c <1.2> 07-Apr-93 (C) 1989-1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ int w, h, k;
  double beta = 2.0;
  FBM input, output;
  int outtype = DEF_8BIT;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { 
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and sharpen it */
  if (read_bitmap (&input, (char *) NULL))
  {
    if (input.hdr.bits != 8 || input.hdr.physbits != 8)
    { fprintf (stderr,
	       "Can't handle images with %d bits and %d physbits per pixel\n",
	       input.hdr.bits, input.hdr.physbits);
      exit (1);
    }

    /* Argument is amount of sharpening */
    if (argc > 0)		{ beta = atof (argv[0]); }

    /* Determine output height & width (oh*ow <= size) */
    h = input.hdr.rows;
    w = input.hdr.cols;
    k = input.hdr.planes;

    fprintf (stderr,
	     "Sharpen \"%s\", beta %1.3lf [%dx%dx%d]\n",
	     input.hdr.title[0] ? input.hdr.title : "(untitled)",
	     beta, w, h, k);

    /* Sharpen the image using a digitial Laplacian */
    if (sharpen_fbm (&input, &output, beta) &&
        write_bitmap (&output, stdout, outtype))
    { exit (0); }
  }
  
  exit (1);
}
