/*****************************************************************
 * fbcat.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbcat.c: 
 *	Convert an image from one format to another.  Input image type
 *	is determined by magic number.  Output is specified by argument.
 *	Note that the ascpect ratio, size and number of colors is not
 *	changed, and that some conversions (such as grayscale to bitmap
 *	or color to gray require more processing than fbcat can do.
 *	For these transformations you must use other programs like
 *	clr2gray, gray2clr, fbhalf, and fbsample.
 *
 * USAGE
 *	% fbcat [ -t'title' -c'credits' ] [ -<type> ] [ image ] > image
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:02:06 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbcat.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 26-Aug-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.96) mlm@cs.cmu.edu
 *
 * 29-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/


# include <stdio.h>
# include "fbm.h"

# define USAGE \
"Usage: fbcat [ -a<aspect> -t'title' -c'credits' ]\n\
	     [ -<type> ] [ image ] > image"

/****************************************************************
 * main
 ****************************************************************/

#ifndef lint
static char *fbmid =
"$FBM fbcat.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM image;
  int outtype = FMT_FBM;
  double aspect = 0.0;
  char *title = NULL, *credits = NULL;
  extern int quality;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      {
	case 'a':	aspect = atof (*argv+1); SKIPARG; break;
	case 't':	title = *argv+1; SKIPARG; break;
	case 'c':	credits = *argv+1; SKIPARG; break;
	case 'q':	quality = atoi (*argv+1); SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointers so alloc_fbm won't be confused */
  image.cm  = image.bm  = (unsigned char *) NULL;

  /* Now read in the image and write an FBM format file */
  if (read_bitmap (&image, (argc > 0) ? *argv : (char *) NULL))
  {
    if (aspect != 0.0)
    { fprintf (stderr,
	       "Overiding aspect ratio read (%1.3lf) with (%1.3lf)\n",
	       image.hdr.aspect, aspect);
      image.hdr.aspect = aspect;
    }

    if (title)
    { strncpy (image.hdr.title, title, FBM_MAX_TITLE); }

    if (credits)
    { strncpy (image.hdr.credits, credits, FBM_MAX_TITLE); }

    if (write_bitmap (&image, stdout, outtype))
    { exit (0);
    }
  }

  exit (1);
}
