BASEDIR	= ..\..
EMULIB	= $(BASEDIR)\EMULib
LIBARM	= $(BASEDIR)\ARM
LIBZ80	= $(BASEDIR)\Z80
LIB6502	= $(BASEDIR)\M6502
LIBGBZ	= $(BASEDIR)\GBZ80
PRIVATE	= $(BASEDIR)\Private

CC	= wcc386
CPP	= wpp386
CFLAGS	= -I.. -I$(EMULIB) -I$(PRIVATE) -zq -oneatx -zp4 -5r -fp3

# EMULib sound, console, and other utility functions 
OBJECTS	= $(EMULIB)\EMULib.obj $(EMULIB)\Image.obj $(EMULIB)\Console.obj \
	  $(EMULIB)\NetPlay.obj $(EMULIB)\Sound.obj
# EMULib platform-specific code
EMUWIN	= $(EMULIB)\LibWin.obj $(EMULIB)\SndWin.obj $(EMULIB)\NetWin.obj
EMUDOS	= $(EMULIB)\LibMSDOS.obj
# .INI file access library
INIFILE	= $(EMULIB)\INIFile.obj
# 720kB floppy utility library
FLOPPY	= $(EMULIB)\Floppy.obj
# Disk image utility library
FDIDISK	= $(EMULIB)\FDIDisk.obj
# Copy-protection library
PROTECT	= $(PRIVATE)\Protect.obj
# CPU emulation libraries
ARM	= $(LIBARM)\ARM.obj $(LIBARM)\ConDebug.obj
Z80	= $(LIBZ80)\Z80.obj $(LIBZ80)\ConDebug.obj
GBZ80	= $(LIBGBZ)\Z80.obj $(LIBGBZ)\ConDebug.obj
M6502	= $(LIB6502)\M6502.obj $(LIB6502)\ConDebug.obj
# TMS9918/9928/9929 VDP emulation
TMS9918	= $(EMULIB)\TMS9918.obj $(EMULIB)\DRV9918.obj
# Disk controller emulation libraries
WD1793	= $(EMULIB)\WD1793.obj
UPD765	= $(EMULIB)\uPD765.obj
WD2793	= $(WD1793)
I8272	= $(UPD765)
# C93xx/C94xx EEPROM chips
C93XX	= $(EMULIB)\C93XX.obj
# Intel 8255 PPI chip
I8255	= $(EMULIB)\I8255.obj
# Sound chip emulation libraries
AY8910	= $(EMULIB)\AY8910.obj
SN76489	= $(EMULIB)\SN76489.obj
YM2413	= $(EMULIB)\YM2413.obj
SCC     = $(EMULIB)\SCC.obj
GBSND	= $(PRIVATE)\GBSND.obj
NESSND	= $(PRIVATE)\NESSND.obj
# Cartridge parsing utilities
NESCART	= $(EMULIB)\NESCarts.obj
GBCART	= $(EMULIB)\GBCarts.obj
GBACART	= $(EMULIB)\GBACarts.obj
DSCART	= $(EMULIB)\DSCarts.obj

.c.obj:
	$(CC) $(CFLAGS) $(DEFINES) -fo=$@ $<
.cc.obj:
	$(CPP) $(CFLAGS) $(DEFINES) -fo=$@ $<
.cpp.obj:
	$(CPP) $(CFLAGS) $(DEFINES) -fo=$@ $<
