/*
   File: edt_edit_ds.h
   Defines the editor datastructures 

   CVS ID: "$Id: edt_edit_ds.h,v 1.2 2002/11/12 13:22:55 marcs Exp $"
*/
#ifndef IncEdtEditDs
#define IncEdtEditDs

/* general includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* libeag includes */
#include <eag_ds.h>

/* Introduce record type definitions */
typedef struct etree_rec *etree_node;	/* syntax tree node */

struct etree_rec
	{ string name;			/* voor tracing */
	  int type;			/* type of node */
	  int nodenr;			/* nr of the alternative? */
	  int nrsons;			/* nr of sons */
	  etree_node *sons;		/* array of son tree nodes */
	  etree_node father;		/* father node */
	  int style;			/* layout style */
	  int width;			/* width */
	  int height;			/* height */
	  int x;			/* x */
	  int y;			/* y */
	};
#define etree_node_nil ((etree_node) NULL)
#define etree_array_nil ((etree_node *) NULL)

/*
   Memory management routines
*/
export etree_node new_etree_node ();
export void free_etree_node (etree_node old);
export etree_node *new_eson_space (int nrsons);
export void free_eson_space (int nrsons, etree_node *old);
export etree_node rdup_etree_node (etree_node org);
export void rfre_etree_node (etree_node old);

/*
   Initialization
*/
export void init_edit_ds ();

#endif /* IncEdtEditDs */
