/*
   File: ebs_value.h
   Define operations on values

   CVSID: "$Id: ebs_value.h,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/
#ifndef IncEbsValue
#define IncEbsValue

/* Introduce record type definitions */
typedef struct value_rec *value;		/* values of all kind */

/* Introduce list definitions */
typedef struct value_list_rec *value_list;	/* value lists */

/* Introduce nil pointers for records */
#define value_nil ((value) NULL)

/* Introduce nil pointers for lists */
#define value_list_nil ((value_list) NULL)

/* Introduce structure of affix values */
#define undefined_value 0
#define string_value 1
#define integer_value 2
#define tuple_value 3
#define small_lattice_value 4
#define large_lattice_value 5
struct value_rec
	{ int admin_nr;				/* meta rule cons nr */
	  int ref_count;			/* reference count */
	  void *dptr;				/* debug ptr */
	  int tag;
	  union
	     { string str;
	       int nr;
	       value_list tuple;
	       int slat;
	       int_list elat;
	       value free;
	     } u;
	};

/* Introduce structure of value lists */
struct value_list_rec
	{ int size;
	  int room;
	  value *array;
	};

/* value manipulation */
export value new_undefined_value ();
export value new_string_value (string s);
export value new_integer_value (int nr);
export value new_tuple_value (value_list vl);
export value new_tuple_value_from_array (int size, value *array);
export value new_small_lattice_value (int slat, string *lnames);
export value new_large_lattice_value (int size, int *elat, string *lnames);
export value new_singleton_value (int eltnr, int size, string *lnames);
export value rdup_value (value val);
export void rfre_value (value old);
export int less_value (value v1, value v2);
export int equal_value (value v1, value v2);
export void save_value (FILE *f, value v);
export int load_value (FILE *f, value *v, string *lnames);

/* value list manipulation */
export value_list new_value_list (int room);
export void room_value_list (value_list vl, int room);
export void free_value_list (value_list vl);
export void app_value_list (value_list sl, value s);
export value_list rdup_value_list (value_list sl);
export void rfre_value_list (value_list old);
export int less_value_list (value_list vl1, value_list vl2);
export int equal_value_list (value_list vl1, value_list vl2);
export void save_value_list (FILE *f, value_list vl);
export int load_value_list (FILE *f, value_list *vl, string *lnames);

/* value calculation */
export value concatenate_values (value_list vl);
export value join_lattice_values (value_list vl);
export int meet_lattice_values (value v1, value v2, value *vret);

/* value tracing and outputting */
export void dump_value (value val);
export void output_value (FILE *out, value val);

/* initialization */
export void init_value ();

#endif /* IncEbsValue */
