/*
   File: ebs_lexds.h
   Defines the datastructures necessary to store a lexicon

   CVSID: "$Id: ebs_lexds.h,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/
#ifndef IncEbsLexDs
#define IncEbsLexDs

/* local includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* Introduce record type definitions */
typedef struct lexend_rec *lexend;
typedef struct lextree_rec *lextree;
typedef struct lexicon_rec *lexicon;

/* Introduce list definitions */
typedef struct lexend_list_rec *lexend_list;
typedef struct lextree_list_rec *lextree_list;

/* Introduce nil pointers for records */
#define lexend_nil ((lexend) NULL)
#define lextree_nil ((lextree) NULL)
#define lexicon_nil ((lexicon) NULL)

/* Introduce nil pointers for lists */
#define lexend_list_nil ((lexend_list) NULL)
#define lextree_list_nil ((lextree_list) NULL)

/* Introduce structure of record type definitions */
struct lexend_rec 
	{ int nodenr;
	  int_list valuenrs;
	};

struct lextree_rec
	{ string remainder;
	  lexend_list prods;
	  lextree_list tails;
	};

struct lexicon_rec
	{ int_list lex_lnames;
	  value_list lex_vals;
	  lextree_list lex_trees;
	};

/* Introduce structure of value lists */
struct lexend_list_rec
	{ int size;
	  int room;
	  lexend *array;
	};

struct lextree_list_rec
	{ int size;
	  int room;
	  lextree *array;
	};

/* lexend manipulation */
export lexend new_lexend (int nodenr, int_list valuenrs);
export lexend rdup_lexend (lexend old);
export void rfre_lexend (lexend old);
export void save_lexend (FILE *f, lexend l);
export int load_lexend (FILE *f, lexend *l);

/* lextree manipulation */
export lextree new_lextree (string remainder,
			    lexend_list prods, lextree_list tail);
export lextree rdup_lextree (lextree old);
export void rfre_lextree (lextree old);
export void save_lextree (FILE *f, lextree l);
export int load_lextree (FILE *f, lextree *l);

/* lexicon manipulation */
export lexicon new_lexicon (int_list lex_lnames, value_list lex_vals,
			    lextree_list lex_trees);
export lexicon rdup_lexicon (lexicon old);
export void rfre_lexicon (lexicon old);
export void save_lexicon (FILE *f, lexicon l);
export int load_lexicon (FILE *f, lexicon *l, string **lnames);
export void csave_lexicon (string fname, lexicon l);
export void cload_lexicon (string fname, lexicon *l, string **lnames);

/* lexend list manipulation */
export lexend_list new_lexend_list ();
export void room_lexend_list (lexend_list ll, int room);
export void app_lexend_list (lexend_list ll, lexend s);
export lexend_list rdup_lexend_list (lexend_list old);
export void rfre_lexend_list (lexend_list old);
export void save_lexend_list (FILE *f, lexend_list ll);
export int load_lexend_list (FILE *f, lexend_list *ll);

/* lextree list manipulation */
export lextree_list new_lextree_list (int room);
export void room_lextree_list (lextree_list ll, int room);
export void app_lextree_list (lextree_list ll, lextree l);
export lextree_list rdup_lextree_list (lextree_list ll);
export void rfre_lextree_list (lextree_list old);
export void save_lextree_list (FILE *f, lextree_list ll);
export int load_lextree_list (FILE *f, lextree_list *ll);

#endif /* IncEbsLexDs */
