/*
   File: ebs_lexds.c
   Defines operations on values

   CVSID: "$Id: ebs_lexds.c,v 1.2 2002/11/12 10:58:37 marcs Exp $"
*/

/* general includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_error.h>
#include <ebs_memalloc.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

/* lexend manipulation */
export lexend new_lexend (int nodenr, int_list valuenrs)
	{ lexend new = (lexend) ckmalloc (sizeof (struct lexend_rec));
	  new -> nodenr = nodenr;
	  new -> valuenrs = valuenrs;
	  return (new);
	};

export lexend rdup_lexend (lexend old)
	{ lexend new = (lexend) ckmalloc (sizeof (struct lexend_rec));
	  new -> nodenr = old -> nodenr;
	  new -> valuenrs = rdup_int_list (old -> valuenrs);
	  return (new);
	};

export void rfre_lexend (lexend old)
	{ rfre_int_list (old -> valuenrs);
	  free (old);
	};

export void save_lexend (FILE *f, lexend l)
	{ save_int (f, l -> nodenr);
	  save_int_list (f, l -> valuenrs);
	};

export int load_lexend (FILE *f, lexend *l)
	{ lexend new = (lexend) ckmalloc (sizeof (struct lexend_rec));
	  if (!load_int (f, &new -> nodenr)) return (0);
	  if (!load_int_list (f, &new -> valuenrs)) return (0);
	  *l = new;
	  return (1);
	};

/* lexend list manipulation */
export lexend_list new_lexend_list ()
	{ lexend_list new =
		(lexend_list) ckmalloc (sizeof (struct lexend_list_rec));
	  new -> size = 0;
	  new -> room = 2;
	  new -> array = (lexend *) ckcalloc (2, sizeof (lexend));
	  return (new);
	};

export void room_lexend_list (lexend_list ll, int room)
	{ if (room <= ll -> room) return;
	  ll -> array =
		(lexend *) ckrecalloc (ll -> array, room, sizeof (lexend));
	  ll -> room = room;
	};

export void app_lexend_list (lexend_list ll, lexend l)
	{ if (ll -> size == ll -> room) room_lexend_list (ll, ll -> size << 1);
	  ll -> array [ll -> size] = l;
	  ll -> size++;
	};

export lexend_list rdup_lexend_list (lexend_list old)
	{ lexend_list new;
	  int ix;
	  if (old == lexend_list_nil) return (lexend_list_nil);
	  new = (lexend_list) ckmalloc (sizeof (struct lexend_list_rec));
	  new -> size = old -> size;
	  new -> room = old -> room;
	  new -> array = (lexend *) ckcalloc (old -> size, sizeof (lexend));
	  for (ix = 0; ix < old -> size; ix++)
	     new -> array[ix] = rdup_lexend (old -> array[ix]);
	  return (new);
	};

export void rfre_lexend_list (lexend_list old)
	{ int ix;
	  if (old == lexend_list_nil) return;
	  for (ix = 0; ix < old -> size; ix++)
	     rfre_lexend (old -> array[ix]);
	  free (old -> array);
	  free (old);
	};

export void save_lexend_list (FILE *f, lexend_list ll)
	{ int ix;
	  save_int (f, ll -> size);
	  for (ix = 0; ix < ll -> size; ix++)
	     save_lexend (f, ll -> array[ix]);
	};

export int load_lexend_list (FILE *f, lexend_list *ll)
	{ int ix, size;
	  lexend_list new = new_lexend_list ();
	  if (!load_int (f, &size)) return (0);
	  room_lexend_list (new, size);
	  new -> size = size;
	  for (ix = 0; ix < size; ix++)
	     if (!load_lexend (f, &new -> array[ix])) return (0);
	  *ll = new;
	  return (1);
	};

/* lextree manipulation */
export lextree new_lextree (string remainder,
			    lexend_list prods, lextree_list tails)
	{ lextree new = (lextree) ckmalloc (sizeof (struct lextree_rec));
	  new -> remainder = remainder;
	  new -> prods = prods;
	  new -> tails = tails;
	  return (new);
	};

export lextree rdup_lextree (lextree old)
	{ lextree new = (lextree) ckmalloc (sizeof (struct lextree_rec));
	  new -> remainder = old -> remainder;
	  new -> prods = rdup_lexend_list (old -> prods);
	  new -> tails = rdup_lextree_list (old -> tails);
	  return (new);
	};

export void rfre_lextree (lextree old)
	{ rfre_lexend_list (old -> prods);
	  rfre_lextree_list (old -> tails);
	  free (old);
	};

export void save_lextree (FILE *f, lextree l)
	{ save_string (f, l -> remainder);
	  save_lexend_list (f, l -> prods);
	  save_lextree_list (f, l -> tails);
	};

export int load_lextree (FILE *f, lextree *l)
	{ lextree new = (lextree) ckmalloc (sizeof (struct lextree_rec));
	  if (!load_string (f, &new -> remainder)) return (0);
	  if (!load_lexend_list (f, &new -> prods)) return (0);
	  if (!load_lextree_list (f, &new -> tails)) return (0);
	  *l = new;
	  return (1);
	};

/* lextree list manipulation */
export lextree_list new_lextree_list (int room)
	{ lextree_list new =
		(lextree_list) ckmalloc (sizeof (struct lextree_list_rec));
	  int mroom = (room <= 0)?1:room;
	  new -> size = 0;
	  new -> room = mroom;
	  new -> array = (lextree *) ckcalloc (mroom, sizeof (lextree));
	  return (new);
	};

export void room_lextree_list (lextree_list ll, int room)
	{ if (room <= ll -> room) return;
	  ll -> array =
		(lextree *) ckrecalloc (ll -> array, room, sizeof (lextree));
	  ll -> room = room;
	};

export void app_lextree_list (lextree_list ll, lextree l)
	{ if (ll -> size == ll -> room)
	     room_lextree_list (ll, ll -> size << 1);
	  ll -> array [ll -> size] = l;
	  ll -> size++;
	};

export lextree_list rdup_lextree_list (lextree_list old)
	{ lextree_list new;
	  int ix;
	  if (old == lextree_list_nil) return (lextree_list_nil);
	  new = (lextree_list) ckmalloc (sizeof (struct lextree_list_rec));
	  new -> size = old -> size;
	  new -> room = old -> room;
	  new -> array =
		(lextree *) ckcalloc (old -> room, sizeof (struct lextree_rec));
	  for (ix = 0; ix < old -> size; ix++)
	     new -> array[ix] = rdup_lextree (old -> array[ix]);
	  return (new);
	};

export void rfre_lextree_list (lextree_list old)
	{ int ix;
	  if (old == lextree_list_nil) return;
	  for (ix = 0; ix < old -> size; ix++)
	     rfre_lextree (old -> array[ix]);
	  free (old -> array);
	  free (old);
	};

export void save_lextree_list (FILE *f, lextree_list ll)
	{ int ix;
	  save_int (f, ll -> size);
	  for (ix = 0; ix < ll -> size; ix++)
	     save_lextree (f, ll -> array[ix]);
	};

export int load_lextree_list (FILE *f, lextree_list *ll)
	{ lextree_list new;
	  int ix, size;
	  if (!load_int (f, &size)) return (0);
	  new = new_lextree_list (size);
	  new -> size = size;
	  for (ix = 0; ix < size; ix++)
	     if (!load_lextree (f, &new -> array[ix])) return (0);
	  *ll = new;
	  return (1);
	};

/* lexicon manipulation */
export lexicon new_lexicon (int_list lex_lnames, value_list lex_vals,
			    lextree_list lex_trees)
	{ lexicon new = (lexicon) ckmalloc (sizeof (struct lexicon_rec));
	  new -> lex_lnames = lex_lnames;
	  new -> lex_vals = lex_vals;
	  new -> lex_trees = lex_trees;
	  return (new);
	};

export lexicon rdup_lexicon (lexicon old)
	{ lexicon new = (lexicon) ckmalloc (sizeof (struct lexicon_rec));
	  new -> lex_lnames = rdup_int_list (old -> lex_lnames);
	  new -> lex_vals = rdup_value_list (old -> lex_vals);
	  new -> lex_trees = rdup_lextree_list (old -> lex_trees);
	  return (new);
	};

export void rfre_lexicon (lexicon old)
	{ rfre_int_list (old -> lex_lnames);
	  rfre_value_list (old -> lex_vals);
	  rfre_lextree_list (old -> lex_trees);
	  free (old);
	};

export void save_lexicon (FILE *f, lexicon l)
	{ save_int_list (f, l -> lex_lnames);
	  save_value_list (f, l -> lex_vals);
	  save_lextree_list (f, l -> lex_trees);
	};

/* still not good enough: lattices in tuples */
private int load_lexicon_value_list (FILE *f, value_list *vl,
				     string **lnames, int_list idxs)
	{ int ix, size;
	  value_list new;
	  if (!load_int (f, &size)) return (0);
	  new = new_value_list (size);
	  new -> size = size;
	  new -> room = size;
	  for (ix = 0; ix < size; ix++)
	     { string *lnm = NULL;
	       int anr;
	       if (ix >= idxs -> size) return (0);
	       anr = idxs -> array[ix];
	       if (anr) lnm = lnames[anr - 1];
	       if (!load_value (f, &new -> array[ix], lnm)) return (0);
	     };
	  *vl = new;
	  return (1);
	};

export int load_lexicon (FILE *f, lexicon *l, string **lnames)
	{ lexicon new = (lexicon) ckmalloc (sizeof (struct lexicon_rec));
	  if (!load_int_list (f, &new -> lex_lnames)) return (0);
	  if (!load_lexicon_value_list (f, &new -> lex_vals,
					lnames, new -> lex_lnames)) return (0);
	  if (!load_lextree_list (f, &new -> lex_trees)) return (0);
	  *l = new;
	  return (1);
	};

export void csave_lexicon (string fname, lexicon l)
	{ FILE *f = fopen (fname, "w");
	  if (f == NULL)
	     panic ("could not open file '%s' for writing", fname);
	  init_save (f);
	  save_lexicon (f, l);
	  finish_save (f);
	  fclose (f);
	};

export void cload_lexicon (string fname, lexicon *l, string **lnames)
	{ FILE *f = fopen (fname, "r");
	  if (f == NULL)
	     panic ("could not open file '%s' for reading", fname);
	  init_load (f);
	  if (!load_lexicon (f, l, lnames))
	     panic ("lexicon file '%s' contains a gnarled lexicon", fname);
	  if (!finish_load (f))
	     panic ("lexicon file '%s' has an invalid checksum", fname);
	  fclose (f);
	};

