/*
   File: eag_textparsing.h
   Defines the routines to parse terminals and terminal sets
   for recursive backup parsing.

   CVSID: "$Id: eag_textparsing.h,v 1.2 2002/11/12 11:02:49 marcs Exp $"
*/
#ifndef IncEagTextparsing
#define IncEagTextparsing

/* general includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

export int nrofparses;
export char *parsebuffer;
export char *iptr;
export char *miptr;
export int mtotal;

export char *eptr;
export char pemsg[];
export void lookahead_failure (char *name);

export void copy_into_parsebuffer (char *src, int len, int col);
export void copy_file_into_parsebuffer (FILE *fd);
export int in_set (char *ptr, char *set);
#define in_lookahead(s) in_set(iptr,s)
#define iptr_at(c) ((*iptr) == c)
export void endofsentence ();
export int currentcolumn ();
export int currentrow ();

/* routines for parsing terminals and semiterminals */
export void parse_terminal ();
export void parse_set ();
export void parse_non_set ();
export void parse_set_star ();
export void parse_non_set_star ();
export void parse_set_plus ();
export void parse_non_set_plus ();
export void parse_set_star_strict ();
export void parse_non_set_star_strict ();
export void parse_set_plus_strict ();
export void parse_non_set_plus_strict ();

/* routines for parsing with lexica */
export void do_lexicon_rule (lexicon the_lexicon, int treenr);
export void do_lexicon_get (lexicon the_lexicon, int treenr);

/* miscellaneous parse routines */
export void fail_if_iptr_at_set ();
export void fail_if_iptr_not_at_set ();
export void increment_nrparses ();
export void init_textparsing (int pbuffer_size);
export void reinit_textparsing ();
export void complain_on_found_parses ();
export void dump_matches ();

/* routines for recognizing meta rules */
export void rec_parse_terminal ();
export void rec_parse_number ();
export void rec_parse_set ();
export void rec_parse_non_set ();
export void rec_parse_set_star ();
export void rec_parse_non_set_star ();
export void rec_parse_set_plus ();
export void rec_parse_non_set_plus ();
export void rec_parse_set_star_strict ();
export void rec_parse_non_set_star_strict ();
export void rec_parse_set_plus_strict ();
export void rec_parse_non_set_plus_strict ();

/* routines for recognizing meta rules through recursive backup parsing */
export void meta_endofsentence ();
export void meta_endofnumber ();
export void recbup_parse_terminal ();
export void recbup_parse_number ();
export void recbup_parse_set ();
export void recbup_parse_non_set ();
export void recbup_parse_set_star ();
export void recbup_parse_non_set_star ();
export void recbup_parse_set_plus ();
export void recbup_parse_non_set_plus ();
export void recbup_parse_set_star_strict ();
export void recbup_parse_non_set_star_strict ();
export void recbup_parse_set_plus_strict ();
export void recbup_parse_non_set_plus_strict ();

#endif /* IncEagTextParsing */
