/*
   File: eag_propagate.h
   Defines the affix propagation mechanism

   CVSID: "$Id: eag_propagate.h,v 1.2 2002/11/12 11:02:48 marcs Exp $"
*/
#ifndef IncEagPropagate
#define IncEagPropagate

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* local includes */
#include <eag_ds.h>

#define crit_pos_has_value(p) \
((p) -> sides[lower_side].a.affx -> val != value_nil)

export value calc_affix_value (pos_node pos, int side);
export void unparse_affix_value (value val, pos_node pos, int side);
export void propagate_affix_value ();
export void propagate_predicate_value ();
export void make_node_delayed ();
#endif /* IncEagPropagate */
