/*
   File: eag_misc.c
   Defines some miscellaneous support routines

   CVSID: "$Id: eag_misc.c,v 1.2 2002/11/12 11:02:49 marcs Exp $"
*/

/* global includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_memalloc.h>
#include <ebs_textstorage.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* libeag includes */
#include <eag_ds.h>
#include <eag_misc.h>

/*
   output affix value on stdout
*/
public void output_affix ()
	{ affix_node affx = popa ();
	  output_value (stdout, affx -> val);
	  callq ();
	  pusha (affx);
	  pushq (output_affix);
	};

/*
   commit cut
*/
public void cut ()
	{ int *p = popip ();
	  *p = 1;
	  callq ();
	  puship (p);
	  pushq (cut);
	};

/*
   make empty strstore
*/
public void make_empty_strstore ()
	{ char c = strstore[0];
	  strstore[0] = '\0';
	  callq ();
	  strstore[0] = c;
	  pushq (make_empty_strstore);
	};

/*
   The end point of all continuation
*/
public void dummy_continuation ()
	{ pushq (dummy_continuation);
	};
