/*
   File: eag_init.c
   Initializes the transducer or recognizer routines

   CVSID: "$Id: eag_init.c,v 1.2 2002/11/12 11:02:49 marcs Exp $"
*/

/* global includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_error.h>
#include <ebs_textstorage.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* libeag includes */
#include <eag_ds.h>
#include <eag_textparsing.h>
#include <eag_init.h>

private int strstore_size;
private int tstack_size;
private int qstack_size;
private int pbuffer_size;
private int ubuffer_size;
private void init_options ()
	{ strstore_size = 100000;
	  tstack_size = 10000;
	  qstack_size = 100000;
	  pbuffer_size = 100000;
	  ubuffer_size = 100000;
	};

private void print_usage ()
	{ wlog ("usage: transducer [flags] [filename]");
	  wlog ("or:    editor [flags] [Xtoolkitoptions] [filename]");
	  wlog ("-h:  provide this help");
	  wlog ("-v:  verbose");
	  wlog ("-db: enable debugging");
	  wlog ("-fv: full verbose");
	  wlog ("-ps [size]: use size as parse buffer size");
	  wlog ("-qs [size]: use size as continuation stack size");
	  wlog ("-ss [size]: use size as string store size");
	  wlog ("-ts [size]: use size as tree stack size");
	  wlog ("-us [size]: use size as unparse buffer size (editor only)");
	  exit (4);
	};

private void syntax_error (string error_string)
	{ error ("error on command line: %s", error_string);
	  print_usage ();
	};

private void scan_size (int *i, int argc, char **argv, int *trgt)
	{ int size;
	  *i += 1;
	  if (*i == argc) syntax_error ("missing integer argument");
	  size = strtol (argv[*i], (char **)NULL, 0);
	  if (size <= 0) syntax_error ("illegal size");
	  if (size > *trgt) *trgt = size;
	  else warning ("specified size < default size, no effect");
	};

private void scan_option (char *ptr, int *i, int argc, char **argv)
	{ if (strcmp (ptr, "h") == 0) print_usage ();
	  else if (strcmp (ptr, "v") == 0) verbose = 1;
	  else if (strcmp (ptr, "db") == 0) debug = 1;
	  else if (strcmp (ptr, "fv") == 0)
	     { verbose = 1; full_verbose = 1; }
	  else if (strcmp (ptr, "ps") == 0)
	     scan_size (i, argc, argv, &pbuffer_size);
	  else if (strcmp (ptr, "qs") == 0)
	     scan_size (i, argc, argv, &qstack_size);
	  else if (strcmp (ptr, "ss") == 0)
	     scan_size (i, argc, argv, &strstore_size);
	  else if (strcmp (ptr, "ts") == 0)
	     scan_size (i, argc, argv, &tstack_size);
	  else if (strcmp (ptr, "us") == 0)
	     scan_size (i, argc, argv, &ubuffer_size);
	  else syntax_error ("illegal option specified");
	};

private FILE *scanargs (int argc, char **argv, char **fname)
	{ FILE *input;
	  int ix;
	  char *name = NULL;
	  for (ix = 1; ix < argc; ix++)
	     { char *arg = argv[ix];
	       if (arg[0] == '-') scan_option (arg+1, &ix, argc, argv);
	       else if (name == NULL) name = arg;
	       else syntax_error ("too many input files specified");
	     };
	  if (name == NULL) input = stdin;
	  else if (!(input = fopen (name, "r")))
	     syntax_error ("could not open input file");
	  *fname = name;
	  return (input);
	};

public int init_transducer (int argc, char **argv, int edit,
			    int *usize, char **fname)
	{ FILE *input;

	  /* primary initialization */
	  init_error ();
	  init_options ();

	  /* command line parsing */
	  input = scanargs (argc, argv, fname);

	  /* initialize data structures */
	  init_textstorage (strstore_size);
	  init_ds (tstack_size, qstack_size);
	  init_textparsing (pbuffer_size);
	  *usize = ubuffer_size;

	  if (edit && (input == stdin)) return (0);
	  copy_file_into_parsebuffer (input);
	  return (1);
	};
