/*
   File: eag_c_interface.c
   Defines the interface between C and EAG for programs in C
   that use parsers generated by EAG

   CVSID: "$Id: eag_c_interface.c,v 1.2 2002/11/12 11:02:49 marcs Exp $"
*/

/* global includes */
#include <stdio.h>
#include <string.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_memalloc.h>
#include <ebs_textstorage.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* libeag includes */
#include <eag_ds.h>
#include <eag_textparsing.h>
#include <eag_c_interface.h>

/* transduce will be generated */
import void transduce ();

private int allocated;
private int room;
private int my_nrps;
private value *my_ivals;
private value **my_cvals;

/* assign input vector */
public void assign_input_affix ()
	{ int nr = popi ();
	  affix_node affx = popa ();
	  value new_val = my_ivals[nr];

	  if (affx -> val != value_nil)
	     { if (equal_value (new_val, affx -> val)) callq ();
	     }
	  else
	     { affx -> val = rdup_value (new_val);
	       if (affx -> mfunc != NULL)
		  { /* check metadefinition */
		    pushv (new_val);
		    pushq (affx -> mfunc);
		    callq ();
		    pop (2);
		  }
	       else callq ();
	       rfre_value (new_val);
	       affx -> val = value_nil;
	     };
	  pusha (affx);
	  pushi (nr);
	  pushq (assign_input_affix);
	};

/* Collect output vector */
private void check_for_space ()
	{ if (nrofparses < allocated) return;
	  if (allocated == room)
	     { int i;
	       value **ocvals = my_cvals;
	       my_cvals = (value **) ckcalloc (room * 2, sizeof (value *));
	       for (i=0; i < room - 1; i++) my_cvals[i] = ocvals[i];
	       room *= 2;
	       ckfree (ocvals);
	     };
	  my_cvals[allocated] = (value *) ckcalloc (my_nrps, sizeof (value));
	  allocated++;
	};

public void collect_output_affix ()
	{ int nr = popi ();
	  affix_node affx = popa ();
	  value new_val = affx -> val;
	  check_for_space ();
	  my_cvals[nrofparses][nr] = rdup_value (new_val);
	  callq ();
	  pusha (affx);
	  pushi (nr);
	  pushq (collect_output_affix);
	};

/*
   Initialize runtime system
   via args ????
*/
#define strstore_size 100000
#define tstack_size 10000
#define qstack_size 100000
#define pbuffer_size 100000
public void init_C_interface ()
	{ init_textstorage (strstore_size);
	  init_ds (tstack_size, qstack_size);
	  init_textparsing (pbuffer_size);
	};

/*
   Reserve space to collect output affixes
*/
public void reserve_collection_space ()
	{ my_nrps = popi ();
	  my_cvals = (value **) ckcalloc (1, sizeof (value *));
	  room = 1;
	  allocated = 0;
	  callq ();
	  pushi (my_nrps);
	  pushq (reserve_collection_space);
	};

/*
   Parse this buffer
*/
public int parse_this_buffer (char *buffer, value *ivals, value ***cvals)
	{ my_ivals = ivals;
	  copy_into_parsebuffer (buffer, strlen (buffer), 0);
	  reinit_ds ();
	  reinit_textparsing ();
	  transduce ();
	  if (nrofparses && cvals) *cvals = my_cvals;
	  return (nrofparses);
	};
