/*
   File: eag_buildtree.h
   Defines the actions necessary for building the syntax tree
   as well as the linkage to the affix tree

   CVSID: "$Id: eag_buildtree.h,v 1.2 2002/11/12 11:02:48 marcs Exp $"
*/
#ifndef IncEagBuildTree
#define IncEagBuildTree

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

/* local includes */
#include <eag_ds.h>

/* building affix nodes */
export affix_node value_to_affix (char *name, value v);
export affix_node string_to_affix (char *name, char *s);
export affix_node integer_to_affix (char *name, int i);
export affix_node make_undefined_affix ();

/* propagation links */
export void add_link (affix_node aff, pos_node pos, int side);
export void delete_link (affix_node aff, pos_node pos);
export void make_affix_link ();

/* tree nodes */
export void make_leaf_node ();
export void make_simple_node ();
export void make_normal_node ();
export void make_lexicon_node (lexend le, value_list vals);
export void make_predicate_node ();
export void make_semipredicate_node ();
export void make_typed_placeholder_node ();
export void make_untyped_placeholder_node ();

/* predicates, leftcorner parsing */
export void update_predicate_node ();
export void exchange_top ();
export void link_son ();
export void link_predicate_son ();

/* debugging */
export void dump_parse_tree_indented (tree_node tnode, int indent);
export void dump_parse_tree ();

#endif /* IncEagBuildTree */
