/*
   File: numbering.h
   Numbers all rules and meta rules so that we may use these numbers
   in matrices to derive the closure of the left corner relation,
   do left recursion detection and other things
  
   CVS ID: "$Id: numbering.h,v 1.2 2002/11/12 13:36:04 marcs Exp $"
*/
#ifndef IncNumbering
#define IncNumbering

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

/* local includes */
#include <tree.h>

export int nr_of_rules;
export int nr_of_alts;
export int nr_of_members;
export int max_members_per_alt;

export rule *all_rules;
export alt *all_alts;
export member *all_members;

export int nr_of_meta_rules;
export int nr_of_meta_alts;
export meta_rule *all_meta_rules;
export meta_alt *all_meta_alts;

export int nr_of_elements;
export element_def *all_elements;

export void do_numbering (int pred);
export void do_element_numbering ();
#endif /* IncNumbering */
