/*
   File: gentree.h
   Defines the actions necessary for building the syntax tree
   of an eag during parse
  
   CVS ID: "$Id: gentree.h,v 1.2 2002/11/12 13:36:01 marcs Exp $"
*/
#ifndef IncGenTree
#define IncGenTree

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

/* local includes */
#include <tree.h>

/* character set manipulation */
export cset new_cset (int kind, string str);
#define rdup_cset(s) new_cset (s -> kind, s -> str)

/* affix manipulation */
export affix new_affix_variable (string nonterminal);
export affix new_affix_terminal (string str);
export affix new_affix_number (int val);
export affix new_affix_semi (cset set);
export affix new_affix_constant (expr cexpr);
export affix rdup_affix (affix a);
export affix_list new_affix_list ();
export void app_affix_list (affix_list al, affix a);
export affix_list rdup_affix_list (affix_list old);

/* affix expression manipulation */
export expr new_expr_single (affix a);
export expr new_expr_compos (affix_list al);
export expr new_expr_concat (affix_list al);
export expr new_expr_union (affix_list al);
export expr rdup_expr (expr e);

/* position manipulation */
export pos new_pos (int kind, expr ex);
export pos rdup_pos (pos p);
export pos new_empty_pos ();
export pos_list new_pos_list ();
export void app_pos_list (pos_list pl, pos p);
export pos_list rdup_pos_list (pos_list old);
export pos_list new_empty_pos_list (int size);

/* member manipulation */
export member new_member_call (string nont, pos_list display);
export member new_member_terminal (string s);
export member new_member_semiterminal (cset s, pos_list display);
export member new_member_cut ();
export member_list new_member_list ();
export void app_member_list (member_list ml, member m);

/* alternative manipulation */
export alt new_alt (pos_list pl, member_list ml);
export alt_list new_alt_list ();
export void app_alt_list (alt_list al, alt a);

/* suntax rule manipulation */
export rule new_rule (string nont, alt_list alts, int lex);
export rule new_external_rule (string nont, alt_list alts, int kind);

/* meta alternative manipulation */
export meta_alt new_meta_alt (expr e);
export meta_alt_list new_meta_alt_list ();
export void app_meta_alt_list (meta_alt_list mal, meta_alt ma);

/* meta rule manipulation */
export meta_rule new_meta_rule (string nont, meta_alt_list alts);
export meta_rule new_external_meta_rule (string nont, int type,
					 int kind, int empty);

/* element definition manipulation */
export element_def new_element_def (string eltnm);

/* element definition list manipulation */
export element_def_list new_element_def_list ();
export void app_element_def_list (element_def_list el, element_def e);

/* element set manipulation */
export element_set new_element_set (element_def_list defs);

/* element set list manipulation */
export element_set_list new_element_set_list ();
export void app_element_set_list (element_set_list el, element_set e);

#endif /* IncGenTree */
