/*
 * DIRB
 *
 * utils.c - Utilidades varias
 * Ultima modificacion: 19/06/2005
 *
 */

#include "dirb.h"


/*
 * Lista de funciones:
 *
 * void limpia(char limpia[STRING_SIZE])
 * void barra(char barr[STRING_SIZE])
 * void guardadir(char direccion[STRING_SIZE])
 * void elimina_dupwords(struct words *puntero)
 * FILE *abrir_file(char file[STRING_SIZE])
 * int location_cmp(const char *A, const char *B)
 * void location_clean(const char *cleaned, const char *toelim)
 * void check_url(void);
 * int islistable(char direccion[STRING_SIZE]);
 * char kbhit(void);
 *
 */

/*
 * LIMPIA: Elimina los caracteres (\r), (\n) y ( ) de una cadena
 *
 */

void limpia(char *limpia) {
  char *ptr;

  ptr=(char *)strchr(limpia, '\r');
  if(ptr!=0) *ptr='\0';
  ptr=(char *)strchr(limpia, '\n');
  if(ptr!=0) *ptr='\0';
  ptr=(char *)strchr(limpia, ' ');
  if(ptr!=0) *ptr='\0';

}


/*
 * BARRA: Aade una barra (/) al final de una cadena si no la tiene
 *
 */

void barra(char *barr) {

  if(strncmp(barr+strlen(barr)-1, "\x2f", 1)==0) {
    if(options.debuging>5) printf("[+++++] barra() LAST = 0x2F\n");
    } else {
    strncat(barr, "\x2f", STRING_SIZE-1-strlen(barr));
    }

}


/*
 * GUARDADIR: Guarda un directorio en la lista de directorios
 *
 */

void guardadir(char *direccion) {

  if(!options.silent_mode) printf("                                                                               \r");
  IMPRIME("FOUND: %s\n\t(***) DIRECTORY (*)\n", direccion);
  options.recursion_level++;
  if(options.debuging>4) printf("[++++] guardadir() RECURSION_LEVEL: %d\n", options.recursion_level);
  strncpy(dirlist_final->word, direccion, STRING_SIZE-1);
  dirlist_final->siguiente=(struct words *)malloc(sizeof(struct words));
  memset(dirlist_final->siguiente, 0, sizeof(struct words));
  dirlist_final=dirlist_final->siguiente;
  existant=0;

}


/*
 * ELIMINA_DUPWORDS: Elimina elementos duplicados en una lista de palabras
 *
 */

void elimina_dupwords(struct words *puntero) {
  struct words *epun;
  struct words *next;
  struct words *prev;

  epun=puntero;

  prev=epun;

  next=epun->siguiente;

  while(epun->siguiente!=0) {

    if(
    (strncmp(epun->word, next->word, STRING_SIZE-1)==0 && !options.insensitive && next->siguiente!=0)
    ||
    (strncasecmp(epun->word, next->word, STRING_SIZE-1)==0 && options.insensitive && next->siguiente!=0)
    ) {

      if(options.debuging>4) printf("[++++] elimina_dupwords() DUP_WORD: %s - %s\n", epun->word, next->word);
	  contador--;
      prev->siguiente=next->siguiente;
      free(next);
      next=prev->siguiente;

      // recursion_level--; (!) En caso de necesitar eliminar directorios duplicados

      } else {
      prev=next;
      next=next->siguiente;
      }

    if(next==0) {
      if(options.debuging>5) printf("[+++++] elimina_dupwords() FIN_loop\n");
      epun=epun->siguiente;
      prev=epun;
      next=epun->siguiente;
      }

    }

}



/*
 * ABRIR_FILE: Abre un fichero de output
 *
 */

FILE *abrir_file(char *file) {
  FILE *desc;

  /*
  if(access (file, F_OK)==0) {
	printf("\n(!) FATAL: File exists, can't overwrite\n");
	exit(-1);
    }
  */

  if((desc=fopen(file, "a"))==0) {
    printf("\n(!) FATAL: Error opening output file: %s\n", file);
    exit(-1);
    }

  return desc;

}


/*
 * LOCATION_CMP: Compara 2 cabeceras Location
 *
 */

int location_cmp(char *A, char *B) {
  int result=0;
  char *ptr=0;

  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;
  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;
  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;

  if(options.debuging>3) printf("[+++] location_cmp() A: %s\n", A);

  ptr=(char *)strchr(B, '/');
  if(ptr!=0) B=ptr+1;
  ptr=(char *)strchr(B, '/');
  if(ptr!=0) B=ptr+1;
  ptr=(char *)strchr(B, '/');
  if(ptr!=0) B=ptr+1;

  if(options.debuging>3) printf("[+++] location_cmp() B: %s\n", B);

  result=strcmp(A, B);

  if(options.debuging>3) printf("[+++] location_cmp() RESULT: %d\n", result);

  return result;

}


/*
 * LOCATION_CLEAN: Elimina una cadena de una cabecera Location
 *
 */

void location_clean(char *cleaned, char *toelim) {
  char *ptr=0;
  char *A=cleaned;

  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;
  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;
  ptr=(char *)strchr(A, '/');
  if(ptr!=0) A=ptr+1;

  ptr=(char *)strstr(A, toelim);

  if(options.debuging>3) printf("[+++] location_clean() TOCLEAN: %s\n", cleaned);

  if(options.debuging>3) printf("[+++] location_clean() TOELIM: %s\n", toelim);

  if(options.debuging>4) printf("[+++] location_clean() PTR: %d\n", (int)ptr);

  if(ptr!=0) {
	strncpy(ptr, ptr+strlen(toelim), strlen(cleaned)-strlen(toelim)-(ptr-cleaned)+1);
    }

  if(options.debuging>3) printf("[+++] location_clean() CLEANED: %s\n", cleaned);

}


/*
 * CHECK_URL: Comprueba que la URL inicial tiene el formato correcto
 *
 */

void check_url(void) {

  if(strncmp(options.url_inicial, "http://", 7)!=0 && strncmp(options.url_inicial, "https://", 8)!=0) {
	printf("\n(!) FATAL: Invalid URL format: %s\n", options.url_inicial);
	printf("	(Use: \"http://host/\" or \"https://host/\" for SSL)\n");
	exit(-1);
    }

}


/*
 * ISLISTABLE: Comprueba si un directorio es listable o no
 *
 */

int islistable(char *direccion) {

  listable=-1;
  get_url(direccion);

  if(listable==-1) listable=0;

  return listable;

}


/*
 * KBHIT: Comprueba si alguna tecla ha sido pulsada (no bloqueante)
 *
 */

char kbhit(void){
  struct timeval tv;
  fd_set read_fd;
  char key = 0;
  static struct termios term;

  tcgetattr(0, &term);
  term.c_lflag &= ~ICANON;
  tcsetattr(0, TCSANOW, &term);

  tv.tv_sec = 0;
  tv.tv_usec = 0;
  FD_ZERO(&read_fd);
  FD_SET(0, &read_fd);

  if(select(1, &read_fd, NULL, NULL, &tv) == -1) key = -1;

  if(FD_ISSET(0, &read_fd)) {
    read(0, &key, 1);
    } else {
	key = 0;
    }

  if(options.debuging>4) printf("[++++] kbhit() %d\n", key);

  return(key);
}


/*
 * CIERRE: Codigo de finalizacion
 *
 */

void cierre(void) {

  if(!options.silent_mode) printf("                                                                               \r");
  IMPRIME("\n-----------------\n");

  IMPRIME("DOWNLOADED: %d - FOUND: %d\n", descargadas, encontradas);

  if(options.saveoutput) fclose(outfile);

  curl_easy_cleanup(curl);

}


//
// CODE2STRING ________________________________________________________________
//

char *code2string(struct code *a, u_int v) {
  int i=0;

  while(a[i].codenum!=v && a[i].codenum!=0xff) {
	i++;
	}

  return a[i].desc;

}


