/*
 * DIRB
 *
 * lanza_ataque.c - Obtiene la wordlist de ataque y lanza get_url sobre cada palabra
 * Ultima modificacion: 19/05/2005
 *
 */

#include "dirb.h"
#include "http_codes.h"



/*
 * LANZA_ATAQUE: Lanza el bucle de peticiones y muestra los resultados
 *
 */

void lanza_ataque(char *url_base, struct words *wordlist) {
  char buffer[STRING_SIZE];
  char purl[STRING_SIZE];
  char purl2[STRING_SIZE];
  struct result pestructura;
  struct result pestructura2;
  struct words *muts_current;
  int alert_found;
  int alert_401;
  int alert_403;
  int alert;
  char location_temp[STRING_SIZE];
  char unbased[STRING_SIZE];
  char siempre_base[STRING_SIZE];
  int character=0;


  // Inicializamos

  memset(siempre_base, 0, STRING_SIZE);
  alert_found=0;
  alert_401=0;
  alert_403=0;
  alert=0;


  IMPRIME("\n---- Scanning URL: %s ----\n", url_base);

  strncpy(siempre_base, url_base, STRING_SIZE-1);


  // Bucle de peticiones
  ///////////////////////////////////////////////////////////////////////////////

  while(1) {

    // Inicializamos cada bucle

    memset(&pestructura, 0, sizeof(struct result));
    memset(buffer, 0, STRING_SIZE);
    memset(purl, 0, STRING_SIZE);
    memset(location_temp, 0, STRING_SIZE);
    memset(unbased, 0, STRING_SIZE);
    existant=1;
    fflush(outfile);


    // Comprobamos si hay que dar otra vuelta

    if(options.debuging>2) printf("[++] lanza_ataque() ALERT: %d\n", alert);

    if(wordlist->siguiente==0 || alert) {

      if(options.recursion_level>0 && !options.dont_recurse && resuming==0) {
        alert=0;
        alert_401=0;
        alert_403=0;
        alert_found=0;

        if(options.debuging>2) printf("[++] lanza_ataque() RECURSE: %d\n", options.recursion_level);

        //elimina_dup_addr(dirlist_current); (!) En teoria no debe haber duplicados

        memset(url_base, 0, STRING_SIZE);
        strncpy(url_base, dirlist_current->word, STRING_SIZE-1);
        limpia(url_base);
        if(!options.silent_mode) printf("                                                                               \r");
        IMPRIME("\n---- Entering directory: %s ----\n", url_base);
        wordlist=wordlist_base;
        dirlist_current=dirlist_current->siguiente;
        options.recursion_level--;

        // Comprobamos si el directorio es listable

		if(islistable(url_base)!=0) {
          IMPRIME("(!) WARNING: Directory IS LISTABLE. No need to scan it.\n");
          IMPRIME("\t(Use mode '-w' if you want to scan it anyway)\n");
          if(options.exitonwarn) {
			alert=1;
			continue;
		    }
	    }


	    // Pregumtamos si esta activada la opcion interactive

		if(options.interactive) {
		  printf("(?) Do you want to scan this directory (y/n)? ");
		  fflush(stdout);
		  while(character!='n' && character!='y') character=kbhit();
		  if(options.debuging>4) printf("[++++] lanza_ataque() CHAR: %d\n", character);
		  if(character=='n') {
			printf("\nSkipping directory.\n");
			alert=1;
			continue;
		    }
		  }

        continue;

        } else {
        if(options.debuging>4) printf("[++++] lanza_ataque() Se acabo la wordlist\n");
        break;
        }

      }




    // Obtenemos la palabra de la lista

    strncpy(buffer, wordlist->word, STRING_SIZE-1);
    limpia(buffer);

    wordlist=wordlist->siguiente;

    if(options.debuging>3) if(!options.silent_mode) printf("                                                                               \r");
    if(options.debuging>3) printf("[+++] lanza_ataque() PALABRA: %s\n", buffer);


    // Generamos la URL y la limpiamos

    strncpy(purl, url_base, STRING_SIZE-1);
    strncat(purl, buffer, STRING_SIZE-1-strlen(url_base));

    if(strncmp(url_base, purl, strlen(purl))==0) {
      if(options.debuging>4) printf("[++++] lanza_ataque() VACIO\n");
      continue;
      }

    // Inicializamos resume

    resuming=0;

	strncpy(options.current_word, buffer, STRING_SIZE-1);
	strncpy(options.current_dir, url_base, STRING_SIZE-1);

    if(descargadas % DUMP_TIMEOUT == 0) dump();


    // Hacemos la peticion

    pestructura=get_url(purl);


    // Mostramos los resultados

    if(options.debuging>3) printf("[+++] lanza_ataque() ESTADO: %d\n", pestructura.estado);

    descargadas++;
    if(!options.silent_mode) printf("                                                                               \r");
    if(!options.silent_mode) printf("--> Testing: %s\r", pestructura.url);
    if(!options.silent_mode) fflush(stdout);


    // -------------------------------- HOTKEYS -------------------------------

    // Comprobamos si se ha pulsado la tecla n

	character=kbhit();

    if(character=='n') {
      if(!options.silent_mode) printf("                                                                               \r");
	  IMPRIME("Key 'n' pressed. Going to next directory.\n");
	  alert=1;
	  }

    // Comprobamos si se ha pulsado la tecla s

    if(character=='q') {
      if(!options.silent_mode) printf("                                                                               \r");
	  IMPRIME("Key 'q' pressed. Dumping session state and Quiting.\n");
	  dump();
	  cierre();
	  exit(0);
	  }

	// ------------------------------------------------------------------------


    // Analisis del codigo devuelto

    switch(pestructura.codigo_http) {

      case 200:
        alert_401=0;
        alert_403=0;

        if(options.finetunning==1) {
		  memset(unbased, 0, STRING_SIZE);
		  strncpy(unbased, purl+strlen(siempre_base), STRING_SIZE-1);
		  pestructura.body_size=pestructura.body_words;
	      }

        if(nec.codigo_http==200 && pestructura.body_size==nec.body_size) {
		  existant=0;
          } else {
          if(options.debuging>3) printf("[+++] lanza_ataque() 200: %d - %d\n", nec.body_size, pestructura.body_size);
	      }
        break;

      case 301:
      case 302:
        alert_401=0;
        alert_403=0;

        if(options.debuging>3) printf("[+++] lanza_ataque() location: %s\n", pestructura.location);

        strncpy(location_temp, pestructura.location, STRING_SIZE-1);

        if(options.finetunning==1) {
		  memset(unbased, 0, STRING_SIZE);
	      strncpy(unbased, purl+strlen(siempre_base), STRING_SIZE-1);
		  location_clean(location_temp, unbased);
		  if(options.debuging>3) printf("[+++] lanza_ataque() CLEANED: %s\n", location_temp);
          }

        if(pestructura.codigo_http==nec.codigo_http && (strncasecmp(location_temp, nec.location, STRING_SIZE-1)==0)) {
          existant=0;
          } else {
          memset(purl2, 0, STRING_SIZE);
          strncpy(purl2, pestructura.url, STRING_SIZE-1);
          barra(purl2);

          if(options.debuging>3) printf("[+++] lanza_ataque() compared: %s - %s\n", pestructura.location, purl2);

          if(location_cmp(pestructura.location, purl2)==0 /*|| isdir(purl2)==1*/) guardadir(purl2);
          }
        break;

      case 401:
        alert_403=0;
        alert_401++;
        if(alert_401>MAX_ALERT) {
          if(!options.silent_mode) printf("                                                                               \r");
          IMPRIME("(!) WARNING: All responses for this directory seems to be CODE = 401.\n");
          IMPRIME("\t(Changing to the next one - Use mode '-w' if you want to scan it anyway)\n");
          if(options.exitonwarn) {
		  	alert=1;
		    } else {
		    alert_401=0;
		    }
          }

        existant=0;
        memset(purl2, 0, STRING_SIZE);
        memset(&pestructura2, 0, sizeof(struct result));
        strncpy(purl2, pestructura.url, STRING_SIZE-1);
        if(strncmp(purl2+strlen(purl2)-1, "\x2f", 1)==0) {
          memcpy(purl2+strlen(purl2)-1, "_\x00", 2);
          } else {
          memcpy(purl2+strlen(purl2), "_\x00", 2);
          }

        pestructura2=get_url(purl2);

        if(options.debuging>3) printf("[+++] lanza_ataque() PURL2: %d\n", pestructura2.codigo_http);

        if(pestructura2.codigo_http==401) {
          existant=0;
          } else {
          existant=1;
          }
        break;

      case 403:
        alert_401=0;
        alert_403++;
        if(alert_403>MAX_ALERT && nec.codigo_http!=403) {
          if(!options.silent_mode) printf("                                                                               \r");
          IMPRIME("(!) WARNING: All responses for this directory seems to be CODE = 403.\n");
          IMPRIME("\n(Changing to the next one - Use mode '-w' if you want to scan it anyway)\n");
          if(options.exitonwarn) {
			alert=1;
		    } else {
			alert_403=0;
		    }
          }

        existant=0;
        memset(purl2, 0, STRING_SIZE);
        memset(&pestructura2, 0, sizeof(struct result));
        strncpy(purl2, pestructura.url, STRING_SIZE-1);
        if(strncmp(purl2+strlen(purl2)-1, "\x2f", 1)==0) {
          memcpy(purl2+strlen(purl2)-1, "_\x00", 2);
          } else {
          memcpy(purl2+strlen(purl2), "_\x00", 2);
          }

        pestructura2=get_url(purl2);

        if(options.debuging>3) printf("[+++] lanza_ataque() PURL2: %d\n", pestructura2.codigo_http);

        if(pestructura2.codigo_http==403) {
          existant=0;
          } else {
          existant=1;
          }
        break;

      default:
        alert_401=0;
        alert_403=0;
        if(pestructura.codigo_http==nec.codigo_http) {

		  existant=0;

          if(options.finetunning==1 && pestructura.body_size!=nec.body_size) existant=1;

          } else {

          existant=1;

          }
      break;

    }


    // Mostramos la informacion si es interesante

    if(existant) {

      encontradas++;
      if(!options.silent_mode) printf("                                                                               \r");
      IMPRIME("FOUND: %s ", pestructura.url);
      IMPRIME("\n\t(State: %d [%s] - Size: %d)\n", pestructura.codigo_http, code2string(code2message, pestructura.codigo_http), pestructura.body_size);

      if(options.print_location && strlen(pestructura.location)>0) {
        limpia(pestructura.location);
        IMPRIME("\t(Location: '%s')\n", pestructura.location);
        }

      // Aadimos mutaciones

      if(options.mutations_file || options.mutations_list) {

        wordlist_current=wordlist_final;

        // Bucle de extensiones

        muts_current=muts_base;

        while(muts_current->siguiente!=0) {

          // Metemos en la lista

          strncpy(wordlist_current->word, buffer, STRING_SIZE-1);
          strncat(wordlist_current->word, muts_current->word, STRING_SIZE-1-strlen(buffer));

		  contador++;

          wordlist_current->siguiente=(struct words *)malloc(sizeof(struct words));
          wordlist_current=wordlist_current->siguiente;
          memset(wordlist_current, 0, sizeof(struct words));
          muts_current=muts_current->siguiente;

          }

        wordlist_final=wordlist_current;
        elimina_dupwords(wordlist_base);

        }


      // Exceso de eventos repetidos (pasa algo raro)

      alert_found++;

      if(alert_found>MAX_ALERT) {
        if(!options.silent_mode) printf("                                                                               \r");
        IMPRIME("(!) WARNING: Too many responses for this directory seems to be FOUND.\n");
        IMPRIME("\t(Something is going wrong - Try Other Scan Mode)\n");
        IMPRIME("\t(Use mode '-w' if you want to scan it anyway)\n");
        if(options.exitonwarn) exit(-3);
        alert_found=0;
        }

      } else {

      if(options.nothide) {
        if(!options.silent_mode) printf("                                                                               \r");
        IMPRIME("URL: %s ", pestructura.url);
        IMPRIME("\n\t(State: %d [%s] - Size: %d)\n", pestructura.codigo_http, code2string(code2message, pestructura.codigo_http), pestructura.body_size);
        }

      }

    }

}


