/**
 * DDE support to access block device specific functionality
 */
#define DDEKIT_BIO_WRITE 0
#define DDEKIT_BIO_READ  1

/* anonymous structs, maybe one should wrap those? */
struct gendisk;
struct bio;


struct ddekit_bd_geometry {
      unsigned char  heads;
      unsigned char  sectors;
      unsigned short cylinders;
      unsigned long  start;
};

struct ddekit_bd_disk {
    struct gendisk *disk;
    int partno;
    unsigned long start_sector;
    unsigned long sectors;
};


/*
 * Find a blockdevice with a specific name and return a
 * reference to it when found. otherwise return null pointer
 */
struct ddekit_bd_disk *ddekit_bd_create(const char *name, int partno);

/*
 * Release a block device referenced by d
 */
void ddekit_bd_destroy(struct ddekit_bd_disk *d);

int
ddekit_bd_get_geom(struct ddekit_bd_disk *disk,
                   struct ddekit_bd_geometry *geom);

/*
 * callback function type for completed transfers
 */
typedef void (*bio_end_callback_t)(void *priv_data, unsigned int bytes_done);

/*
 * set callback function for completed file transfers
 */
bio_end_callback_t
ddekit_bd_register_callback(bio_end_callback_t callback);

/*
 * allocate a data transfer from/to block device with sg_count entries
 */
struct bio *
ddekit_bd_create_bio(struct ddekit_bd_disk *disk,
                     unsigned long start_sector,
                     unsigned sg_count);
/*
 * set i-th scatter/gather vector
 */
int
ddekit_bd_add_bio_io(struct bio *b,
                     unsigned i,
					 unsigned long addr,
					 unsigned long size);

/*
 * issue data transfer referenced by b,
 * after the transfer is finished the callback function is called
 * and the transfer is freed.
 */
void ddekit_bd_submit_bio(struct bio *b, void *priv_data, int is_read);

/*
 * add/ remove memory to the dde internal page cache
 */
void ddekit_bd_page_cache_add(unsigned long data_address, unsigned long data_size);
void ddekit_bd_page_cache_remove(unsigned long data_address, unsigned long data_size);

/*
 * Enable or disable write cache for a specific device.
 *
 * returns 0 on success
 */
int ddekit_bd_wc_set(struct ddekit_bd_disk *disk, int wc_enable);

/*
 * is write cache enabled for device referenced by d
 */
int ddekit_bd_wc_get(struct ddekit_bd_disk *d);


/*
 * flushes buffer cache of the block device referenced by d
 *
 * return 0 on success
 */
int ddekit_bd_flush(struct ddekit_bd_disk *d);
