#include <linux/input.h>
#include "minix.h"
#include "map.h"

struct myevdev {
	int is_open;
	struct input_handle handle;
};

static void event_cb(struct input_handle *handle, unsigned int type,
                             unsigned code, int value)
{
	/* if keyboard event:*/
	if (type == 1) {
		minix_send_event(type, keycode2scancode[code], value);
	}
}

static int connect_cb(struct input_handler *handler,
                 struct input_dev *dev, const struct input_device_id *id)
{
	struct myevdev *ed = kmalloc(sizeof(struct myevdev), GFP_KERNEL);
	int res;

	ed->handle.dev = dev;
	ed->handle.handler = handler;
	ed->handle.private = ed;

	res = input_register_handle(&ed->handle);

	if (res) {
		/* TODO: error */
	}

	res = input_open_device(&ed->handle);

	if (res) {
		/* TODO: error */
	}

	ed->is_open = 1;

	return 0;
}

static void disconnect_cb(struct input_handle *handle)
{
	struct myevdev * ed = (struct myevdev *)handle->private;

	if (ed->is_open) {
		input_close_device(&ed->handle);
		kfree(ed);
	}
}

static struct input_device_id evdev_ids[] = {
	{.driver_info = 1 }, /* all devices */
	{ } /* terminating enrty */
};

static struct input_handler evdev_handler = {
	.event =  event_cb,
	.connect = connect_cb,
	.disconnect = disconnect_cb,
	.fops = NULL,
	.minor = 0,
	.name = "evdev",
	.id_table = evdev_ids
};

void my_evdev_init()
{
	int res;

	res = input_register_handler(&evdev_handler);

	if (res) {
		/* TODO: ERROR */
	}
}
