/*
 *  Copyright (C) 1999,2001,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: directory.c,v 1.8 2005/02/13 13:13:17 debug Exp $
 */

#include "global.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>


extern char *ip_webbug;
extern char *header_filename;
extern char *footer_filename;
extern char body_textcolor[];
extern char body_bgcolor[];


/*
 *  find_comment():
 *
 *  Given a name and truedirname, return a pointer to a static char
 *  array containing the comment.
 *
 *  If no comment was found, NULL is returned.
 */
static char *find_comment(char *name, char *truedirname)
{
	char *b, *q;
	FILE *f;
	static char s[500];

	b = malloc(strlen(truedirname) + 200);
	if (b == NULL) {
		fprintf(stderr, "out of memory\n");
		exit(1);
	}

	strcpy(b, truedirname);
	strcat(b, "/" COMMENT_FILENAME);
	f = fopen(b, "r");
	if (f == NULL) {
		free(b);
		return NULL;
	}

	while (!feof(f)) {
		s[0]=0; s[499]=0;
		fgets(s, 499, f);
		if (s[0]) {
			if (s[strlen(s)-1]=='\n')
				s[strlen(s)-1]=0;
			if (!strncmp(name, s, strlen(name)) &&
			    (s[strlen(name)]==' ' || s[strlen(name)=='\t'])) {
				/*  Find start of comment:  */
				q = s+strlen(name);
				while (*q==' ' || *q=='\t')
					q++;
				fclose (f);
				free(b);
				return q;
			}
		}
	}

	fclose(f);
	free(b);
	return NULL;
}


off_t find_size(char *name, char *truedirname)
{
	char *s;
	struct stat st;
	int res;

	s = malloc(strlen(name)+strlen(truedirname)+10);
	if (s == NULL) {
		fprintf(stderr, "out of memory in find_size()\n");
		exit(5);	/*  sadfasdgasdgasg todo  */
	}

	sprintf(s, "%s/%s", truedirname, name);
	res = stat(s, &st);
	free(s);

	if (res == 0)
		return st.st_size;
	else
		return 0;
}


/*  Internal: show directory contents recursively:  */
/*  Size 1 is biggest, 6 is smallest...  */
void showdir_recursive(FILE *f, int size, char *truedirname, char *dirname)
{
	struct dirent **dirlist;
	struct stat st, st2;
	int n, i;
	char *name;
	char tmpstr[MAXSTR];
	char tmpstr2[MAXSTR];
	int not_first = 0;
	off_t siz;
	char *cmnt;

	/*  printf ("true=%s dirname=%s\n", truedirname, dirname);  */

	if ( (size>2) || (!truedirname) || (!dirname) )
		return;

	/*  First pass:  directories  */

	n = scandir(truedirname, &dirlist, 0, alphasort);
	if (n < 0)
		return;

	i = 0;
	while (i < n && dirlist[i]) {
		name = dirlist[i]->d_name;
		sprintf(tmpstr, "%s/%s", truedirname, name);
		if (stat(tmpstr, &st) != 0)
			st.st_mode = 0;

#ifdef IGNORE_CVS_DIRECTORIES
		if (strcmp(name, "CVS") == 0) {
			/*  This causes the entry to be skipped:  */
			name[0]='.';
		}
#endif

	/*  Skip "X.html" if there is a file called "X":  */
	if (strlen(tmpstr)>5)
	  if (!strncmp(tmpstr+strlen(tmpstr)-5, ".html", 5))
	    {
	      strcpy (tmpstr2, tmpstr);
	      tmpstr2[strlen(tmpstr2)-5] = '\0';
	      if (stat(tmpstr2, &st2)==0)
		name[0] = '.';
	    }


	if ( (name[0]!='.') && (st.st_mode & S_IFDIR) )
	  {
	    if (size==1)
		fprintf (f, "<tr><td><b>");

	    if ( (size>1) && (not_first) )
		fprintf (f, ", ");
	    else
	      if (size>1)
		fprintf (f, " (");

	    fprintf (f, "<a href=\"%s/index.html\">%s</a>", name, name);

	    if (size==1)
		fprintf (f, "</b>");

	    /*  Recurse into the directory:  */
	    if (size==1)
	      {
		char *cmnt;
		strcpy (tmpstr2, dirname);
		if (tmpstr2[strlen(tmpstr2)-1]!='/')
			strcat (tmpstr2, "/");
		strcat (tmpstr2, name);
/*
 *		showdir_recursive (f, size+1, tmpstr, tmpstr2);
 */
		fprintf (f, "</td>");
		fprintf (f, "<td width=40> </td>");
		fprintf (f, "<td> </td>");  /*  size  */
		fprintf (f, "<td width=40> </td>");

		cmnt = find_comment(name, truedirname);
		if (cmnt != NULL)
			fprintf(f, "<td>%s</td></tr>\n", cmnt);
		else
			fprintf(f, "<td></td></tr>\n");
	      }

	    not_first = 1;
	  }

	/*  Next filename:  */
	i++;
      }


    if (size>1)
      {
	if (not_first)
	  fprintf (f, ")");
	return;
      }

    /*  Second pass:  non-directories  */

    fprintf (f, "<tr><td height=10> </td></tr>\n");

    n = scandir (truedirname, &dirlist, 0, alphasort);
    if (n<0)
	return;

    i = 0;
    while (i<n && dirlist[i])
      {
	name = dirlist[i]->d_name;
	sprintf (tmpstr, "%s/%s", truedirname, name);
	stat (tmpstr, &st);

	/*  Skip "X.html" if there is a file called "X":  */
	if (strlen(tmpstr)>5)
	  if (!strncmp(tmpstr+strlen(tmpstr)-5, ".html", 5))
	    {
	      strcpy (tmpstr2, tmpstr);
	      tmpstr2[strlen(tmpstr2)-5] = '\0';
	      if (stat(tmpstr2, &st2)==0)
		name[0] = '.';
	    }

	if ( (name[0]!='.') && !(st.st_mode & S_IFDIR)
	    && strcmp(name, "index.html")!=0 )
	  {
	    fprintf (f, "<tr><td><a href=\"%s", name);

	    /*  Only add .html to the name if the extension is not .html already:  */
	    if (strlen(name)>5 && strcmp(name+strlen(name)-5, ".html")==0)
			;
	    else
		fprintf (f, ".html");

	    /*  Only add .html to the name if the extension is .c or .h:  */
/*
	    if (strlen(name)>2)
	      if (!strcmp(name+strlen(name)-2, ".c") ||
		  !strcmp(name+strlen(name)-2, ".h"))
		fprintf (f, ".html");
*/

	    fprintf (f, "\">%s</a></td>", name);
	    fprintf (f, "<td width=40> </td>");
	    siz = find_size(name, truedirname);
	    if (siz > 0) {
		if (siz<1024) {
			fprintf(f, "<td align=right>%i bytes</td>", (int)siz);
		} else {
			if (siz<1048576)
				fprintf(f, "<td align=right>%i&nbsp;KB</td>", (int)(siz / 1024));
			else
				fprintf(f, "<td align=right>%i&nbsp;MB</td>", (int)(siz / 1048576));
		}
			} else
				fprintf(f, "<td> </td>");

			fprintf (f, "<td width=40> </td>");

			cmnt = find_comment(name, truedirname);
			if (cmnt != NULL)
				fprintf(f, "<td>%s</td></tr>\n", cmnt);
			else
				fprintf(f, "<td></td></tr>\n");
		}

		/*  Next filename:  */
		i++;
	}
}


/*
 *  do_directory():
 */
void do_directory(char *name)
{
	FILE *f;
	char tmpstr[MAXSTR];
	static int first_dir = 1;

	if (name == NULL)
		return;

	snprintf(tmpstr, MAXSTR, "%s/index.html", name);
	f = fopen (tmpstr, "w");
	if (f == NULL) {
		perror(tmpstr);
		return;
	}

	if (header_filename != NULL) {
		include_relative_html(f, header_filename);
	} else
		fprintf(f, "<html>\n<head><title>Index of %s</title>\n"
		    "<META name=\"robots\" content=\"noindex,nofollow,noarchive\">\n"
		    "</head>\n"
		    "<body text=#%s bgcolor=#%s>\n",
		    name, body_textcolor, body_bgcolor);

	fprintf(f, "<h2>Index of %s</h2>\n"
	    "<table border=0>\n", name);

	/*
	 *  Link to the parent directory.
	 *
	 *  TODO/NOTE: This is ugly. I only want the Parent link to be
	 *  on subdirs, not on the root directory.
	 */
	if (first_dir)
		first_dir = 0;
	else
		fprintf(f, "<tr><td><a href=\"../index.html\">"
		    "(Parent dir)</a><br><br></td><td></td></tr>\n");

	/*  Show the directory contents:  */
	showdir_recursive(f, 1, name, name);

	fprintf(f, "</table>\n");

	if (ip_webbug != NULL)
		fprintf(f, "<img src=\"http://%s/%s\" width=1 height=1>\n", ip_webbug, name);

	if (footer_filename != NULL) {
		include_relative_html(f, footer_filename);
	} else
		fprintf (f, "</body></html>\n");

	fclose(f);
}

