/*
 *  Copyright (C) 1999,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: build_ht.c,v 1.4 2005/02/18 08:38:45 debug Exp $
 *
 *  Build hash table of strings... a rewrite from my old (April 1999)
 *  version.
 *
 *  string_hash_table[h] is a char pointer to all entries with hash
 *  code h.  The entries are separated by a newline char, and after
 *  the last entry for each hash code there is a null char.
 */


#include "global.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>


char **string_hash_table = NULL;
size_t string_hash_table_size = 0;


/*
 *  build_ht():
 *
 *  This function takes an array of char pointers, which should point
 *  to strings of the form "012345 name /path/filename.ext\n".
 *  The strings should be sorted according to their 012345-number.
 *
 *  The return value is a pointer to the hashtable.
 */
char **build_ht(char **strings, int nr_of_strings)
{
	int i, cur_string_no;
	char *cp;	/*  Current position in the database  */
	char line [SHORTSTR];
	char prevline [SHORTSTR];
	int last_hashcode, cur_hashcode;
	size_t totsize;


	/*  Empty the hashentry table:  */
	if (string_hash_table)
		free(string_hash_table);

	/*  See how large a buffer we need: (plus some margin)  */
	totsize = (HASHMASK+1) * sizeof(char *) + 5;
	for (i=0; i<nr_of_strings; i++)
		totsize += (strlen(strings[i]) + 1);

	string_hash_table = (char **) malloc(totsize);
	if (string_hash_table == NULL) {
		fprintf(stderr, "build_ht(): unable to create "
		    "string_hash_table\n");
		exit(1);
	}

	string_hash_table_size = totsize;
	memset(string_hash_table, 0, totsize);

	cp = (char *) (sizeof(char *) * (HASHMASK+1) +
	    (char *)string_hash_table);

	/*
	 *  Read data from strings[].
	 *  A line consists of "HASHCODE string filename". We should add all
	 *  lines sequentially, but end each hashcode section with a '\0' char,
	 *  so that the function reading a hashentry will know when the entry
	 *  is finnished.
	 */

	last_hashcode = -1;
	cur_string_no = 0;
	prevline[0] = '\0';

	while (cur_string_no < nr_of_strings) {
		strlcpy(line, strings[cur_string_no], sizeof line);

		if (isdigit(line[0]) && strcmp(line, prevline) != 0) {
			/*  Get the hashcode from the line:  */
			cur_hashcode = atoi(line);
			if (cur_hashcode < 0 || cur_hashcode >= HASHMASK) {
				fprintf(stderr, "build_ht(): illegal hashcode"
				    " %i found in input! Aborting.\n",
				    cur_hashcode);
				exit(1);
			}

			/*
			 *  If it is not the same as the last hashcode, we have
			 *  to set the pointer to the hashtable entry to point
			 *  to the current position in the database (where the
			 *  hasttable entry is.
			 */
			if (last_hashcode != cur_hashcode) {
				/*
				 *  Write a '\0' char as the end of the last
				 *  hashentry section, but only if
				 *  last_hashcode != -1 !!!
				 */
				if (last_hashcode != -1) {
					*cp = '\0';
					cp ++;
				}
				string_hash_table [cur_hashcode] = cp;
				last_hashcode = cur_hashcode;
			}

			/*
			 *  Now, let's write the string and filename too,
			 *  including the newline char:
			 */
			i = 0;
			while (isdigit(line[i]))
				i++;
			while (line[i]==' ')
				i++;

			/*  here: i should be at the first char of the string */
			strcpy(cp, line+i);
			cp += strlen(line+i);
		}

		strlcpy(prevline, line, sizeof(prevline));
		cur_string_no ++;
	}

	return string_hash_table;
}

