.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.06",
.\"     date            = "23 September 2004",
.\"     time            = "15:01:05 MDT",
.\"     filename        = "bibdup.man",
.\"     address         = "University of Utah
.\"                        Department of Mathematics, 110 LCB
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "23999 128 489 4224",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@computer.org  (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, lexical analysis",
.\"     supported       = "yes",
.\"     docstring       = "This file is the UNIX nroff/troff manual
.\"                        page documentation for bibdup, a tool for
.\"                        checking for duplicate abbreviations and
.\"                        keys in BibTeX bibliography data base
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\"=====================================================================
.\"
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.\"
.\"=====================================================================
.TH BIBDUP 1 "23 September 2004" "Version 1.06"
.\"=====================================================================
.SH NAME
bibdup \- check for duplicate abbreviations and entries in BibTeX \
bibliography data base files
.\"=====================================================================
.SH SYNOPSIS
.B bibdup
.I "<infile"
.I ">outfile"
.nf
or
.fi
.B bibdup
.I "bibfile1 bibfile2 bibfile3 .\|.\|."
.I ">outfile"
.\"=====================================================================
.SH DESCRIPTION
.B bibdup
uses
.BR biblex (1)
to lexically analyze \*(Bi files and
.BR nawk (1)
to check for duplicate @String{.\|.\|.}
abbreviations, and duplicate citation keys.
Letter case is ignored in string comparisons, by
the simple expedient of using
.BR tr (1)
to convert the lexical token stream output by
.BR biblex (1)
to lower case.
.PP
Duplicates are displayed on the standard output in
the form
.RS
.nf
Duplicate string abbreviation ["pub-aw"]:
        # line 1 "ll.bib"
        # line 141 "master.bib"
Duplicate key ["lamport:ldp85"]:
        # line 4 "ll.bib"
        # line 4172 "master.bib"
\&.\|.\|.
.fi
.RE
ANSI/ISO Standard C preprocessor lines identify
the line number and file name where the duplicates
are detected.
.\"=====================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citefind (1),
.BR citesub (1),
.BR citetags (1),
.BR latex (1),
.BR nawk (1),
.BR scribe (1),
.BR tex (1),
.BR tr (1).
.\"=====================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP (Internet)
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
Telephone: +1 801 581 5254
FAX: +1 801 581 4148
.fi
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
