      SUBROUTINE MFFTA9(C,FAC)
*
*   PURPOSE:
*       ELEMENTARY COOLEY-TUKEY RADIX-2 STEP APPLIED TO A VECTOR-OF-
*       2-VECTORS-OF-COMPLEX [IMS,NM [IVS,NV [IES,NE]]], OPTIMIZED FOR
*       SMALL NE MATRICES.
*       SEE REF.[1] FOR NOTATIONS.
*       THIS ROUTINE CAN BE USED ONLY BY ROUTINE MFFTIM, WHICH CONTROLS
*       ITS OPERATION THROUGH COMMON MFFTPA.
*
      COMMON /MFFTPA/  IMS,IVS,IES,NM,NV,NE,MX,LX,MLIM,MSTEP,LLIM,LSTEP,
     $ NUSTEP,IVLIM,ILIM,MD2LIM,LD2LIM
      INTEGER NUSTEP
      COMPLEX C(0:NUSTEP-1,0:1),FAC(0:*),T0
*
      IF(LX.NE.1) THEN
*
      DO 200 MU=0,MLIM,MSTEP
        DO 150 IV=MU,MU+IVLIM,IVS
          ILAMF=0
          DO 100 ILAM=IV,IV+ILIM
            T0=C(ILAM,1)*FAC(ILAMF)
            C(ILAM,1)=C(ILAM,0)-T0
            C(ILAM,0)=C(ILAM,0)+T0
            ILAMF=ILAMF+1
100       CONTINUE
150     CONTINUE
200   CONTINUE
*
      ELSE
      DO 400 MU=0,MLIM,MSTEP
        DO 350 IV=MU,MU+IVLIM,IVS
          DO 300 ILAM=IV,IV+ILIM
          T0=C(ILAM,1)
          C(ILAM,1)=C(ILAM,0)-T0
          C(ILAM,0)=C(ILAM,0)+T0
 300      CONTINUE
 350    CONTINUE
 400  CONTINUE
      ENDIF
*
      END
