#ifndef	__QFTSUBS_H

/*	System include files	*/

#include	<math.h>
#include	<stdio.h>
#include	<stdlib.h>

#include <fftw.h>

/*	QFT function prototypes	*/

void	rfqft(FFTW_REAL *R, FFTW_REAL *I, FFTW_REAL *x, int n, int k);
void	riqft(FFTW_REAL *R, FFTW_REAL *I, FFTW_REAL *x, int n, int k);
void	cfqft(FFTW_REAL *R, FFTW_REAL *I, FFTW_REAL *x, FFTW_REAL *y, int n, int k);
void	rdct(FFTW_REAL *X, FFTW_REAL *x);
void	rdst(FFTW_REAL *X, FFTW_REAL *x);
int	qftinit(int n, void *work);
void	qftclos();

#define	N2		8		/*	1/2 minimum QFT length	*/
#define	NN		(N2*2)	/*	Minimum QFT length		*/
#define	MM		(N2+1)	/*	Minimum pruned length	*/

#define	__QFTSUBS_H

#endif
