// Copyright (c) 1999 Philip A. Hardin (pahardin@cs.utexas.edu)
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License v2 or later.


#include <stdlib.h>        // to get rand(), RAND_MAX
#include <math.h>
#include <sys/time.h>      // to get select()
#include <sys/types.h>
#include <unistd.h>
#include "general.h"
#include "ang2d.h"

const ang2d MA_PI= 1024;   // PI, in machine angles, min. 512


/************************************************************************/
double *sinTbl, *cosTbl;

void InitFixed() {
  // the following never gets freed, but who cares?
  sinTbl= new double[2*MA_PI +MA_PI/2];
  cosTbl= sinTbl +MA_PI/2;
  forii(2*MA_PI +MA_PI/2)
    sinTbl[i]= sin(i*M_PI/MA_PI);
}

void SleepFor(int val)
{ struct timeval tv2;
  tv2.tv_sec=0;
  tv2.tv_usec=val;
  select(0,NULL,NULL,NULL,&tv2);
}

//char *str_dup(char *s)
//{ return strcpy(malloc(strlen(s)+1),s);
//}

// rand(double) could be inlined, but then general.h would need an #include
// to get the symbol RAND_MAX
double rand(double r) {
  return (rand()*r)/RAND_MAX;
}

double factorial(int n) {
  double temp= 1;
  while (n) {temp *= n; n--;}
  return temp;
}
