#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

/* convert Now, Date, and Time */
/* this is tricky since a date type exists in vb but not in php */
/* so try to guess whether we should return a string or an integer (Unix time) */
void convert_now(char *newtoken, char *oldtoken)
{
  if (stringexpr==0)
  {
    sprintf(newtoken,"time()");
    printf("Caution: vb \"%s\" converted to php \"time\". This is ok for doing date calculations, but should be php \"strftime\" if used as a string. (line %d)\n",oldtoken,line);
  }
    else
  if (y2k==1)
  {
    sprintf(newtoken,"strftime(\"%%m/%%d/%%Y %%H:%%M:%%S %%p\")");
    printf("Caution: vb \"%s\" converted to php \"strftime\". This is ok for use as a string, but should be php \"time\" if used in a date calculation. (line %d)\n",oldtoken,line);
  }
    else
  {
    sprintf(newtoken,"strftime(\"%%m/%%d/%%y %%H:%%M:%%S %%p\")");
    printf("Caution: vb \"%s\" converted to php \"strftime\". This is ok for use as a string, but should be php \"time\" if used in a date calculation. (line %d)\n",oldtoken,line);
  }
}


void parse_err_properties(char *newtoken)
{
char token[TOKENSIZE];
int tokentype;

    tokentype=gettoken(token);

#ifdef DEBUG
printf("parse_err_properties(): %s (type=%i)\n",token,tokentype);
#endif

  if (tokentype==TOK_KEYWORD && strcasecmp(token,"number")==0)
  {
    if (line-lastsetline<5)
    {
      /* guess that this is a check to see if the object got created successfully */
      sprintf(newtoken,"($%s ? 0 : 1)",lastsetvar);
    }
    else
    {
      sprintf(newtoken,"0 /* not sure how to convert err.%s */ ",token);
    }
  }
    else
  {
    sprintf(newtoken," /* don't know how to convert err.%s */ ",token);
    printf("Unknown err object function \"%s\" on line: %d\n",token,line);
  }
  
}


/* evaluate the next token read in */

int eval_element(char *newtoken, int tokentype, char *token)
{
char molecule1[LINELENGTH];
char molecule2[LINELENGTH];
char molecule3[LINELENGTH];
char temp[LINELENGTH];
int t,l,objtype;

#ifdef DEBUG
printf("eval_element(): %s (type=%i)\n",token,tokentype);
#endif

  newtoken[0]=0;
  molecule1[0]=0;
  molecule2[0]=0;
  molecule3[0]=0;

  if (tokentype==TOK_KEYWORD && strcasecmp(token,"to")==0)
  { return -1; }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"then")==0)
  { return -1; }
    else
  if (tokentype==TOK_PERIOD)
  { sprintf(newtoken,"->"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"and")==0)
  { sprintf(newtoken," & "); }
    else
  /* handle mod operator - MHB - 4/9/06 */
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"mod")==0)
  { sprintf(newtoken,"%%"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"xor")==0)
  { sprintf(newtoken," ^ "); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"or")==0)
  { sprintf(newtoken," | "); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"server")==0)
  { parse_server(newtoken); }
    else
/*
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"session")==0)
  { printf("hellllo!\n"); parse_session_properties(newtoken); }
    else
*/
  if (strcasecmp(token,"instrrev")==0 || strcasecmp(token,"instrrevb")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"(")!=0)
    { error(token,"(","InStrRev"); }
    eval_molecule(molecule1);
    strcpy(molecule2,"");
    push("(",TOK_PAREN);
    eval_funct(molecule2);
    sprintf(newtoken,"(strrpos(%s,%s) ? strrpos(%s,%s)+1 : 0)",molecule1,molecule2,molecule1,molecule2);
  }
    else
  if (strcasecmp(token,"instr")==0 || strcasecmp(token,"instrb")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"(")!=0)
    { error(token,"(","InStr"); }
    eval_molecule(molecule1);
    strcpy(molecule2,"");
    push("(",TOK_PAREN);
    eval_funct(molecule2);
    sprintf(newtoken,"(strpos(%s,%s) ? strpos(%s,%s)+1 : 0)",molecule1,molecule2,molecule1,molecule2);
  }
    else
  if (strcasecmp(token,"lcase")==0)
  { sprintf(newtoken,"strtolower"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"ucase")==0)
  { sprintf(newtoken,"strtoupper"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"strreverse")==0)
  { sprintf(newtoken,"strrev"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"len")==0 || strcasecmp(token,"lenb")==0)
  { sprintf(newtoken,"strlen"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"mid")==0 || strcasecmp(token,"midb")==0)
  {
    sprintf(newtoken,"substr");
    convert_funct(newtoken,"1,2-1,3",4);
  }
    else
  if (strcasecmp(token,"strcomp")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"(")!=0)
    { error(token,"(","StrComp"); }
    eval_molecule(molecule1);
    strcpy(molecule2,"");
    push("(",TOK_PAREN);
    eval_funct(molecule2);
    sprintf(newtoken,"strcmp(%s,%s)",molecule1,molecule2);
  }
    else
  if (strcasecmp(token,"left")==0 || strcasecmp(token,"leftb")==0)
  { sprintf(newtoken,"substr"); convert_funct(newtoken,"1,@0,2",0); }
    else
  if (strcasecmp(token,"right")==0 || strcasecmp(token,"rightb")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"(")!=0)
    { error(token,"(","Right"); }
    eval_molecule(molecule1);
    strcpy(molecule2,"");
    push("(",TOK_PAREN);
    eval_funct(molecule2);
    sprintf(newtoken,"substr(%s,strlen(%s)-(%s))",molecule1,molecule1,molecule2);
  }
    else
  if (strcasecmp(token,"replace")==0)
  { sprintf(newtoken,"str_replace"); convert_funct(newtoken,"2,3,1",0); }
    else
  /* handle split function - MHB - 4/9/06 */
  if (strcasecmp(token,"split")==0)
  { sprintf(newtoken,"explode"); convert_funct(newtoken,"2,1",0); }
    else
  if (strcasecmp(token,"err")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      parse_err_properties(newtoken);
    }
      else
    {
      push(token,tokentype);
      strcpy(newtoken,"$err");
    }
  }
    else
  if (strcasecmp(token,"session")==0)
  {
    tokentype=gettoken(token);

    if (strcmp(token,".")==0)
    {
      push(token,tokentype);
      parse_session_properties(newtoken);
    }
      else
    if (strcmp(token,"(")==0)
    {
      push(token,tokentype);

      /* sprintf(newtoken,"get_session($sess_dbm,"); */
      eval_funct(newtoken);
      t=session_registered(newtoken);

      if (t!=-1)
      {
        /* strcpy(temp,sessionpool[t]); */
        strcpy(temp,array_get_value(sessionpool,t));
        /* strcat(temp,"_session"); */

        sprintf(newtoken,"$_SESSION['%s']",temp);

/*
        l=strlen(temp);
        strcpy(temp+l-1,"_session");

        strcpy(newtoken,"$");
        strcat(newtoken,temp);
*/

      }
        else
      {
        sprintf(newtoken,"$_SESSION[%s]",newtoken);
        /* fprintf(out,"session_register(%s);\n",newtoken); */
/*
        strcpy(temp,"${");
        strcat(temp,newtoken);
        strcpy(newtoken,temp);
        strcat(newtoken,".\"_session\"}");
*/
        /* fprintf(out,"${%s.\"_sessin\"}\n",newtoken); */
      }

      /* strcat(newtoken,")"); */
    }
      else
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      if (strcasecmp(token,"timeout")==0)
      { strcpy(newtoken,"get_cfg_var(\"session.lifetime\")/60");  }
	else
      { error(token,"?","Session"); }
    }
      else
    { error(token,". (","Session"); }
  }
    else
  if (strcasecmp(token,"empty")==0)
  { sprintf(newtoken,"''"); }
    else
  if (strcasecmp(token,"false")==0 || strcasecmp(token,"vbfalse")==0)
  { sprintf(newtoken,"false"); }
    else
  if (strcasecmp(token,"true")==0 || strcasecmp(token,"vbtrue")==0)
  { sprintf(newtoken,"true"); }
    else
  if (strcasecmp(token,"null")==0 || strcasecmp(token,"nothing")==0)
  { sprintf(newtoken,"null");  }
    else
  if (strcasecmp(token,"array")==0)
  {
    newtoken[0]=0;

    sprintf(newtoken,"array(");
    t=0;

    tokentype=gettoken(token);
    if (strcmp(token,"(")!=0) push(token,tokentype);

    while (1)
    {
      if (t>0) strcat(newtoken,",");
      molecule1[0]=0;
      l=eval_molecule(molecule1);
      strcat(newtoken,molecule1);
      t++;
      if (l!=2) break;
    }

    strcat(newtoken,")");

  }
    else
  if (strcasecmp(token,"lbound")==0)
  { strcpy(newtoken,""); eval_funct(newtoken); strcpy(newtoken,"0"); }
    else
  if (strcasecmp(token,"ubound")==0)
  { sprintf(newtoken,"count"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"chr")==0)
  { sprintf(newtoken,"chr"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"asc")==0)
  { sprintf(newtoken,"ord"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"vartype")==0)
  { sprintf(newtoken,"gettype"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"isobject")==0)
  {
    /* handle a few special cases */
    eval_funct(molecule1);
    if (strcasecmp(molecule1,"$response")==0)
    { strcpy(newtoken,"true"); }
      else
    if (strcasecmp(molecule1,"$wscript")==0)
    { strcpy(newtoken,"false"); }
      else
    { sprintf(newtoken,"is_object(%s)",molecule1); }
  }
    else
  if (strcasecmp(token,"isnumeric")==0)
  { 
    if (php==3)
    { sprintf(newtoken,"IsNumeric"); }
      else
    { sprintf(newtoken,"is_numeric"); }
    convert_funct(newtoken,"1",0);
  }
    else
  if (strcasecmp(token,"isnull")==0)
  { sprintf(newtoken,"!isset"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"isempty")==0)
  { sprintf(newtoken,"empty"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"isarray")==0)
  { sprintf(newtoken,"is_array"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"trim")==0)
  { sprintf(newtoken,"trim"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"rtrim")==0)
  { sprintf(newtoken,"rtrim"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"ltrim")==0)
  { sprintf(newtoken,"ltrim"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"abs")==0)
  { sprintf(newtoken,"abs"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"atn")==0)
  { sprintf(newtoken,"atan"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"tan")==0)
  { sprintf(newtoken,"tan"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"cos")==0)
  { sprintf(newtoken,"cos"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"sin")==0)
  { sprintf(newtoken,"sin"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"exp")==0)
  { sprintf(newtoken,"exp"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"log")==0)
  { sprintf(newtoken,"log"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"clng")==0 || strcasecmp(token,"lng")==0)
  { sprintf(newtoken,"intval"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"cint")==0 || strcasecmp(token,"int")==0)
  { sprintf(newtoken,"intval"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"cdbl")==0)
  { sprintf(newtoken,"doubleval"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"cstr")==0)
  { convert_funct(newtoken,"1",0); stringexpr=1; }
    else
  if (strcasecmp(token,"formatcurrency")==0)
  { sprintf(newtoken,"\"$\".number_format"); convert_funct(newtoken,"1,@2",0); }
    else
  if (strcasecmp(token,"formatnumber")==0)
  { sprintf(newtoken,"number_format"); convert_funct(newtoken,"1,2",0); }
    else
  if ((strcasecmp(token,"ScriptEngine")==0 || strcasecmp(token,"ScriptEngineMajorVersion")==0) ||
     (strcasecmp(token,"ScriptEngineBuildVersion")==0 || strcasecmp(token,"ScriptEngineMinorVersion")==0))
  {
    tokentype=gettoken(token);
    if (strcmp(token,"(")==0)
    { tokentype=gettoken(token); }
      else
    { push(token,tokentype); }
    sprintf(newtoken,"phpversion()");
  }
    else
  if (strcasecmp(token,"randomize")==0)
  { sprintf(newtoken,"srand"); convert_funct(newtoken,"1",0); }
    else
  if (strcasecmp(token,"rnd")==0)
  {
    sprintf(newtoken,"(mt_rand(0,10000000)/10000000)");
    convert_funct(molecule1,"1",0);
/*
    tokentype=gettoken(token);
    if (strcmp(token,"(")==0)
    { tokentype=gettoken(token); }
      else
    { push(token,tokentype); }
*/
  }
    else
  if (strcasecmp(token,"round")==0)
  { sprintf(newtoken,"round"); convert_funct(newtoken,"1,2",0); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"sqr")==0)
  { sprintf(newtoken,"sqrt"); convert_funct(newtoken,"1",0); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"now")==0)
  {
    tokentype=gettoken(token);

    if (strcmp(token,"(")==0)
    {
      while(1)
      {
        tokentype=gettoken(token);
        if (strcmp(token,")")==0 || tokentype==TOK_EOF) break;
      }
    }
      else
    { push(token,tokentype); }
    convert_now(newtoken,"now");
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"dateserial")==0)
  {
    convert_funct(molecule1,"2,3,1",1);
    sprintf(newtoken,"mktime(0,0,0,%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"datepart")==0)
  {
    /* if first parm is a quoted string, then convert it, otherwise give a warning */
    temp[0]=0;
    if ((tokentype=gettoken(token))!=TOK_PAREN)
    { error(token,"(","datepart"); }
      else
    if ((tokentype=gettoken(token))==TOK_DBLQT)
    {
      push2("(",TOK_PAREN);
      if (strcmp(token,"\"yyyy\"")==0)
      { push("\"%Y\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"m\"")==0)
      { push("\"%m\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"y\"")==0)
      { push("\"%j\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"d\"")==0)
      { push("\"%d\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"w\"")==0)
      { push("\"%w\"",TOK_DBLQT); strcpy(temp,"+1"); }
        else
      if (strcmp(token,"\"ww\"")==0)
      {
        push("\"%W\"",TOK_DBLQT);
        printf("Warning: vb \"datepart\" converted to php \"strftime\", but week of the year definition is slightly different. (line %d)\n",line);
      }
        else
      if (strcmp(token,"\"h\"")==0)
      { push("\"%H\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"n\"")==0)
      { push("\"%M\"",TOK_DBLQT); }
        else
      if (strcmp(token,"\"s\"")==0)
      { push("\"%S\"",TOK_DBLQT); }
        else
      {
        push(token,tokentype);
        printf("Warning: vb \"datepart\" converted to php \"strftime\", but don't know how to convert first parameter. (line %d)\n",line);
      }
    }
      else
    {
      push2("(",TOK_PAREN);
      push(token,tokentype);
      printf("Warning: vb \"datepart\" converted to php \"strftime\", but don't know how to convert first parameter. (line %d)\n",line);
    }
    convert_funct(molecule1,"1,2",5);
    sprintf(newtoken,"strftime(%s)",molecule1);
    strcat(newtoken,temp);
    
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"weekday")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%w\",%s)+1",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"date")==0)
  {
    convert_now(newtoken,token);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"time")==0)
  {
    convert_now(newtoken,token);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"year")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%Y\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"monthname")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%F\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"month")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%m\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"hour")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%H\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"minute")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%M\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"second")==0)
  {
    convert_funct(molecule1,"1",5);
    sprintf(newtoken,"strftime(\"%%S\",%s)",molecule1);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"else")==0)
  { 
    fprintf(out,";");
    push2("\r",5);
    push(token,tokentype);

    parse_body(0);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"elseif")==0)
  { 
    fprintf(out,";");
    push2("\r",5);
    push(token,tokentype);
    parse_body(0);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"end")==0)
  { 
    fprintf(out,";\n");
    indent--;
    autoindent();
    indent++;
    fprintf(out,"}\n");

    gettoken(token);
  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"request")==0)
  { parse_request(newtoken); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbcr")==0)
  { sprintf(newtoken,"\"\\r\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbcrlf")==0)
  { sprintf(newtoken,"\"\\r\\n\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbnewline")==0)
  { sprintf(newtoken,"\"\\n\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vblf")==0)
  { sprintf(newtoken,"\"\\n\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbnullchar")==0)
  { sprintf(newtoken,"\"\\0\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbnullstring")==0)
  { sprintf(newtoken,"NULL"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbtab")==0)
  { sprintf(newtoken,"\"\\t\""); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbsunday")==0)
  { sprintf(newtoken,"1"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbmonday")==0)
  { sprintf(newtoken,"2"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbtuesday")==0)
  { sprintf(newtoken,"3"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbwednesday")==0)
  { sprintf(newtoken,"4"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbthursday")==0)
  { sprintf(newtoken,"5"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbfriday")==0)
  { sprintf(newtoken,"6"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbsaturday")==0)
  { sprintf(newtoken,"7"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbblack")==0)
  { sprintf(newtoken,"0x000000"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbred")==0)
  { sprintf(newtoken,"0xff0000"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbgreen")==0)
  { sprintf(newtoken,"0x00ff00"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbyellow")==0)
  { sprintf(newtoken,"0xffff00"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbblue")==0)
  { sprintf(newtoken,"0x0000ff"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbmagenta")==0)
  { sprintf(newtoken,"0xff00ff"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbcyan")==0)
  { sprintf(newtoken,"0xffff00"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"vbwhite")==0)
  { sprintf(newtoken,"0xffffff"); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"set")==0)
  { parse_set(newtoken); }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"new")==0)
  { parse_new(newtoken); }
    else
  if (tokentype==TOK_AMP)
  { sprintf(newtoken,".");  stringexpr=1; }
    else
  if (tokentype==TOK_PERIOD)
  { sprintf(newtoken,"%s",token); }
    else
  if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
  { sprintf(newtoken,"%s",token); }
    else
  if (tokentype==TOK_NUMBER)
  {
    sprintf(newtoken,"%s",token);
    tokentype=gettoken(token);
    if (tokentype==TOK_PERIOD)
    {
      tokentype=gettoken(token);
      strcat(newtoken,".");
      strcat(newtoken,token);
    }
      else
    { push(token,tokentype); }

  }
    else
  if ((tokentype==TOK_ARITHOP || tokentype==TOK_PAREN) ||
        (tokentype==TOK_RELOP))
  { sprintf(newtoken,"%s",token); }
    else
  if (tokentype==TOK_KEYWORD && ((objtype=getobject(token,&t))!=0))
  {
    parse_object(newtoken,token,objtype);
  }
    else
  if ((t=isfunction(token))!=-1)
  {
#ifdef DEBUG
printf("eval_element(): known function (%i)\n",t);
#endif
    if (currdeffunct==t)
    {
      tokentype=gettoken(temp);
      if (strcmp(temp,",")==0 || strcmp(temp,")")==0)
      {
        sprintf(newtoken,"$%s",token);
        push(token,tokentype);
      }
        else
      {
        sprintf(newtoken,"%s",token);
        convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
      }
    }
      else
    {
      sprintf(newtoken,"%s",token);
      convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
    }
  }
    else
  if (isclass(token)==1 || strcasecmp(token,"this")==0)
  {
    sprintf(temp,"$%s->",token);
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    { error(token,".","Class"); }

    tokentype=gettoken(token);
    if (isfunction(token)!=-1)
    {
      sprintf(newtoken,"%s%s",temp,token);
      convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
    }
      else
    {
      sprintf(newtoken,"%s%s",temp,token);
    }
  }
    else
  if (tokentype==TOK_KEYWORD)
  {
    strcase(token);
    sprintf(newtoken,"$%s",token);
    tokentype=gettoken(token);
    push(token,tokentype);
#ifdef DEBUG
printf("eval_element(): found keyword, checking next token (%s)\n",token);
#endif

    if (strcmp(token,"(")==0)
    {
      convert_funct(newtoken,"1,2,3,4,5",20);
    }
      else
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);  /* read period again */
      tokentype=gettoken(token);  /* read method/property of object */

      strcat(newtoken,"->");
      strcat(newtoken,token);

      if (isfunction(token)!=-1)
      {
        convert_funct(molecule1,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
        strcat(newtoken,molecule1);
      }
    }
  }

  if (spacer==1) strcat(newtoken," ");

  return 0;
}

