/*
 * Copyright (c) 2002, Douwe Kiela All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * - Neither name of author nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include <asm2html.h>

void
start_html(struct finfo * files)
{
	fprintf(files->out, "<html>\n<head>\n<title>%s</title>\n<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n", files->filename);
	fprintf(files->out, "<font color=\"#000000\" face=\"verdana\" size=\"1\">\n");
	fprintf(files->out, "<!--\nGenerated with asm2html (by Virtus)\nhttp://virtus.ath.cx/asm2html\n-->\n");
}

void
end_html(FILE * fp)
{
	if (banner) {
		fprintf(fp, "<center>Generated with asm2html by virtus<br><a href=\"http://virtus.ath.cx/asm2html\">http://virtus.ath.cx/asm2html</a></center>\n");
	}
	fprintf(fp, "</font></body>\n</html>\n");
}

void
top_html_file(struct finfo * files)
{
	char            str[100];

	while (!feof(files->top)) {
		fgets(str, 100, files->top);
		if (feof(files->top))
			break;
		fprintf(files->out, "%s", str);
	}
	fclose(files->top);
}

void
bottom_html_file(struct finfo * files)
{
	char            str[100];

	if (banner) {
		fprintf(files->out, "<center>Generated with asm2html by virtus<br><a href=\"http://virtus.ath.cx/asm2html\">http://virtus.ath.cx/asm2html</a></center>\n");
	}
	while (!feof(files->bottom)) {
		fgets(str, 100, files->bottom);
		if (feof(files->bottom))
			break;
		fprintf(files->out, "%s", str);
	}
	fclose(files->bottom);
}
